/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.names.model;

import au.org.ala.names.model.NameIndexField;
import au.org.ala.names.model.RankType;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang3.StringUtils;

public class LinnaeanRankClassification {
    protected String kingdom;
    protected String kid;
    protected String phylum;
    protected String pid;
    protected String klass;
    protected String cid;
    protected String order;
    protected String oid;
    protected String family;
    protected String fid;
    protected String genus;
    protected String gid;
    protected String species;
    protected String sid;
    protected String specificEpithet;
    protected String subspecies;
    protected String infraspecificEpithet;
    protected String scientificName;
    protected String authorship;
    protected String rank;

    public LinnaeanRankClassification() {
    }

    public LinnaeanRankClassification(String kingdom, String phylum, String klass, String order, String family, String genus, String species, String specificEpithet, String subspecies, String infraspecificEpithet, String scientificName) {
        this.kingdom = kingdom;
        this.phylum = phylum;
        this.klass = klass;
        this.order = order;
        this.family = family;
        this.genus = genus;
        this.species = species;
        this.specificEpithet = specificEpithet;
        this.subspecies = subspecies;
        this.infraspecificEpithet = infraspecificEpithet;
        this.scientificName = scientificName;
    }

    public LinnaeanRankClassification(LinnaeanRankClassification cl) {
        this.kingdom = cl.kingdom;
        this.kid = cl.kid;
        this.phylum = cl.phylum;
        this.pid = cl.pid;
        this.klass = cl.klass;
        this.kid = cl.cid;
        this.order = cl.order;
        this.oid = cl.oid;
        this.family = cl.family;
        this.fid = cl.fid;
        this.genus = cl.genus;
        this.gid = cl.gid;
        this.species = cl.species;
        this.sid = cl.sid;
        this.specificEpithet = cl.specificEpithet;
        this.subspecies = cl.subspecies;
        this.infraspecificEpithet = cl.infraspecificEpithet;
        this.authorship = cl.authorship;
        this.scientificName = cl.scientificName;
        this.rank = cl.rank;
    }

    public LinnaeanRankClassification(String kingdom, String phylum, String klass, String order, String family, String genus, String scientificName) {
        this.setKingdom(kingdom);
        this.setPhylum(phylum);
        this.setKlass(klass);
        this.setOrder(order);
        this.setFamily(family);
        this.setGenus(genus);
        this.scientificName = scientificName;
    }

    public LinnaeanRankClassification(String kingdom, String genus) {
        this(kingdom, null, null, null, null, genus, null);
    }

    public String getFamily() {
        return this.family;
    }

    public void setFamily(String family) {
        this.family = family;
    }

    public String getGenus() {
        return this.genus;
    }

    public void setGenus(String genus) {
        this.genus = genus;
    }

    public String getKingdom() {
        return this.kingdom;
    }

    public void setKingdom(String kingdom) {
        this.kingdom = kingdom;
    }

    public String getKlass() {
        return this.klass;
    }

    public void setKlass(String klass) {
        this.klass = klass;
    }

    public String getOrder() {
        return this.order;
    }

    public void setOrder(String order) {
        this.order = order;
    }

    public String getPhylum() {
        return this.phylum;
    }

    public void setPhylum(String phylum) {
        this.phylum = phylum;
    }

    public String getScientificName() {
        return this.scientificName;
    }

    public void setScientificName(String scientificName) {
        this.scientificName = scientificName;
    }

    public String getSpecies() {
        return this.species;
    }

    public void setSpecies(String species) {
        this.species = species;
    }

    public String getSpecificEpithet() {
        return this.specificEpithet;
    }

    public void setSpecificEpithet(String specificEpithet) {
        this.specificEpithet = specificEpithet;
    }

    public String getInfraspecificEpithet() {
        return this.infraspecificEpithet;
    }

    public void setInfraspecificEpithet(String infraspecificEpithet) {
        this.infraspecificEpithet = infraspecificEpithet;
    }

    public String getSubspecies() {
        return this.subspecies;
    }

    public void setSubspecies(String subspecies) {
        this.subspecies = subspecies;
    }

    public String getKid() {
        return this.kid;
    }

    public void setKid(String kid) {
        this.kid = kid;
    }

    public String getPid() {
        return this.pid;
    }

    public void setPid(String pid) {
        this.pid = pid;
    }

    public String getCid() {
        return this.cid;
    }

    public void setCid(String cid) {
        this.cid = cid;
    }

    public String getOid() {
        return this.oid;
    }

    public void setOid(String oid) {
        this.oid = oid;
    }

    public String getFid() {
        return this.fid;
    }

    public void setFid(String fid) {
        this.fid = fid;
    }

    public String getGid() {
        return this.gid;
    }

    public void setGid(String gid) {
        this.gid = gid;
    }

    public String getSid() {
        return this.sid;
    }

    public void setSid(String sid) {
        this.sid = sid;
    }

    public String getAuthorship() {
        return this.authorship;
    }

    public void setAuthorship(String authorship) {
        this.authorship = authorship;
    }

    public String getRank() {
        return this.rank;
    }

    public void setRank(String rank) {
        this.rank = rank;
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("kingdom", (Object)this.kingdom).append("phylum", (Object)this.phylum).append("klass", (Object)this.klass).append("order", (Object)this.order).append("family", (Object)this.family).append("genus", (Object)this.genus).append("species", (Object)this.species).append("specificEpithet", (Object)this.specificEpithet).append("subspecies", (Object)this.subspecies).append("infraspecificEpithet", (Object)this.infraspecificEpithet).append("scientificName", (Object)this.scientificName).toString();
    }

    public String toCSV(char sep) {
        StringBuilder sb = new StringBuilder();
        sb.append("\"").append(this.authorship).append("\"").append(sep).append(this.kingdom).append(sep).append(this.phylum).append(sep).append(this.klass).append(sep).append(this.order).append(sep).append(this.family).append(sep).append(this.genus);
        return sb.toString();
    }

    public boolean equals(Object object) {
        if (!(object instanceof LinnaeanRankClassification)) {
            return false;
        }
        LinnaeanRankClassification rhs = (LinnaeanRankClassification)object;
        return new EqualsBuilder().append((Object)this.scientificName, (Object)rhs.scientificName).append((Object)this.phylum, (Object)rhs.phylum).append((Object)this.kingdom, (Object)rhs.kingdom).append((Object)this.family, (Object)rhs.family).append((Object)this.order, (Object)rhs.order).append((Object)this.klass, (Object)rhs.klass).append((Object)this.genus, (Object)rhs.genus).append((Object)this.species, (Object)rhs.species).append((Object)this.specificEpithet, (Object)rhs.specificEpithet).append((Object)this.subspecies, (Object)rhs.subspecies).append((Object)this.infraspecificEpithet, (Object)rhs.infraspecificEpithet).isEquals();
    }

    public boolean hasIdenticalClassification(LinnaeanRankClassification lrc, RankType matchLevel) {
        if (this.kingdom != null && matchLevel.getId() >= RankType.KINGDOM.getId() && !this.kingdom.equalsIgnoreCase(lrc.kingdom)) {
            return false;
        }
        if (this.phylum != null && matchLevel.getId() >= RankType.PHYLUM.getId() && !this.phylum.equalsIgnoreCase(lrc.phylum)) {
            return false;
        }
        if (this.klass != null && matchLevel.getId() >= RankType.CLASS.getId() && !this.klass.equalsIgnoreCase(lrc.klass)) {
            return false;
        }
        if (this.order != null && matchLevel.getId() >= RankType.ORDER.getId() && !this.order.equalsIgnoreCase(lrc.order)) {
            return false;
        }
        if (this.family != null && matchLevel.getId() >= RankType.FAMILY.getId() && !this.family.equalsIgnoreCase(lrc.family)) {
            return false;
        }
        if (this.genus != null && matchLevel.getId() >= RankType.GENUS.getId() && !this.genus.equalsIgnoreCase(lrc.genus)) {
            return false;
        }
        if (this.species != null && matchLevel.getId() >= RankType.SPECIES.getId() && !this.species.equalsIgnoreCase(lrc.species)) {
            return false;
        }
        return this.subspecies == null || matchLevel.getId() < RankType.SUBSPECIES.getId() || this.subspecies.equalsIgnoreCase(lrc.subspecies);
    }

    public String getLuceneSearchString(boolean optional) {
        String prefix = optional ? " " : " +";
        StringBuilder sb = new StringBuilder();
        if (StringUtils.isNotEmpty((CharSequence)this.kingdom)) {
            sb.append(prefix).append(RankType.KINGDOM.getRank()).append(":\"").append(this.kingdom).append("\"");
        }
        if (StringUtils.isNotEmpty((CharSequence)this.phylum)) {
            sb.append(prefix).append(RankType.PHYLUM.getRank()).append(":\"").append(this.phylum).append("\"");
        }
        if (StringUtils.isNotEmpty((CharSequence)this.klass)) {
            sb.append(prefix).append(RankType.CLASS.getRank()).append(":\"").append(this.klass).append("\"");
        }
        if (StringUtils.isNotEmpty((CharSequence)this.order)) {
            sb.append(prefix).append(RankType.ORDER.getRank()).append(":\"").append(this.order).append("\"");
        }
        if (StringUtils.isNotEmpty((CharSequence)this.family)) {
            sb.append(prefix).append(RankType.FAMILY.getRank()).append(":\"").append(this.family).append("\"");
        }
        if (StringUtils.isNotEmpty((CharSequence)this.genus)) {
            sb.append(prefix).append(RankType.GENUS.getRank()).append(":\"").append(this.genus).append("\"");
        }
        if (StringUtils.isNotEmpty((CharSequence)this.species)) {
            sb.append(prefix).append(RankType.SPECIES.getRank()).append(":\"").append(this.species).append("\"");
        }
        if (this.authorship != null) {
            sb.append(" ").append(NameIndexField.AUTHOR.toString()).append(":\"").append(this.authorship).append("\"~");
        }
        return sb.toString();
    }

    public static void main(String[] args) {
        LinnaeanRankClassification a = new LinnaeanRankClassification(null, null, null, null, null, null, "AuS bus");
        LinnaeanRankClassification b = new LinnaeanRankClassification(null, null, null, null, null, null, new String("Aus bus"));
        System.out.println("a=b: " + a.equals(b));
        System.out.println("a.hc=b.hc: " + (a.hashCode() == b.hashCode()));
    }

    public int hashCode() {
        return new HashCodeBuilder(1497136033, 448920019).append((Object)this.scientificName).append((Object)this.phylum).append((Object)this.kingdom).append((Object)this.family).append((Object)this.order).append((Object)this.klass).append((Object)this.genus).append((Object)this.species).append((Object)this.specificEpithet).append((Object)this.subspecies).append((Object)this.infraspecificEpithet).toHashCode();
    }
}

