/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.api.vocabulary;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.gbif.api.vocabulary.TagName;

public enum TagNamespace {
    PUBLIC(null),
    GBIF("gbif.org"),
    CHECKLISTBANK("clb.gbif.org"),
    CRAWLER("crawler.gbif.org"),
    VALIDATOR("validator.gbif.org"),
    GBIF_HARVESTING("hit.gbif.org"),
    EOL("eol.org"),
    COL("catalogueoflife.org"),
    ALA("ala.org.au");

    private final String namespace;

    private TagNamespace(String namespace) {
        this.namespace = namespace;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public List<TagName> getPredicates() {
        ArrayList tagNames = Lists.newArrayList();
        for (TagName tagName : TagName.values()) {
            if (tagName.getNamespace() != this) continue;
            tagNames.add(tagName);
        }
        return tagNames;
    }
}

