/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.api.model.occurrence.predicate;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.util.Date;
import javax.validation.constraints.NotNull;
import org.gbif.api.model.occurrence.predicate.Predicate;
import org.gbif.api.model.occurrence.search.OccurrenceSearchParameter;
import org.gbif.api.util.SearchTypeValidator;

public class SimplePredicate
implements Predicate {
    @NotNull
    private final OccurrenceSearchParameter key;
    @NotNull
    private final String value;

    protected SimplePredicate(boolean checkForNonEquals, OccurrenceSearchParameter key, String value) {
        Preconditions.checkNotNull((Object)key, (Object)"<key> may not be null");
        Preconditions.checkNotNull((Object)value, (Object)"<value> may not be null");
        Preconditions.checkArgument((!value.isEmpty() ? 1 : 0) != 0, (Object)"<value> may not be empty");
        SearchTypeValidator.validate(key, value);
        this.key = key;
        this.value = value;
        if (checkForNonEquals) {
            this.checkNonEqualsComparatorAllowed();
        }
    }

    public OccurrenceSearchParameter getKey() {
        return this.key;
    }

    public String getValue() {
        return this.value;
    }

    private void checkNonEqualsComparatorAllowed() {
        if (!Number.class.isAssignableFrom(this.key.type()) && !Date.class.isAssignableFrom(this.key.type())) {
            throw new IllegalArgumentException("Only equals comparisons are allowed for search parameter " + this.key);
        }
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.key, this.value});
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("key", (Object)this.key).add("value", (Object)this.value).toString();
    }
}

