/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.api.model.occurrence.predicate;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import javax.validation.constraints.NotNull;
import org.codehaus.jackson.annotate.JsonCreator;
import org.codehaus.jackson.annotate.JsonProperty;
import org.gbif.api.model.occurrence.predicate.Predicate;
import org.gbif.api.model.occurrence.search.OccurrenceSearchParameter;

public class IsNotNullPredicate
implements Predicate {
    @NotNull
    private final OccurrenceSearchParameter parameter;

    @JsonCreator
    public IsNotNullPredicate(@JsonProperty(value="parameter") OccurrenceSearchParameter parameter) {
        Preconditions.checkNotNull((Object)parameter, (Object)"<parameter> may not be null");
        this.parameter = parameter;
        this.checkPredicateAllowed();
    }

    public OccurrenceSearchParameter getParameter() {
        return this.parameter;
    }

    private void checkPredicateAllowed() {
        if (OccurrenceSearchParameter.GEOMETRY == this.parameter) {
            throw new IllegalArgumentException("IsNotNull predicate is not supported for Geometry parameter");
        }
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.parameter});
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("parameter", (Object)this.parameter).toString();
    }
}

