/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.api.model.common.paging;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.List;
import javax.annotation.Nullable;
import org.gbif.api.model.common.paging.Pageable;
import org.gbif.api.model.common.paging.PageableBase;

public class PagingResponse<T>
extends PageableBase {
    private Boolean endOfRecords;
    private Long count;
    private List<T> results = Lists.newArrayList();

    public PagingResponse() {
    }

    public PagingResponse(Pageable page) {
        super(page);
    }

    public PagingResponse(Pageable page, Long count) {
        super(page);
        this.count = count;
    }

    public PagingResponse(long offset, int limit) {
        super(offset, limit);
    }

    public PagingResponse(Pageable page, Long count, List<T> results) {
        super(page);
        this.results = results;
        this.count = count;
    }

    public PagingResponse(long offset, int limit, Long count) {
        super(offset, limit);
        this.count = count;
    }

    public PagingResponse(long offset, int limit, Long count, List<T> results) {
        super(offset, limit);
        this.results = results;
        this.count = count;
    }

    @Nullable
    public Long getCount() {
        return this.count;
    }

    public void setCount(Long count) {
        this.count = count;
    }

    public List<T> getResults() {
        return this.results;
    }

    public void setResults(List<T> results) {
        Preconditions.checkNotNull(results, (Object)"results can't be null");
        this.results = results;
    }

    public boolean isEndOfRecords() {
        if (this.endOfRecords == null) {
            if (this.count != null) {
                return this.count < this.offset + (long)this.limit;
            }
            if (this.results != null) {
                return this.results.size() < this.limit;
            }
            return false;
        }
        return this.endOfRecords;
    }

    public void setEndOfRecords(boolean endOfRecords) {
        this.endOfRecords = endOfRecords;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof PagingResponse)) {
            return false;
        }
        PagingResponse that = (PagingResponse)obj;
        return Objects.equal((Object)this.count, (Object)that.getCount()) && Objects.equal(this.results, that.getResults()) && Objects.equal((Object)this.getOffset(), (Object)that.getOffset()) && Objects.equal((Object)this.getLimit(), (Object)that.getLimit());
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.count, this.results, this.endOfRecords, this.getLimit(), this.getOffset()});
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("count", (Object)this.count).add("results", this.results).add("offset", this.getOffset()).add("limit", this.getLimit()).toString();
    }
}

