/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.api.model.common;

public enum DoiStatus {
    NEW(null),
    RESERVED("reserved"),
    REGISTERED("public"),
    DELETED("unavailable"),
    FAILED(null);

    private final String ezid;

    private DoiStatus(String ezid) {
        this.ezid = ezid;
    }

    public String getEzid() {
        return this.ezid;
    }

    public boolean isRegistered() {
        return this == REGISTERED || this == DELETED;
    }

    public static DoiStatus fromString(String status) {
        for (DoiStatus s : DoiStatus.values()) {
            if (!status.equalsIgnoreCase(s.name()) && (s.getEzid() == null || !status.equalsIgnoreCase(s.getEzid()))) continue;
            return s;
        }
        return null;
    }
}

