/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.api.model.checklistbank.search;

import com.google.common.base.Objects;
import com.google.common.collect.Lists;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.UUID;
import javax.validation.constraints.NotNull;
import org.codehaus.jackson.annotate.JsonProperty;
import org.gbif.api.model.checklistbank.Description;
import org.gbif.api.model.checklistbank.VernacularName;
import org.gbif.api.model.common.LinneanClassification;
import org.gbif.api.model.common.LinneanClassificationKeys;
import org.gbif.api.util.ClassificationUtils;
import org.gbif.api.vocabulary.NameType;
import org.gbif.api.vocabulary.NomenclaturalStatus;
import org.gbif.api.vocabulary.Origin;
import org.gbif.api.vocabulary.Rank;
import org.gbif.api.vocabulary.TaxonomicStatus;
import org.gbif.api.vocabulary.ThreatStatus;

public class NameUsageSearchResult
implements LinneanClassification,
LinneanClassificationKeys {
    private Integer key;
    private UUID datasetKey;
    private Integer nubKey;
    private Integer parentKey;
    private String parent;
    private Integer acceptedKey;
    private String accepted;
    private Integer basionymKey;
    private String basionym;
    private boolean isSynonym;
    private String kingdom;
    private String phylum;
    @JsonProperty(value="class")
    private String clazz;
    private String order;
    private String family;
    private String genus;
    private String subgenus;
    private String species;
    private Integer kingdomKey;
    private Integer phylumKey;
    private Integer classKey;
    private Integer orderKey;
    private Integer familyKey;
    private Integer genusKey;
    private Integer subgenusKey;
    private Integer speciesKey;
    private String scientificName;
    private String canonicalName;
    private String authorship;
    private String publishedIn;
    private String accordingTo;
    private NameType nameType;
    private TaxonomicStatus taxonomicStatus;
    private Rank rank;
    private Origin origin;
    private int numDescendants;
    private int numOccurrences;
    private String taxonID;
    private Boolean extinct;
    private Boolean marine;
    private List<NomenclaturalStatus> nomenclaturalStatus = Lists.newArrayList();
    private List<ThreatStatus> threatStatuses = Lists.newArrayList();
    private List<Description> descriptions = Lists.newArrayList();
    private List<VernacularName> vernacularNames = Lists.newArrayList();

    public String getAccepted() {
        return this.accepted;
    }

    public void setAccepted(String accepted) {
        this.accepted = accepted;
    }

    public Integer getAcceptedKey() {
        return this.acceptedKey;
    }

    public void setAcceptedKey(Integer acceptedKey) {
        this.acceptedKey = acceptedKey;
    }

    public String getAccordingTo() {
        return this.accordingTo;
    }

    public void setAccordingTo(String accordingTo) {
        this.accordingTo = accordingTo;
    }

    public String getAuthorship() {
        return this.authorship;
    }

    public void setAuthorship(String authorship) {
        this.authorship = authorship;
    }

    public String getBasionym() {
        return this.basionym;
    }

    public void setBasionym(String basionym) {
        this.basionym = basionym;
    }

    public Integer getBasionymKey() {
        return this.basionymKey;
    }

    public void setBasionymKey(Integer basionymKey) {
        this.basionymKey = basionymKey;
    }

    public String getCanonicalName() {
        return this.canonicalName;
    }

    public void setCanonicalName(String canonicalName) {
        this.canonicalName = canonicalName;
    }

    public UUID getDatasetKey() {
        return this.datasetKey;
    }

    public void setDatasetKey(UUID datasetKey) {
        this.datasetKey = datasetKey;
    }

    @NotNull
    public List<Description> getDescriptions() {
        return this.descriptions;
    }

    public void setDescriptions(List<Description> descriptions) {
        this.descriptions = descriptions;
    }

    public Integer getKey() {
        return this.key;
    }

    public void setKey(Integer key) {
        this.key = key;
    }

    public NameType getNameType() {
        return this.nameType;
    }

    public void setNameType(NameType nameType) {
        this.nameType = nameType;
    }

    public Integer getNubKey() {
        return this.nubKey;
    }

    public void setNubKey(Integer nubKey) {
        this.nubKey = nubKey;
    }

    public int getNumDescendants() {
        return this.numDescendants;
    }

    public void setNumDescendants(int numDescendants) {
        this.numDescendants = numDescendants;
    }

    public int getNumOccurrences() {
        return this.numOccurrences;
    }

    public void setNumOccurrences(int numOccurrences) {
        this.numOccurrences = numOccurrences;
    }

    public Origin getOrigin() {
        return this.origin;
    }

    public void setOrigin(Origin origin) {
        this.origin = origin;
    }

    public String getParent() {
        return this.parent;
    }

    public void setParent(String parent) {
        this.parent = parent;
    }

    public Integer getParentKey() {
        return this.parentKey;
    }

    public void setParentKey(Integer parentKey) {
        this.parentKey = parentKey;
    }

    public String getPublishedIn() {
        return this.publishedIn;
    }

    public void setPublishedIn(String publishedIn) {
        this.publishedIn = publishedIn;
    }

    public Rank getRank() {
        return this.rank;
    }

    public void setRank(Rank rank) {
        this.rank = rank;
    }

    public String getScientificName() {
        return this.scientificName;
    }

    public void setScientificName(String scientificName) {
        this.scientificName = scientificName;
    }

    public String getTaxonID() {
        return this.taxonID;
    }

    public void setTaxonID(String taxonID) {
        this.taxonID = taxonID;
    }

    public TaxonomicStatus getTaxonomicStatus() {
        return this.taxonomicStatus;
    }

    public void setTaxonomicStatus(TaxonomicStatus taxonomicStatus) {
        this.taxonomicStatus = taxonomicStatus;
    }

    public List<ThreatStatus> getThreatStatuses() {
        return this.threatStatuses;
    }

    public void setThreatStatuses(List<ThreatStatus> threatStatuses) {
        this.threatStatuses = threatStatuses;
    }

    public List<NomenclaturalStatus> getNomenclaturalStatus() {
        return this.nomenclaturalStatus;
    }

    public void setNomenclaturalStatus(List<NomenclaturalStatus> nomenclaturalStatus) {
        this.nomenclaturalStatus = nomenclaturalStatus;
    }

    @NotNull
    public List<VernacularName> getVernacularNames() {
        return this.vernacularNames;
    }

    public void setVernacularNames(List<VernacularName> vernacularNames) {
        this.vernacularNames = vernacularNames;
    }

    public Boolean isExtinct() {
        return this.extinct;
    }

    public void setExtinct(Boolean extinct) {
        this.extinct = extinct;
    }

    public Boolean isMarine() {
        return this.marine;
    }

    public void setMarine(Boolean marine) {
        this.marine = marine;
    }

    @Override
    public String getKingdom() {
        return this.kingdom;
    }

    @Override
    public void setKingdom(String kingdom) {
        this.kingdom = kingdom;
    }

    @Override
    public String getPhylum() {
        return this.phylum;
    }

    @Override
    public void setPhylum(String phylum) {
        this.phylum = phylum;
    }

    @Override
    public String getClazz() {
        return this.clazz;
    }

    @Override
    public void setClazz(String clazz) {
        this.clazz = clazz;
    }

    @Override
    public String getOrder() {
        return this.order;
    }

    @Override
    public void setOrder(String order) {
        this.order = order;
    }

    @Override
    public String getFamily() {
        return this.family;
    }

    @Override
    public void setFamily(String family) {
        this.family = family;
    }

    @Override
    public String getGenus() {
        return this.genus;
    }

    @Override
    public void setGenus(String genus) {
        this.genus = genus;
    }

    @Override
    public String getSubgenus() {
        return this.subgenus;
    }

    @Override
    public void setSubgenus(String subgenus) {
        this.subgenus = subgenus;
    }

    @Override
    public String getSpecies() {
        return this.species;
    }

    @Override
    public void setSpecies(String species) {
        this.species = species;
    }

    @Override
    public Integer getKingdomKey() {
        return this.kingdomKey;
    }

    @Override
    public void setKingdomKey(Integer kingdomKey) {
        this.kingdomKey = kingdomKey;
    }

    @Override
    public Integer getPhylumKey() {
        return this.phylumKey;
    }

    @Override
    public void setPhylumKey(Integer phylumKey) {
        this.phylumKey = phylumKey;
    }

    @Override
    public Integer getClassKey() {
        return this.classKey;
    }

    @Override
    public void setClassKey(Integer classKey) {
        this.classKey = classKey;
    }

    @Override
    public Integer getOrderKey() {
        return this.orderKey;
    }

    @Override
    public void setOrderKey(Integer orderKey) {
        this.orderKey = orderKey;
    }

    @Override
    public Integer getFamilyKey() {
        return this.familyKey;
    }

    @Override
    public void setFamilyKey(Integer familyKey) {
        this.familyKey = familyKey;
    }

    @Override
    public Integer getGenusKey() {
        return this.genusKey;
    }

    @Override
    public void setGenusKey(Integer genusKey) {
        this.genusKey = genusKey;
    }

    @Override
    public Integer getSubgenusKey() {
        return this.subgenusKey;
    }

    @Override
    public void setSubgenusKey(Integer subgenusKey) {
        this.subgenusKey = subgenusKey;
    }

    @Override
    public Integer getSpeciesKey() {
        return this.speciesKey;
    }

    @Override
    public void setSpeciesKey(Integer speciesKey) {
        this.speciesKey = speciesKey;
    }

    @Override
    public String getHigherRank(Rank rank) {
        return ClassificationUtils.getHigherRank(this, rank);
    }

    @Override
    public Integer getHigherRankKey(Rank rank) {
        return ClassificationUtils.getHigherRankKey(this, rank);
    }

    @NotNull
    public LinkedHashMap<Integer, String> getHigherClassificationMap() {
        return ClassificationUtils.getHigherClassificationMap(this, this.key, this.parentKey, this.parent);
    }

    public boolean isSynonym() {
        return this.isSynonym;
    }

    public void setSynonym(boolean synonym) {
        this.isSynonym = synonym;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.key, this.datasetKey, this.nubKey, this.parentKey, this.parent, this.acceptedKey, this.accepted, this.basionymKey, this.basionym, this.isSynonym, this.kingdom, this.phylum, this.clazz, this.order, this.family, this.genus, this.subgenus, this.species, this.kingdomKey, this.phylumKey, this.classKey, this.orderKey, this.familyKey, this.genusKey, this.subgenusKey, this.speciesKey, this.scientificName, this.canonicalName, this.authorship, this.publishedIn, this.accordingTo, this.nameType, this.taxonomicStatus, this.nomenclaturalStatus, this.rank, this.origin, this.numDescendants, this.numOccurrences, this.taxonID, this.extinct, this.marine, this.threatStatuses, this.descriptions, this.vernacularNames});
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NameUsageSearchResult other = (NameUsageSearchResult)obj;
        return Objects.equal((Object)this.key, (Object)other.key) && Objects.equal((Object)this.datasetKey, (Object)other.datasetKey) && Objects.equal((Object)this.nubKey, (Object)other.nubKey) && Objects.equal((Object)this.parentKey, (Object)other.parentKey) && Objects.equal((Object)this.parent, (Object)other.parent) && Objects.equal((Object)this.acceptedKey, (Object)other.acceptedKey) && Objects.equal((Object)this.accepted, (Object)other.accepted) && Objects.equal((Object)this.basionymKey, (Object)other.basionymKey) && Objects.equal((Object)this.basionym, (Object)other.basionym) && Objects.equal((Object)this.isSynonym, (Object)other.isSynonym) && Objects.equal((Object)this.kingdom, (Object)other.kingdom) && Objects.equal((Object)this.phylum, (Object)other.phylum) && Objects.equal((Object)this.clazz, (Object)other.clazz) && Objects.equal((Object)this.order, (Object)other.order) && Objects.equal((Object)this.family, (Object)other.family) && Objects.equal((Object)this.genus, (Object)other.genus) && Objects.equal((Object)this.subgenus, (Object)other.subgenus) && Objects.equal((Object)this.species, (Object)other.species) && Objects.equal((Object)this.kingdomKey, (Object)other.kingdomKey) && Objects.equal((Object)this.phylumKey, (Object)other.phylumKey) && Objects.equal((Object)this.classKey, (Object)other.classKey) && Objects.equal((Object)this.orderKey, (Object)other.orderKey) && Objects.equal((Object)this.familyKey, (Object)other.familyKey) && Objects.equal((Object)this.genusKey, (Object)other.genusKey) && Objects.equal((Object)this.subgenusKey, (Object)other.subgenusKey) && Objects.equal((Object)this.speciesKey, (Object)other.speciesKey) && Objects.equal((Object)this.scientificName, (Object)other.scientificName) && Objects.equal((Object)this.canonicalName, (Object)other.canonicalName) && Objects.equal((Object)this.authorship, (Object)other.authorship) && Objects.equal((Object)this.publishedIn, (Object)other.publishedIn) && Objects.equal((Object)this.accordingTo, (Object)other.accordingTo) && Objects.equal((Object)((Object)this.nameType), (Object)((Object)other.nameType)) && Objects.equal((Object)((Object)this.taxonomicStatus), (Object)((Object)other.taxonomicStatus)) && Objects.equal(this.nomenclaturalStatus, other.nomenclaturalStatus) && Objects.equal((Object)((Object)this.rank), (Object)((Object)other.rank)) && Objects.equal((Object)((Object)this.origin), (Object)((Object)other.origin)) && Objects.equal((Object)this.numDescendants, (Object)other.numDescendants) && Objects.equal((Object)this.numOccurrences, (Object)other.numOccurrences) && Objects.equal((Object)this.taxonID, (Object)other.taxonID) && Objects.equal((Object)this.extinct, (Object)other.extinct) && Objects.equal((Object)this.marine, (Object)other.marine) && Objects.equal(this.threatStatuses, other.threatStatuses) && Objects.equal(this.descriptions, other.descriptions) && Objects.equal(this.vernacularNames, other.vernacularNames);
    }

    public String toString() {
        return "NameUsageSearchResult{key=" + this.key + ", datasetKey=" + this.datasetKey + ", nubKey=" + this.nubKey + ", parentKey=" + this.parentKey + ", parent='" + this.parent + '\'' + ", acceptedKey=" + this.acceptedKey + ", accepted='" + this.accepted + '\'' + ", basionymKey=" + this.basionymKey + ", basionym='" + this.basionym + '\'' + ", isSynonym=" + this.isSynonym + ", kingdom='" + this.kingdom + '\'' + ", phylum='" + this.phylum + '\'' + ", clazz='" + this.clazz + '\'' + ", order='" + this.order + '\'' + ", family='" + this.family + '\'' + ", genus='" + this.genus + '\'' + ", subgenus='" + this.subgenus + '\'' + ", species='" + this.species + '\'' + ", kingdomKey=" + this.kingdomKey + ", phylumKey=" + this.phylumKey + ", classKey=" + this.classKey + ", orderKey=" + this.orderKey + ", familyKey=" + this.familyKey + ", genusKey=" + this.genusKey + ", subgenusKey=" + this.subgenusKey + ", speciesKey=" + this.speciesKey + ", scientificName='" + this.scientificName + '\'' + ", canonicalName='" + this.canonicalName + '\'' + ", authorship='" + this.authorship + '\'' + ", publishedIn='" + this.publishedIn + '\'' + ", accordingTo='" + this.accordingTo + '\'' + ", nameType=" + (Object)((Object)this.nameType) + ", taxonomicStatus=" + (Object)((Object)this.taxonomicStatus) + ", nomenclaturalStatus=" + this.nomenclaturalStatus + ", rank=" + (Object)((Object)this.rank) + ", origin=" + (Object)((Object)this.origin) + ", numDescendants=" + this.numDescendants + ", numOccurrences=" + this.numOccurrences + ", taxonID='" + this.taxonID + '\'' + ", extinct=" + this.extinct + ", marine=" + this.marine + ", threatStatuses=" + this.threatStatuses + ", descriptions=" + this.descriptions + ", vernacularNames=" + this.vernacularNames + '}';
    }
}

