/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.api.model.checklistbank.search;

import java.util.UUID;
import org.gbif.api.model.checklistbank.search.NameUsageSearchParameter;
import org.gbif.api.model.common.paging.Pageable;
import org.gbif.api.model.common.search.FacetedSearchRequest;
import org.gbif.api.vocabulary.NameUsageIssue;
import org.gbif.api.vocabulary.NomenclaturalStatus;
import org.gbif.api.vocabulary.Rank;
import org.gbif.api.vocabulary.TaxonomicStatus;
import org.gbif.api.vocabulary.ThreatStatus;

public class NameUsageSearchRequest
extends FacetedSearchRequest<NameUsageSearchParameter> {
    public NameUsageSearchRequest() {
    }

    public NameUsageSearchRequest(Pageable page) {
        super(page);
    }

    public NameUsageSearchRequest(long offset, int limit) {
        super(offset, limit);
    }

    public void addChecklistFilter(UUID datasetKey) {
        this.addParameter(NameUsageSearchParameter.DATASET_KEY, datasetKey.toString());
    }

    public void addExtinctFilter(boolean isExtinct) {
        this.addParameter(NameUsageSearchParameter.IS_EXTINCT, String.valueOf(isExtinct));
    }

    public void addHigherTaxonFilter(int taxonKey) {
        this.addParameter(NameUsageSearchParameter.HIGHERTAXON_KEY, taxonKey);
    }

    public void addMarineFilter(boolean isMarine) {
        this.addParameter(NameUsageSearchParameter.HABITAT, isMarine);
    }

    public void addRankFilter(Rank rank) {
        this.addParameter(NameUsageSearchParameter.RANK, rank);
    }

    public void addTaxonomicStatusFilter(TaxonomicStatus status) {
        this.addParameter(NameUsageSearchParameter.STATUS, status);
    }

    public void addTaxonomicStatusFilter(NomenclaturalStatus nomenclaturalStatus) {
        this.addParameter(NameUsageSearchParameter.NOMENCLATURAL_STATUS, nomenclaturalStatus);
    }

    public void addThreatStatusFilter(ThreatStatus threat) {
        this.addParameter(NameUsageSearchParameter.THREAT, threat);
    }

    public void addIssueFilter(NameUsageIssue issue) {
        this.addParameter(NameUsageSearchParameter.ISSUE, issue);
    }
}

