/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.poifs.filesystem;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.Iterator;
import org.apache.poi.poifs.dev.POIFSViewable;
import org.apache.poi.poifs.filesystem.NPOIFSFileSystem;
import org.apache.poi.poifs.filesystem.NPOIFSStream;
import org.apache.poi.poifs.property.DocumentProperty;
import org.apache.poi.util.HexDump;
import org.apache.poi.util.IOUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class NPOIFSDocument
implements POIFSViewable {
    private DocumentProperty _property;
    private NPOIFSFileSystem _filesystem;
    private NPOIFSStream _stream;
    private int _block_size;

    public NPOIFSDocument(DocumentProperty property, NPOIFSFileSystem filesystem) throws IOException {
        this._property = property;
        this._filesystem = filesystem;
        if (property.getSize() < 4096) {
            this._stream = new NPOIFSStream(this._filesystem.getMiniStore(), property.getStartBlock());
            this._block_size = this._filesystem.getMiniStore().getBlockStoreBlockSize();
        } else {
            this._stream = new NPOIFSStream(this._filesystem, property.getStartBlock());
            this._block_size = this._filesystem.getBlockStoreBlockSize();
        }
    }

    public NPOIFSDocument(String name, NPOIFSFileSystem filesystem, InputStream stream) throws IOException {
        byte[] contents;
        this._filesystem = filesystem;
        if (stream instanceof ByteArrayInputStream) {
            ByteArrayInputStream bais = (ByteArrayInputStream)stream;
            contents = new byte[bais.available()];
            bais.read(contents);
        } else {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            IOUtils.copy(stream, baos);
            contents = baos.toByteArray();
        }
        if (contents.length <= 4096) {
            this._stream = new NPOIFSStream(filesystem.getMiniStore());
            this._block_size = this._filesystem.getMiniStore().getBlockStoreBlockSize();
        } else {
            this._stream = new NPOIFSStream(filesystem);
            this._block_size = this._filesystem.getBlockStoreBlockSize();
        }
        this._stream.updateContents(contents);
        this._property = new DocumentProperty(name, contents.length);
        this._property.setStartBlock(this._stream.getStartBlock());
    }

    int getDocumentBlockSize() {
        return this._block_size;
    }

    Iterator<ByteBuffer> getBlockIterator() {
        return this._stream.getBlockIterator();
    }

    public int getSize() {
        return this._property.getSize();
    }

    DocumentProperty getDocumentProperty() {
        return this._property;
    }

    @Override
    public Object[] getViewableArray() {
        String result;
        Object[] results = new Object[1];
        try {
            if (this.getSize() > 0) {
                byte[] data = new byte[this.getSize()];
                int offset = 0;
                for (ByteBuffer buffer : this._stream) {
                    int length = Math.min(this._block_size, data.length - offset);
                    buffer.get(data, offset, length);
                    offset += length;
                }
                ByteArrayOutputStream output = new ByteArrayOutputStream();
                HexDump.dump(data, 0L, output, 0);
                result = output.toString();
            } else {
                result = "<NO DATA>";
            }
        }
        catch (IOException e) {
            result = e.getMessage();
        }
        results[0] = result;
        return results;
    }

    @Override
    public Iterator getViewableIterator() {
        return Collections.EMPTY_LIST.iterator();
    }

    @Override
    public boolean preferArray() {
        return true;
    }

    @Override
    public String getShortDescription() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("Document: \"").append(this._property.getName()).append("\"");
        buffer.append(" size = ").append(this.getSize());
        return buffer.toString();
    }
}

