/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.ecat.fuzzy;

import java.io.BufferedReader;
import java.io.InputStreamReader;

public class Levenshtein {
    private static final int[] ZERO_LENGTH_INT_ARRAY = new int[0];

    public static int lev(String s, String t, int[] workspace) {
        int lenS = s.length();
        int lenT = t.length();
        int lenS1 = lenS + 1;
        int lenT1 = lenT + 1;
        if (lenT1 == 1) {
            return lenS1 - 1;
        }
        if (lenS1 == 1) {
            return lenT1 - 1;
        }
        int[] dl = workspace;
        int dlIndex = 0;
        int sPrevIndex = 0;
        int tPrevIndex = 0;
        int rowBefore = 0;
        int min = 0;
        int cost = 0;
        int tmp = 0;
        int tri = lenS1 + 2;
        dlIndex = 0;
        tmp = 0;
        while (tmp < lenT1) {
            dl[dlIndex] = tmp++;
            dlIndex += lenS1;
        }
        int sIndex = 0;
        while (sIndex < lenS) {
            dl[dlIndex] = dlIndex = sIndex + 1;
            int tIndex = 0;
            while (tIndex < lenT) {
                tmp = dl[(dlIndex += lenS1) - 1] + 1;
                if (tmp < (min = dl[rowBefore = dlIndex] + 1)) {
                    min = tmp;
                }
                cost = 1;
                if (s.charAt(sIndex) == t.charAt(tIndex)) {
                    cost = 0;
                }
                if ((tmp = dl[rowBefore - 1] + cost) < min) {
                    min = tmp;
                }
                dl[dlIndex] = min;
                tPrevIndex = tIndex++;
            }
            sPrevIndex = sIndex++;
        }
        return dl[dlIndex];
    }

    public static int levlim(String s, String t, int limit, int[] workspace) {
        int lenT;
        int lenS = s.length();
        if (lenS < (lenT = t.length()) ? lenT - lenS >= limit : lenT < lenS && lenS - lenT >= limit) {
            return limit;
        }
        int lenS1 = lenS + 1;
        int lenT1 = lenT + 1;
        if (lenS1 == 1) {
            return lenT < limit ? lenT : limit;
        }
        if (lenT1 == 1) {
            return lenS < limit ? lenS : limit;
        }
        int[] dl = workspace;
        int dlIndex = 0;
        int sPrevIndex = 0;
        int tPrevIndex = 0;
        int rowBefore = 0;
        int min = 0;
        int tmp = 0;
        int best = 0;
        int cost = 0;
        int tri = lenS1 + 2;
        dlIndex = 0;
        tmp = 0;
        while (tmp < lenT1) {
            dl[dlIndex] = tmp++;
            dlIndex += lenS1;
        }
        int sIndex = 0;
        while (sIndex < lenS) {
            dl[dlIndex] = dlIndex = sIndex + 1;
            best = limit;
            int tIndex = 0;
            while (tIndex < lenT) {
                tmp = dl[(dlIndex += lenS1) - 1] + 1;
                if (tmp < (min = dl[rowBefore = dlIndex] + 1)) {
                    min = tmp;
                }
                cost = 1;
                if (s.charAt(sIndex) == t.charAt(tIndex)) {
                    cost = 0;
                }
                if ((tmp = dl[rowBefore - 1] + cost) < min) {
                    min = tmp;
                }
                dl[dlIndex] = min;
                if (min < best) {
                    best = min;
                }
                tPrevIndex = tIndex++;
            }
            if (best >= limit) {
                return limit;
            }
            sPrevIndex = sIndex++;
        }
        if (dl[dlIndex] >= limit) {
            return limit;
        }
        return dl[dlIndex];
    }

    public static int damlev(String s, String t, int[] workspace) {
        int lenS = s.length();
        int lenT = t.length();
        int lenS1 = lenS + 1;
        int lenT1 = lenT + 1;
        if (lenT1 == 1) {
            return lenS1 - 1;
        }
        if (lenS1 == 1) {
            return lenT1 - 1;
        }
        int[] dl = workspace;
        int dlIndex = 0;
        int sPrevIndex = 0;
        int tPrevIndex = 0;
        int rowBefore = 0;
        int min = 0;
        int cost = 0;
        int tmp = 0;
        int tri = lenS1 + 2;
        dlIndex = 0;
        tmp = 0;
        while (tmp < lenT1) {
            dl[dlIndex] = tmp++;
            dlIndex += lenS1;
        }
        int sIndex = 0;
        while (sIndex < lenS) {
            dl[dlIndex] = dlIndex = sIndex + 1;
            int tIndex = 0;
            while (tIndex < lenT) {
                tmp = dl[(dlIndex += lenS1) - 1] + 1;
                if (tmp < (min = dl[rowBefore = dlIndex] + 1)) {
                    min = tmp;
                }
                cost = 1;
                if (s.charAt(sIndex) == t.charAt(tIndex)) {
                    cost = 0;
                }
                if (sIndex > 0 && tIndex > 0 && s.charAt(sIndex) == t.charAt(tPrevIndex) && s.charAt(sPrevIndex) == t.charAt(tIndex) && (tmp = dl[rowBefore - tri] + cost) < min) {
                    min = tmp;
                }
                if ((tmp = dl[rowBefore - 1] + cost) < min) {
                    min = tmp;
                }
                dl[dlIndex] = min;
                tPrevIndex = tIndex++;
            }
            sPrevIndex = sIndex++;
        }
        return dl[dlIndex];
    }

    public static int damlevlim(String s, String t, int limit, int[] workspace) {
        int lenT;
        int lenS = s.length();
        if (lenS < (lenT = t.length()) ? lenT - lenS >= limit : lenT < lenS && lenS - lenT >= limit) {
            return limit;
        }
        int lenS1 = lenS + 1;
        int lenT1 = lenT + 1;
        if (lenS1 == 1) {
            return lenT < limit ? lenT : limit;
        }
        if (lenT1 == 1) {
            return lenS < limit ? lenS : limit;
        }
        int[] dl = workspace;
        int dlIndex = 0;
        int sPrevIndex = 0;
        int tPrevIndex = 0;
        int rowBefore = 0;
        int min = 0;
        int tmp = 0;
        int best = 0;
        int cost = 0;
        int tri = lenS1 + 2;
        dlIndex = 0;
        tmp = 0;
        while (tmp < lenT1) {
            dl[dlIndex] = tmp++;
            dlIndex += lenS1;
        }
        int sIndex = 0;
        while (sIndex < lenS) {
            dl[dlIndex] = dlIndex = sIndex + 1;
            best = limit;
            int tIndex = 0;
            while (tIndex < lenT) {
                tmp = dl[(dlIndex += lenS1) - 1] + 1;
                if (tmp < (min = dl[rowBefore = dlIndex] + 1)) {
                    min = tmp;
                }
                cost = 1;
                if (s.charAt(sIndex) == t.charAt(tIndex)) {
                    cost = 0;
                }
                if (sIndex > 0 && tIndex > 0 && s.charAt(sIndex) == t.charAt(tPrevIndex) && s.charAt(sPrevIndex) == t.charAt(tIndex) && (tmp = dl[rowBefore - tri] + cost) < min) {
                    min = tmp;
                }
                if ((tmp = dl[rowBefore - 1] + cost) < min) {
                    min = tmp;
                }
                dl[dlIndex] = min;
                if (min < best) {
                    best = min;
                }
                tPrevIndex = tIndex++;
            }
            if (best >= limit) {
                return limit;
            }
            sPrevIndex = sIndex++;
        }
        if (dl[dlIndex] >= limit) {
            return limit;
        }
        return dl[dlIndex];
    }

    public static int[] getWorkspace(int sl, int tl) {
        return new int[(sl + 1) * (tl + 1)];
    }

    public static int lev(String s, String t) {
        if (s != null && t != null) {
            return Levenshtein.lev(s, t, Levenshtein.getWorkspace(s.length(), t.length()));
        }
        return Levenshtein.lev(s, t, ZERO_LENGTH_INT_ARRAY);
    }

    public static int levlim(String s, String t, int limit) {
        if (s != null && t != null) {
            return Levenshtein.levlim(s, t, limit, Levenshtein.getWorkspace(s.length(), t.length()));
        }
        return Levenshtein.levlim(s, t, limit, ZERO_LENGTH_INT_ARRAY);
    }

    public static int damlev(String s, String t) {
        if (s != null && t != null) {
            return Levenshtein.damlev(s, t, Levenshtein.getWorkspace(s.length(), t.length()));
        }
        return Levenshtein.damlev(s, t, ZERO_LENGTH_INT_ARRAY);
    }

    public static int damlevlim(String s, String t, int limit) {
        if (s != null && t != null) {
            return Levenshtein.damlevlim(s, t, limit, Levenshtein.getWorkspace(s.length(), t.length()));
        }
        return Levenshtein.damlevlim(s, t, limit, ZERO_LENGTH_INT_ARRAY);
    }

    public static void main(String[] args) throws Exception {
        System.out.println("Check old bugs:\n");
        System.out.println("Tomas' report: damlevlim('h', 'hello', 2) = 4 (should be 2)");
        System.out.print("damlevlim('h', 'hello', 2) = " + Levenshtein.damlevlim("h", "hello", 2));
        System.out.println(" " + (Levenshtein.damlevlim("h", "hello", 2) == 2 ? "PASS" : "*FAIL*"));
        System.out.print("damlevlim('hello', 'h', 2) = " + Levenshtein.damlevlim("hello", "h", 2));
        System.out.println(" " + (Levenshtein.damlevlim("hello", "h", 2) == 2 ? "PASS" : "*FAIL*"));
        System.out.println("Adam Koprowski's report lev(\"1\", \"Blah blah blah blah blah blah\")) = 1 (should be ... large)");
        System.out.print("damlevlim(\"1\", \"Blah blah blah blah blah blah\", 30) = " + Levenshtein.damlevlim("1", "Blah blah blah blah blah blah", 30));
        System.out.println(" " + (Levenshtein.damlevlim("1", "Blah blah blah blah blah blah", 30) == 29 ? "PASS" : "*FAIL*"));
        System.out.print("damlevlim(\"1\", \"Blah blah blah blah blah blah\", 10) = " + Levenshtein.damlevlim("1", "Blah blah blah blah blah blah", 10));
        System.out.println(" " + (Levenshtein.damlevlim("1", "Blah blah blah blah blah blah", 10) == 10 ? "PASS" : "*FAIL*"));
        System.out.print("damlevlim(\"shortisbetter\", \"short\", 10) = " + Levenshtein.damlevlim("shortisbetter", "short", 10));
        System.out.println(" " + (Levenshtein.damlevlim("shortisbetter", "short", 10) == 8 ? "PASS" : "*FAIL*"));
        System.out.print("damlevlim(\"shortisbetter\", \"short\", 2) = " + Levenshtein.damlevlim("shortisbetter", "short", 2));
        System.out.println(" " + (Levenshtein.damlevlim("shortisbetter", "short", 2) == 2 ? "PASS" : "*FAIL*"));
        System.out.print("damlevlim(\"short\", \"shortisbetter\", 10) = " + Levenshtein.damlevlim("short", "shortisbetter", 10));
        System.out.println(" " + (Levenshtein.damlevlim("short", "shortisbetter", 10) == 8 ? "PASS" : "*FAIL*"));
        System.out.print("damlevlim(\"short\", \"shortisbetter\", 2) = " + Levenshtein.damlevlim("short", "shortisbetter", 2));
        System.out.println(" " + (Levenshtein.damlevlim("short", "shortisbetter", 2) == 2 ? "PASS" : "*FAIL*"));
        System.out.print("damlevlim(\"short\", \"shorts\", 2) = " + Levenshtein.damlevlim("short", "shorts", 2));
        System.out.println(" " + (Levenshtein.damlevlim("short", "shorts", 2) == 1 ? "PASS" : "*FAIL*"));
        System.out.print("damlevlim(\"sohrt\", \"short\", 3) = " + Levenshtein.damlevlim("sohrt", "short", 3));
        System.out.println(" " + (Levenshtein.damlevlim("sohrt", "short", 3) == 1 ? "PASS" : "*FAIL*"));
        System.out.print("levlim(\"sohrt\", \"short\", 3) = " + Levenshtein.levlim("sohrt", "short", 3));
        System.out.println(" " + (Levenshtein.levlim("sohrt", "short", 3) == 2 ? "PASS" : "*FAIL*"));
        System.out.print("levlim(\"sohrts\", \"short\", 2) = " + Levenshtein.levlim("sohrts", "short", 3));
        System.out.println(" " + (Levenshtein.levlim("sohrts", "short", 2) == 2 ? "PASS" : "*FAIL*"));
        System.out.println("Bj\u00f6rn T\u00f6rnqvist's report damlevlim(\u201dshort\u201d,\u201dshoort\u201d,2) = 2 should be 1");
        System.out.print("damlevlim(\"short\", \"shoort\", 2) = " + Levenshtein.damlevlim("short", "shoort", 2));
        System.out.println(" " + (Levenshtein.damlevlim("short", "shoort", 2) == 1 ? "PASS" : "*FAIL*"));
        System.out.println("Bj\u00f6rn T\u00f6rnqvist's report damlevlim(\u201dshort\u201d,\u201dshrt\u201d,2) = 2 should be 1");
        System.out.print("damlevlim(\"short\", \"shrt\", 2) = " + Levenshtein.damlevlim("short", "shrt", 2));
        System.out.println(" " + (Levenshtein.damlevlim("short", "shrt", 2) == 1 ? "PASS" : "*FAIL*"));
        System.out.print("damlevlim(\"short\", \"\", 2) = " + Levenshtein.damlevlim("short", "", 2));
        System.out.println(" " + (Levenshtein.damlevlim("short", "", 2) == 2 ? "PASS" : "*FAIL*"));
        System.out.print("damlev(\"short\", \"shrt\") = " + Levenshtein.damlev("short", "shrt"));
        System.out.println(" " + (Levenshtein.damlev("short", "shrt") == 1 ? "PASS" : "*FAIL*"));
        System.out.println("November 6 2009 damlevlim failing with zero-length arguments");
        System.out.print("damlevlim(\"\", \"\", 3) = " + Levenshtein.damlevlim("", "", 3));
        System.out.println(" " + (Levenshtein.damlevlim("", "", 3) == 0 ? "PASS" : "*FAIL*"));
        System.out.print("damlevlim(\"other one is zero-length\", \"\", 3) = " + Levenshtein.damlevlim("other one is null", "", 3));
        System.out.println(" " + (Levenshtein.damlevlim("other one is zero-length", "", 3) == 3 ? "PASS" : "*FAIL*"));
        System.out.print("damlevlim(\"\", \"other one is zero-length\", 3) = " + Levenshtein.damlevlim("", "other one is zero-length", 3));
        System.out.println(" " + (Levenshtein.damlevlim("", "other one is zero-length", 3) == 3 ? "PASS" : "*FAIL*"));
        System.out.println("November 27 2009 transposition weirdness?");
        System.out.print("damlev(\"banana\", \"baanaa\") = " + Levenshtein.damlev("banana", "baanaa"));
        System.out.println(" " + (Levenshtein.damlev("banana", "baanaa") == 2 ? "PASS" : "*FAIL*"));
        System.out.println("November 27 2009 transposition at either end check");
        System.out.print("damlev(\"banana\", \"banaan\") = " + Levenshtein.damlev("banana", "banaan"));
        System.out.println(" " + (Levenshtein.damlev("banana", "banaan") == 1 ? "PASS" : "*FAIL*"));
        System.out.print("damlev(\"banana\", \"abnana\") = " + Levenshtein.damlev("banana", "abnana"));
        System.out.println(" " + (Levenshtein.damlev("banana", "abnana") == 1 ? "PASS" : "*FAIL*"));
        System.out.println("November 27 2009 transposition at either end check");
        System.out.print("damlev(\"banana\", \"banaan\") = " + Levenshtein.damlev("banana", "banaan"));
        System.out.println(" " + (Levenshtein.damlev("banana", "banaan") == 1 ? "PASS" : "*FAIL*"));
        System.out.println("\n-----------------------Done--------------------------\n");
        System.out.println("Performance timings: expect tests to take about 7 seconds on a 2GHz Intel Core2");
        long TEST_CYCLES = 10000L;
        String STRING1 = "0876786s896d8cvs9dvdfvdf87v09df8v7d0fv7df0v87dsf0v87dfv";
        String STRING2 = "7869vc87b 9cv8b7cvb,2jk3,2gj5k43,25gj4k3,2g5j4k3,2g5jk423,";
        for (int j = 0; j < 4; ++j) {
            int total = 0;
            long lTimer = System.nanoTime();
            int i = 0;
            while ((long)i < TEST_CYCLES) {
                total += Levenshtein.damlev(STRING1, STRING2);
                ++i;
            }
            System.out.println(TEST_CYCLES + " tests (average result: " + (float)total / (float)TEST_CYCLES + ") with array allocated in function average ns: " + (System.nanoTime() - lTimer) / TEST_CYCLES);
            total = 0;
            lTimer = System.nanoTime();
            i = 0;
            while ((long)i < TEST_CYCLES) {
                total += Levenshtein.damlevlim(STRING1, STRING2, 3);
                ++i;
            }
            System.out.println(TEST_CYCLES + " tests of damlevlim(,,3) (average result: " + (float)total / (float)TEST_CYCLES + ") with array allocated in function average ns: " + (System.nanoTime() - lTimer) / TEST_CYCLES);
            total = 0;
            lTimer = System.nanoTime();
            int[] aiWS = Levenshtein.getWorkspace(STRING1.length(), STRING2.length());
            int i2 = 0;
            while ((long)i2 < TEST_CYCLES) {
                total += Levenshtein.damlev(STRING1, STRING2, aiWS);
                ++i2;
            }
            System.out.println(TEST_CYCLES + " tests (average result: " + (float)total / (float)TEST_CYCLES + ") with array preallocated average ns: " + (System.nanoTime() - lTimer) / TEST_CYCLES);
            total = 0;
            lTimer = System.nanoTime();
            aiWS = Levenshtein.getWorkspace(STRING1.length(), STRING2.length());
            i2 = 0;
            while ((long)i2 < TEST_CYCLES) {
                total += Levenshtein.damlevlim(STRING1, STRING2, 3, aiWS);
                ++i2;
            }
            System.out.println(TEST_CYCLES + " tests of damlevlim(,,3) (average result: " + (float)total / (float)TEST_CYCLES + ") with array preallocated average ns: " + (System.nanoTime() - lTimer) / TEST_CYCLES);
        }
        BufferedReader brIn = new BufferedReader(new InputStreamReader(System.in));
        String sIn = null;
        while (true) {
            System.out.println("Two words, separated by space: ");
            sIn = brIn.readLine();
            if (sIn == null) break;
            String[] asIn = sIn.split(" ");
            if (asIn.length != 2) continue;
            System.out.println("lev(" + asIn[0] + ", " + asIn[1] + ") = " + Levenshtein.lev(asIn[0], asIn[1]));
            System.out.println("levlim(" + asIn[0] + ", " + asIn[1] + ", 3) = " + Levenshtein.levlim(asIn[0], asIn[1], 3));
            System.out.println("damlev(" + asIn[0] + ", " + asIn[1] + ") = " + Levenshtein.damlev(asIn[0], asIn[1]));
            System.out.println("damlevlim(" + asIn[0] + ", " + asIn[1] + ", 3) = " + Levenshtein.damlevlim(asIn[0], asIn[1], 3));
        }
    }
}

