/*
 * Decompiled with CFR 0.152.
 */
package com.mockrunner.mock.connector.cci;

import com.mockrunner.mock.connector.cci.MockIndexedRecord;
import com.mockrunner.mock.connector.cci.MockMappedRecord;
import java.util.ArrayList;
import java.util.List;
import javax.resource.ResourceException;
import javax.resource.cci.IndexedRecord;
import javax.resource.cci.MappedRecord;
import javax.resource.cci.Record;
import javax.resource.cci.RecordFactory;

public class MockRecordFactory
implements RecordFactory {
    private List indexedRecords = new ArrayList();
    private List mappedRecords = new ArrayList();

    public void resetIndexedRecords() {
        this.indexedRecords.clear();
    }

    public void resetMappedRecords() {
        this.mappedRecords.clear();
    }

    public int getNumberCreatedIndexedRecords() {
        return this.indexedRecords.size();
    }

    public int getNumberCreatedMappedRecords() {
        return this.mappedRecords.size();
    }

    public List getCreatedIndexedRecords() {
        return this.getCreatedRecords(null, false, this.indexedRecords);
    }

    public List getCreatedIndexedRecords(String string) {
        return this.getCreatedRecords(string, true, this.indexedRecords);
    }

    public List getCreatedMappedRecords() {
        return this.getCreatedRecords(null, false, this.mappedRecords);
    }

    public List getCreatedMappedRecords(String string) {
        return this.getCreatedRecords(string, true, this.mappedRecords);
    }

    private List getCreatedRecords(String string, boolean bl, List list) {
        ArrayList<Record> arrayList = new ArrayList<Record>();
        for (int i = 0; i < list.size(); ++i) {
            RecordWrapper recordWrapper = (RecordWrapper)list.get(i);
            if (!bl) {
                arrayList.add(recordWrapper.getRecord());
                continue;
            }
            this.addRecordIfMatching(string, arrayList, recordWrapper);
        }
        return arrayList;
    }

    private void addRecordIfMatching(String string, List list, RecordWrapper recordWrapper) {
        if (null == string) {
            if (null == recordWrapper.getRecordName()) {
                list.add(recordWrapper.getRecord());
            }
        } else if (string.equals(recordWrapper.getRecordName())) {
            list.add(recordWrapper.getRecord());
        }
    }

    public IndexedRecord createIndexedRecord(String string) throws ResourceException {
        MockIndexedRecord mockIndexedRecord = new MockIndexedRecord(string);
        this.indexedRecords.add(new RecordWrapper(string, mockIndexedRecord));
        return mockIndexedRecord;
    }

    public MappedRecord createMappedRecord(String string) throws ResourceException {
        MockMappedRecord mockMappedRecord = new MockMappedRecord(string);
        this.mappedRecords.add(new RecordWrapper(string, mockMappedRecord));
        return mockMappedRecord;
    }

    private class RecordWrapper {
        private String recordName;
        private Record record;

        public RecordWrapper(String string, Record record) {
            this.recordName = string;
            this.record = record;
        }

        public String getRecordName() {
            return this.recordName;
        }

        public Record getRecord() {
            return this.record;
        }
    }
}

