/*
 * Decompiled with CFR 0.152.
 */
package org.ala.layers.legend;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileWriter;
import java.util.Arrays;
import javax.imageio.ImageIO;
import org.ala.layers.intersect.Grid;

public abstract class Legend {
    static final String LEGEND_KEY = "/legend_key.png";
    public static final int[] colours = new int[]{11728, 23458, 35955, 47428, 59158, 0xA0FF00, 0xFFFF00, 16762900, 0xFFA000, 16734976, 0xFF0000};
    float[] cutoffs;
    float[] cutoffsColours;
    int[] groupSizes;
    int[] groupSizesArea;
    float min;
    float max;
    int numberOfRecords;
    int numberOfUniqueValues;
    int lastValue;
    int divisions;

    public void generate(float[] d) {
        this.generate(d, 10);
    }

    public abstract void generate(float[] var1, int var2);

    public abstract String getTypeName();

    void init(float[] d, int divisions) {
        this.divisions = divisions;
        this.min = d[0];
        for (int i = 0; i < d.length; ++i) {
            if (Float.isNaN(d[i])) continue;
            ++this.numberOfRecords;
            if (i != 0 && d[i] == d[i - 1]) continue;
            ++this.numberOfUniqueValues;
        }
        this.lastValue = this.numberOfRecords;
        this.max = this.numberOfRecords == 0 ? Float.NaN : d[this.numberOfRecords - 1];
        this.cutoffsColours = null;
    }

    public void determineGroupSizes(float[] d) {
        if (this.cutoffs == null) {
            return;
        }
        for (int i = 1; i < this.cutoffs.length; ++i) {
            if (!(this.cutoffs[i] < this.cutoffs[i - 1])) continue;
            for (int j = i; j < this.cutoffs.length; ++j) {
                this.cutoffs[j] = this.cutoffs[i - 1];
            }
            break;
        }
        this.groupSizes = new int[this.cutoffs.length];
        int cutoffPos = 0;
        for (int i = 0; i < d.length; ++i) {
            if (Float.isNaN(d[i])) continue;
            if (d[i] > this.cutoffs[cutoffPos]) {
                while (d[i] > this.cutoffs[cutoffPos]) {
                    ++cutoffPos;
                }
            }
            if (i != 0 && d[i - 1] == d[i]) continue;
            int n = cutoffPos;
            this.groupSizes[n] = this.groupSizes[n] + 1;
        }
        this.groupSizesArea = this.determineGroupSizesArea(d);
    }

    public double evaluateStdDev(float[] d) {
        if (Float.isNaN(this.max)) {
            return Double.NaN;
        }
        this.determineGroupSizes(d);
        float stdev = 0.0f;
        float mean = (float)this.numberOfUniqueValues / (float)this.groupSizes.length;
        for (int i = 0; i < this.groupSizes.length; ++i) {
            stdev = (float)((double)stdev + Math.pow((float)this.groupSizes[i] - mean, 2.0) / (double)this.groupSizes.length);
        }
        stdev = (float)Math.sqrt(stdev);
        return stdev;
    }

    int[] determineGroupSizesArea(float[] d) {
        if (this.cutoffs == null) {
            return null;
        }
        int[] grpSizes = new int[this.cutoffs.length];
        int cutoffPos = 0;
        for (int i = 0; i < d.length; ++i) {
            if (Float.isNaN(d[i])) continue;
            while (d[i] > this.cutoffs[cutoffPos]) {
                while (d[i] > this.cutoffs[cutoffPos]) {
                    ++cutoffPos;
                }
            }
            int n = cutoffPos;
            grpSizes[n] = grpSizes[n] + 1;
        }
        return grpSizes;
    }

    public double evaluateStdDevArea(float[] d) {
        if (Float.isNaN(this.max)) {
            return Double.NaN;
        }
        int[] grpSizes = this.determineGroupSizesArea(d);
        int sum = 0;
        for (int i = 0; i < grpSizes.length; ++i) {
            sum += grpSizes[i];
        }
        double stdev = 0.0;
        double mean = (double)sum / (double)grpSizes.length;
        for (int i = 0; i < grpSizes.length; ++i) {
            stdev += Math.pow((double)grpSizes[i] - mean, 2.0) / (double)grpSizes.length;
        }
        stdev = (float)Math.sqrt(stdev);
        return stdev;
    }

    public void exportImage(float[] d, int width, String filename, int scaleDownBy, boolean minValueTransparent) {
        try {
            BufferedImage image = null;
            image = minValueTransparent ? new BufferedImage(width / scaleDownBy, d.length / width / scaleDownBy, 6) : new BufferedImage(width / scaleDownBy, d.length / width / scaleDownBy, 4);
            int[] image_bytes = image.getRGB(0, 0, image.getWidth(), image.getHeight(), null, 0, image.getWidth());
            for (int i = 0; i < image_bytes.length; ++i) {
                int x = i % (width / scaleDownBy);
                int y = i / (width / scaleDownBy);
                int dataX = x * scaleDownBy;
                int dataY = y * scaleDownBy;
                int dataI = dataX + dataY * width;
                image_bytes[i] = minValueTransparent && d[dataI] == this.min ? 0 : this.getColour(d[dataI]);
            }
            image.setRGB(0, 0, image.getWidth(), image.getHeight(), image_bytes, 0, image.getWidth());
            String extension = filename.substring(filename.length() - 3);
            ImageIO.write((RenderedImage)image, extension, new File(filename));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public int getColour(float d) {
        int lowerPos;
        double lower;
        if (Float.isNaN(d)) {
            return -1;
        }
        int pos = Arrays.binarySearch(this.cutoffs, d);
        if (pos < 0) {
            pos = pos * -1 - 1;
        } else {
            while (pos > 0 && this.cutoffs[pos] == this.cutoffs[pos - 1]) {
                --pos;
            }
        }
        if (this.divisions != 10) {
            // empty if block
        }
        if (pos >= this.cutoffs.length) {
            return -1;
        }
        double upper = this.cutoffs[pos];
        int upperPos = pos + 1;
        if (pos == 0) {
            lower = this.min;
            lowerPos = 0;
        } else {
            lower = this.cutoffs[pos - 1];
            lowerPos = pos;
        }
        if (upper == lower) {
            while (pos > 0 && (double)this.cutoffs[pos - 1] == lower) {
                --pos;
            }
            return colours[pos];
        }
        double v = ((double)d - lower) / (upper - lower);
        double vt = 1.0 - v;
        int red = (int)((double)(colours[lowerPos] & 0xFF0000) * vt + (double)(colours[upperPos] & 0xFF0000) * v);
        int green = (int)((double)(colours[lowerPos] & 0xFF00) * vt + (double)(colours[upperPos] & 0xFF00) * v);
        int blue = (int)((double)(colours[lowerPos] & 0xFF) * vt + (double)(colours[upperPos] & 0xFF) * v);
        return red & 0xFF0000 | green & 0xFF00 | blue & 0xFF | 0xFF000000;
    }

    public static int getColour(double d, double min, double max) {
        if (Double.isNaN(d) || d < min || d > max) {
            return -1;
        }
        double range = max - min;
        double a = (d - min) / range;
        int pos = (int)a;
        if (pos == 10) {
            --pos;
        }
        double lower = (double)pos / 10.0 * range + min;
        double upper = (double)(pos + 1) / 10.0 * range + min;
        double v = (d - lower) / (upper - lower);
        double vt = 1.0 - v;
        int red = (int)((double)(colours[pos] & 0xFF0000) * vt + (double)(colours[pos + 1] & 0xFF0000) * v);
        int green = (int)((double)(colours[pos] & 0xFF00) * vt + (double)(colours[pos + 1] & 0xFF00) * v);
        int blue = (int)((double)(colours[pos] & 0xFF) * vt + (double)(colours[pos + 1] & 0xFF) * v);
        return red & 0xFF0000 | green & 0xFF00 | blue & 0xFF | 0xFF000000;
    }

    public static int getLinearColour(double d, double min, double max, int startColour, int endColour) {
        double v = (d - min) / (max - min);
        double vt = 1.0 - v;
        int red = (int)((double)(startColour & 0xFF0000) * vt + (double)(endColour & 0xFF0000) * v);
        int green = (int)((double)(startColour & 0xFF00) * vt + (double)(endColour & 0xFF00) * v);
        int blue = (int)((double)(startColour & 0xFF) * vt + (double)(endColour & 0xFF) * v);
        return red & 0xFF0000 | green & 0xFF00 | blue & 0xFF | 0xFF000000;
    }

    public String getCutoffs() {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < this.cutoffs.length; ++i) {
            if (this.groupSizes != null && this.groupSizesArea != null) {
                sb.append(String.valueOf(this.cutoffs[i])).append("\t").append(String.valueOf(this.groupSizes[i])).append("\t").append(String.valueOf(this.groupSizesArea[i])).append("\n");
                continue;
            }
            sb.append(String.valueOf(this.cutoffs[i])).append("\n");
        }
        return sb.toString();
    }

    void exportLegend(String filename) {
        try {
            FileWriter fw = new FileWriter(filename);
            fw.append(this.getCutoffs());
            fw.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public float[] getCutoffFloats() {
        return this.cutoffs;
    }

    public float[] getMinMax() {
        float[] f = new float[]{this.min, this.max};
        return f;
    }

    public void exportSLD(Grid g, String outputfilename, String units, boolean hasNoDataValue, boolean minAsTransparent) {
        String header = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<sld:UserStyle xmlns=\"http://www.opengis.net/sld\" xmlns:sld=\"http://www.opengis.net/sld\" xmlns:ogc=\"http://www.opengis.net/ogc\" xmlns:gml=\"http://www.opengis.net/gml\">\n  <sld:Name>raster</sld:Name>\n<sld:Title>A very simple color map</sld:Title>\n  <sld:Abstract>A very basic color map</sld:Abstract>\n  <sld:FeatureTypeStyle>\n    <sld:Name>name</sld:Name>\n    <sld:FeatureTypeName>Feature</sld:FeatureTypeName>\n    <sld:Rule>\n      <sld:RasterSymbolizer>\n        <sld:Geometry>\n          <ogc:PropertyName>geom</ogc:PropertyName>\n        </sld:Geometry>\n        <sld:ChannelSelection>\n          <sld:GrayChannel>\n            <sld:SourceChannelName>1</sld:SourceChannelName>\n          </sld:GrayChannel>\n        </sld:ChannelSelection>\n        <sld:ColorMap>\n";
        String footer = " </sld:ColorMap>\n      </sld:RasterSymbolizer>\n    </sld:Rule>\n  </sld:FeatureTypeStyle>\n</sld:UserStyle>";
        StringBuilder sb = new StringBuilder();
        sb.append(header);
        if (hasNoDataValue) {
            sb.append("\n<sld:ColorMapEntry color=\"#ffffff\" opacity=\"0\" quantity=\"" + g.nodatavalue + "\"/>\n");
        }
        String c = String.format("%6s", Integer.toHexString(colours[0])).replace(" ", "0");
        if (minAsTransparent) {
            sb.append("<sld:ColorMapEntry color=\"#" + c + "\" opacity=\"0\" quantity=\"" + this.min + "\" label=\"" + this.min + " " + units + "\"/>\n");
        } else {
            sb.append("<sld:ColorMapEntry color=\"#" + c + "\" quantity=\"" + this.min + "\" label=\"" + this.min + " " + units + "\"/>\n");
        }
        for (int i = 0; i < this.cutoffs.length - 1; ++i) {
            if ((i != 0 || this.cutoffs[i] == this.min) && (i <= 0 || this.cutoffs[i] == this.cutoffs[i - 1])) continue;
            c = String.format("%6s", Integer.toHexString(colours[i + 1])).replace(" ", "0");
            sb.append("<sld:ColorMapEntry color=\"#" + c + "\" quantity=\"" + this.cutoffs[i] + "\" />\n");
        }
        c = String.format("%6s", Integer.toHexString(colours[this.cutoffs.length])).replace(" ", "0");
        sb.append("<sld:ColorMapEntry color=\"#" + c + "\" quantity=\"" + this.cutoffs[this.cutoffs.length - 1] + "\" label=\"" + this.cutoffs[this.cutoffs.length - 1] + " " + units + "\"/>\n");
        sb.append(footer);
        try {
            FileWriter fw = new FileWriter(outputfilename);
            fw.append(sb.toString());
            fw.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void generateLegend(String filename) {
        try {
            String path = Legend.class.getResource(LEGEND_KEY).getFile();
            System.out.println("generating legend using key: " + path + " and producing output at " + filename);
            BufferedImage legendImage = ImageIO.read(new File(path));
            File ciOut = new File(filename);
            Graphics cg = legendImage.getGraphics();
            cg.setColor(Color.BLACK);
            cg.setFont(new Font("Arial", 0, 10));
            String sdata = "";
            int width = legendImage.getWidth();
            int height = legendImage.getHeight();
            int padding = 10;
            int keyHeight = 30;
            int keyWidth = 25;
            width -= padding * 2;
            height -= padding * 2;
            int top = padding + keyHeight / 2;
            int left = padding * 2 + keyWidth;
            for (int i = 0; i < this.cutoffs.length; ++i) {
                String value = "<= " + this.cutoffs[i];
                cg.drawString(value, left, top);
                top += keyHeight;
            }
            ImageIO.write((RenderedImage)legendImage, "png", ciOut);
        }
        catch (Exception e) {
            System.out.println("Unable to write legendImage:");
            e.printStackTrace(System.out);
        }
    }
}

