/*
 * Decompiled with CFR 0.152.
 */
package org.ala.layers.intersect;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.ala.layers.dao.FieldDAO;
import org.ala.layers.dao.LayerDAO;
import org.ala.layers.dto.Field;
import org.ala.layers.dto.GridClass;
import org.ala.layers.dto.IntersectionFile;
import org.ala.layers.dto.Layer;
import org.ala.layers.intersect.SimpleShapeFileCache;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.log4j.Logger;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.type.TypeReference;

public class IntersectConfig {
    public static final String GEOSERVER_URL_PLACEHOLDER = "<COMMON_GEOSERVER_URL>";
    public static final String GEONETWORK_URL_PLACEHOLDER = "<COMMON_GEONETWORK_URL>";
    private static final Logger logger = Logger.getLogger(IntersectConfig.class);
    static final String ALASPATIAL_OUTPUT_PATH = "ALASPATIAL_OUTPUT_PATH";
    static final String LAYER_FILES_PATH = "LAYER_FILES_PATH";
    static final String ANALYSIS_LAYER_FILES_PATH = "ANALYSIS_LAYER_FILES_PATH";
    static final String LAYER_INDEX_URL = "LAYER_INDEX_URL";
    static final String BATCH_THREAD_COUNT = "BATCH_THREAD_COUNT";
    static final String CONFIG_RELOAD_WAIT = "CONFIG_RELOAD_WAIT";
    static final String PRELOADED_SHAPE_FILES = "PRELOADED_SHAPE_FILES";
    static final String GRID_BUFFER_SIZE = "GRID_BUFFER_SIZE";
    static final String GRID_CACHE_PATH = "GRID_CACHE_PATH";
    static final String GRID_CACHE_READER_COUNT = "GRID_CACHE_READER_COUNT";
    static final String LOCAL_SAMPLING = "LOCAL_SAMPLING";
    static final String GEOSERVER_URL = "GEOSERVER_URL";
    static final String GEONETWORK_URL = "GEONETWORK_URL";
    static final String GDAL_PATH = "GDAL_PATH";
    static final String ANALYSIS_RESOLUTIONS = "ANALYSIS_RESOLUTIONS";
    static final String OCCURRENCE_SPECIES_RECORDS_FILENAME = "OCCURRENCE_SPECIES_RECORDS_FILENAME";
    static final String UPLOADED_SHAPES_FIELD_ID = "UPLOADED_SHAPES_FIELD_ID";
    static final String API_KEY_CHECK_URL_TEMPLATE = "API_CHECK_CHECK_URL_TEMPLATE";
    static final String SPATIAL_PORTAL_APP_NAME = "SPATIAL_PORTAL_APP_NAME";
    static final String LAYER_PROPERTIES = "layer.properties";
    static ObjectMapper mapper = new ObjectMapper();
    private FieldDAO fieldDao;
    private LayerDAO layerDao;
    static String layerFilesPath;
    static String analysisLayerFilesPath;
    static String alaspatialOutputPath;
    static String layerIndexUrl;
    static int batchThreadCount;
    static long configReloadWait;
    long lastReload;
    static String preloadedShapeFiles;
    static int gridBufferSize;
    SimpleShapeFileCache shapeFileCache;
    HashMap<String, IntersectionFile> intersectionFiles;
    static String gridCachePath;
    static int gridCacheReaderCount;
    HashMap<String, HashMap<Integer, GridClass>> classGrids;
    static boolean localSampling;
    static String geoserverUrl;
    static String geonetworkUrl;
    static String gdalPath;
    static List<Double> analysisResolutions;
    static String occurrenceSpeciesRecordsFilename;
    static String uploadedShapesFieldId;
    static String apiKeyCheckUrlTemplate;
    static String spatialPortalAppName;

    public IntersectConfig(FieldDAO fieldDao, LayerDAO layerDao) {
        this.fieldDao = fieldDao;
        this.layerDao = layerDao;
        this.load();
    }

    public void load() {
        this.lastReload = System.currentTimeMillis();
        try {
            this.updateIntersectionFiles();
            this.updateShapeFileCache();
        }
        catch (Exception e) {
            logger.error((Object)"load failed, retry in 30s", (Throwable)e);
            configReloadWait = 30000L;
        }
    }

    static String getProperty(String property, Properties properties, String defaultValue) {
        String p = System.getProperty(property);
        if (p == null) {
            p = properties.getProperty(property);
        }
        if (p == null) {
            p = defaultValue;
        }
        logger.info((Object)(property + " > " + p));
        return p;
    }

    static long getPositiveLongProperty(String property, Properties properties, long defaultValue) {
        String p = IntersectConfig.getProperty(property, properties, null);
        long l = defaultValue;
        try {
            l = Long.parseLong(p);
            if (l < 0L) {
                l = defaultValue;
            }
        }
        catch (NumberFormatException ex) {
            logger.error((Object)("parsing " + property + ": " + p + ", using default: " + defaultValue), (Throwable)ex);
        }
        return l;
    }

    public static String getAlaspatialOutputPath() {
        return alaspatialOutputPath;
    }

    public static String getLayerFilesPath() {
        return layerFilesPath;
    }

    public static String getLayerIndexUrl() {
        return layerIndexUrl;
    }

    public static int getThreadCount() {
        return batchThreadCount;
    }

    public IntersectionFile getIntersectionFile(String fieldId) {
        return this.intersectionFiles.get(fieldId);
    }

    public String getFieldIdFromFile(String file) {
        String on;
        String off;
        if (File.separator.equals("/")) {
            off = "\\";
            on = "/";
        } else {
            on = "\\";
            off = "/";
        }
        file = file.replace(off, on);
        for (Map.Entry<String, IntersectionFile> entry : this.intersectionFiles.entrySet()) {
            if (!entry.getValue().getFilePath().replace(off, on).equalsIgnoreCase(file)) continue;
            return entry.getKey();
        }
        return file;
    }

    private void updateIntersectionFiles() throws MalformedURLException, IOException {
        if (this.intersectionFiles == null) {
            this.intersectionFiles = new HashMap();
            this.classGrids = new HashMap();
        }
        if (layerIndexUrl != null) {
            JSONArray layers = JSONArray.fromObject((Object)this.getUrl(layerIndexUrl + "/layers"));
            HashMap<String, String> layerPathOrig = new HashMap<String, String>();
            HashMap<String, String> layerName = new HashMap<String, String>();
            HashMap<String, String> layerType = new HashMap<String, String>();
            HashMap<String, String> layerPid = new HashMap<String, String>();
            for (int i = 0; i < layers.size(); ++i) {
                layerPathOrig.put(layers.getJSONObject(i).getString("id"), layers.getJSONObject(i).getString("path_orig"));
                layerName.put(layers.getJSONObject(i).getString("id"), layers.getJSONObject(i).getString("name"));
                layerType.put(layers.getJSONObject(i).getString("id"), layers.getJSONObject(i).getString("type"));
                layerPid.put(layers.getJSONObject(i).getString("id"), layers.getJSONObject(i).getString("id"));
            }
            JSONArray fields = JSONArray.fromObject((Object)this.getUrl(layerIndexUrl + "/fieldsdb"));
            for (int i = 0; i < fields.size(); ++i) {
                JSONObject jo = fields.getJSONObject(i);
                String spid = jo.getString("spid");
                if (layerPathOrig.get(spid) == null) {
                    logger.error((Object)("cannot find layer with id '" + spid + "'"));
                    continue;
                }
                HashMap<Integer, GridClass> gridClasses = IntersectConfig.getGridClasses(layerFilesPath + (String)layerPathOrig.get(spid), (String)layerType.get(spid));
                this.intersectionFiles.put(jo.getString("id"), new IntersectionFile(jo.getString("name"), layerFilesPath + (String)layerPathOrig.get(spid), jo.containsKey((Object)"sname") ? jo.getString("sname") : null, (String)layerName.get(spid), jo.getString("id"), jo.getString("name"), (String)layerPid.get(spid), jo.getString("type"), gridClasses));
                this.intersectionFiles.put((String)layerName.get(spid), new IntersectionFile(jo.getString("name"), layerFilesPath + (String)layerPathOrig.get(spid), jo.containsKey((Object)"sname") ? jo.getString("sname") : null, (String)layerName.get(jo.getString("spid")), jo.getString("id"), jo.getString("name"), (String)layerPid.get(spid), jo.getString("type"), gridClasses));
                this.intersectionFiles.put((String)layerPid.get(spid), new IntersectionFile(jo.getString("name"), layerFilesPath + (String)layerPathOrig.get(spid), jo.containsKey((Object)"sname") ? jo.getString("sname") : null, (String)layerName.get(jo.getString("spid")), jo.getString("id"), jo.getString("name"), (String)layerPid.get(spid), jo.getString("type"), gridClasses));
                this.classGrids.put(jo.getString("id"), gridClasses);
            }
        } else {
            for (Field f : this.fieldDao.getFields()) {
                if (!f.isEnabled().booleanValue()) continue;
                Layer layer = this.layerDao.getLayerById(Integer.parseInt(f.getSpid()));
                if (layer == null) {
                    logger.error((Object)("cannot find layer with id '" + f.getSpid() + "'"));
                    continue;
                }
                HashMap<Integer, GridClass> gridClasses = IntersectConfig.getGridClasses(IntersectConfig.getLayerFilesPath() + layer.getPath_orig(), layer.getType());
                this.intersectionFiles.put(f.getId(), new IntersectionFile(f.getName(), IntersectConfig.getLayerFilesPath() + layer.getPath_orig(), f.getSname(), layer.getName(), f.getId(), f.getName(), String.valueOf(layer.getId()), f.getType(), gridClasses));
                this.intersectionFiles.put(layer.getName(), new IntersectionFile(f.getName(), IntersectConfig.getLayerFilesPath() + layer.getPath_orig(), f.getSname(), layer.getName(), f.getId(), f.getName(), String.valueOf(layer.getId()), f.getType(), gridClasses));
                this.intersectionFiles.put(String.valueOf(layer.getId()), new IntersectionFile(f.getName(), IntersectConfig.getLayerFilesPath() + layer.getPath_orig(), f.getSname(), layer.getName(), f.getId(), f.getName(), String.valueOf(layer.getId()), f.getType(), gridClasses));
                this.classGrids.put(f.getId(), gridClasses);
            }
        }
    }

    String getUrl(String url) {
        try {
            logger.info((Object)("opening url: " + url));
            HttpClient client = new HttpClient();
            GetMethod get = new GetMethod(url);
            int result = client.executeMethod((HttpMethod)get);
            String slist = get.getResponseBodyAsString();
            return slist;
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    void updateShapeFileCache() {
        if (preloadedShapeFiles == null) {
            return;
        }
        String[] fields = preloadedShapeFiles.split(",");
        String[] layers = new String[fields.length];
        String[] columns = new String[fields.length];
        String[] fid = new String[fields.length];
        if (fields.length == 1 && fields[0].equalsIgnoreCase("all")) {
            int countCL = 0;
            for (String s : this.intersectionFiles.keySet()) {
                if (!s.startsWith("cl")) continue;
                ++countCL;
            }
            layers = new String[countCL];
            columns = new String[countCL];
            fid = new String[countCL];
            int i = 0;
            for (IntersectionFile f : this.intersectionFiles.values()) {
                if (!f.getFieldId().startsWith("cl")) continue;
                layers[i] = f.getFilePath();
                columns[i] = f.getShapeFields();
                fid[i] = f.getFieldId();
                ++i;
            }
        } else {
            for (int i = 0; i < fields.length; ++i) {
                layers[i] = this.getIntersectionFile(fields[i].trim()).getFilePath();
                columns[i] = this.getIntersectionFile(fields[i].trim()).getShapeFields();
                fid[i] = fields[i];
            }
        }
        if (this.shapeFileCache == null) {
            this.shapeFileCache = new SimpleShapeFileCache(layers, columns, fid);
        } else {
            this.shapeFileCache.update(layers, columns, fid);
        }
    }

    public void addToShapeFileCache(String fieldIds) {
        if (preloadedShapeFiles != null) {
            fieldIds = fieldIds + "," + preloadedShapeFiles;
        }
        String[] fields = fieldIds.split(",");
        String[] layers = new String[fields.length];
        String[] columns = new String[fields.length];
        String[] fid = new String[fields.length];
        int pos = 0;
        for (int i = 0; i < fields.length; ++i) {
            try {
                layers[pos] = this.getIntersectionFile(fields[i].trim()).getFilePath();
                columns[pos] = this.getIntersectionFile(fields[i].trim()).getShapeFields();
                fid[pos] = fields[i];
                ++pos;
                continue;
            }
            catch (Exception e) {
                logger.error((Object)("problem adding shape file to cache for field: " + fields[i]), (Throwable)e);
            }
        }
        if (pos < layers.length) {
            layers = Arrays.copyOf(layers, pos);
            columns = Arrays.copyOf(columns, pos);
            fid = Arrays.copyOf(fid, pos);
        }
        if (this.shapeFileCache == null) {
            this.shapeFileCache = new SimpleShapeFileCache(layers, columns, fid);
        } else {
            this.shapeFileCache.update(layers, columns, fid);
        }
    }

    public SimpleShapeFileCache getShapeFileCache() {
        return this.shapeFileCache;
    }

    public static int getGridBufferSize() {
        return gridBufferSize;
    }

    public static String getGridCachePath() {
        return gridCachePath;
    }

    public static int getGridCacheReaderCount() {
        return gridCacheReaderCount;
    }

    private static HashMap<Integer, GridClass> getGridClasses(String filePath, String type) throws IOException {
        HashMap classes = null;
        if (type.equals("Contextual") && new File(filePath + ".gri").exists() && new File(filePath + ".grd").exists() && new File(filePath + ".txt").exists()) {
            File gridClassesFile = new File(filePath + ".classes.json");
            if (gridClassesFile.exists()) {
                classes = (HashMap)mapper.readValue(gridClassesFile, (TypeReference)new TypeReference<Map<Integer, GridClass>>(){});
                logger.info((Object)("found grid classes for " + gridClassesFile.getPath()));
            } else {
                logger.error((Object)("classes unavailable for " + gridClassesFile.getPath() + ", build classes offline"));
            }
        } else {
            logger.info((Object)("no grid classes for " + filePath));
        }
        return classes;
    }

    public static long getConfigReloadWait() {
        return configReloadWait;
    }

    public boolean requiresReload() {
        return this.lastReload + configReloadWait >= System.currentTimeMillis();
    }

    public boolean isLocalSampling() {
        return localSampling;
    }

    public List<Field> getFieldsByDB() {
        List<Field> fields = new ArrayList<Field>();
        if (layerIndexUrl != null) {
            try {
                fields = (List)mapper.readValue(this.getUrl(layerIndexUrl + "/fieldsdb"), (TypeReference)new TypeReference<List<Field>>(){});
            }
            catch (Exception ex) {
                logger.error((Object)("failed to read: " + layerIndexUrl + "/fieldsdb"), (Throwable)ex);
            }
        }
        return fields;
    }

    public static String getGeoserverUrl() {
        return geoserverUrl;
    }

    public static String getGeonetworkUrl() {
        return geonetworkUrl;
    }

    public static String getAnalysisLayerFilesPath() {
        return analysisLayerFilesPath;
    }

    public static String getGdalPath() {
        return gdalPath;
    }

    public static List<Double> getAnalysisResolutions() {
        return analysisResolutions;
    }

    private static List<Double> getDoublesFrom(String property) {
        ArrayList<Double> l = new ArrayList<Double>();
        if (property != null) {
            for (String s : property.split(",")) {
                try {
                    Double d = Double.parseDouble(s.trim());
                    if (d != null && !d.isNaN()) {
                        l.add(d);
                        continue;
                    }
                    logger.warn((Object)("Cannot parse '" + s + "' to Double"));
                }
                catch (Exception e) {
                    logger.warn((Object)("Cannot parse '" + s + "' to Double"), (Throwable)e);
                }
            }
        }
        Collections.sort(l);
        return l;
    }

    public static String getOccurrenceSpeciesRecordsFilename() {
        return occurrenceSpeciesRecordsFilename;
    }

    public static String getUploadedShapesFieldId() {
        return uploadedShapesFieldId;
    }

    public static String getApiKeyCheckUrlTemplate() {
        return apiKeyCheckUrlTemplate;
    }

    public static String getSpatialPortalAppName() {
        return spatialPortalAppName;
    }

    public Map<String, IntersectionFile> getIntersectionFiles() {
        return this.intersectionFiles;
    }

    public String[] getAnalysisLayerInfo(String id) {
        String name = null;
        String filename = null;
        String gid = null;
        if (id.startsWith("species_")) {
            gid = id.substring("species_".length());
            filename = IntersectConfig.getAlaspatialOutputPath() + File.separator + "maxent" + File.separator + gid + File.separator + gid;
            name = "Prediction";
        } else if (id.startsWith("aloc_")) {
            gid = id.substring("aloc_".length());
            filename = IntersectConfig.getAlaspatialOutputPath() + File.separator + "aloc" + File.separator + gid + File.separator + "aloc";
            name = "Classification";
        } else if (id.startsWith("odensity_")) {
            gid = id.substring("odensity_".length());
            filename = IntersectConfig.getAlaspatialOutputPath() + File.separator + "sitesbyspecies" + File.separator + gid + File.separator + "occurrence_density";
            name = "Occurrence Density";
        } else if (id.startsWith("srichness_")) {
            gid = id.substring("srichness_".length());
            filename = IntersectConfig.getAlaspatialOutputPath() + File.separator + "sitesbyspecies" + File.separator + gid + File.separator + "species_richness";
            name = "Species Richness";
        } else if (id.endsWith("_odensity")) {
            gid = id.substring(0, id.length() - "_odensity".length());
            filename = IntersectConfig.getAlaspatialOutputPath() + File.separator + "sitesbyspecies" + File.separator + gid + File.separator + "occurrence_density";
            name = "Occurrence Density";
        } else if (id.endsWith("_srichness")) {
            gid = id.substring(0, id.length() - "_srichness".length());
            filename = IntersectConfig.getAlaspatialOutputPath() + File.separator + "sitesbyspecies" + File.separator + gid + File.separator + "species_richness";
            name = "Species Richness";
        } else if (id.startsWith("envelope_")) {
            gid = id.substring("envelope_".length());
            filename = IntersectConfig.getAlaspatialOutputPath() + File.separator + "envelope" + File.separator + gid + File.separator + "envelope";
            name = "Environmental Envelope";
        } else if (id.startsWith("gdm_")) {
            int pos1 = id.indexOf("_");
            int pos2 = id.lastIndexOf("_");
            String[] gdmparts = new String[]{id.substring(0, pos1), id.substring(pos1 + 1, pos2), id.substring(pos2 + 1)};
            gid = gdmparts[2];
            filename = IntersectConfig.getAlaspatialOutputPath() + File.separator + "gdm" + File.separator + gid + File.separator + gdmparts[1];
            name = "Transformed " + this.getIntersectionFile(gdmparts[1].replaceAll("Tran", "")).getFieldName();
        } else if (id.contains("_")) {
            int pos = id.indexOf("_");
            String[] gdmparts = new String[]{id.substring(0, pos), id.substring(pos + 1)};
            gid = gdmparts[0];
            filename = IntersectConfig.getAlaspatialOutputPath() + File.separator + "gdm" + File.separator + gid + File.separator + gdmparts[1] + "Tran";
            logger.debug((Object)("id: " + id));
            logger.debug((Object)("parts: " + gdmparts[0] + ", " + gdmparts[1]));
            logger.debug((Object)("filename: " + filename));
            name = "Transformed " + this.getIntersectionFile(gdmparts[1]).getFieldName();
        }
        if (gid != null) {
            return new String[]{gid, filename, name};
        }
        return null;
    }

    static {
        Properties properties = new Properties();
        try {
            InputStream is = IntersectConfig.class.getResourceAsStream("/layer.properties");
            if (is != null) {
                properties.load(is);
            } else {
                String msg = "cannot get properties file: " + IntersectConfig.class.getResource(LAYER_PROPERTIES).getFile();
                logger.warn((Object)msg);
            }
        }
        catch (IOException ex) {
            logger.error(null, (Throwable)ex);
        }
        layerFilesPath = IntersectConfig.getProperty(LAYER_FILES_PATH, properties, null);
        analysisLayerFilesPath = IntersectConfig.getProperty(ANALYSIS_LAYER_FILES_PATH, properties, null);
        alaspatialOutputPath = IntersectConfig.getProperty(ALASPATIAL_OUTPUT_PATH, properties, null);
        layerIndexUrl = IntersectConfig.getProperty(LAYER_INDEX_URL, properties, null);
        batchThreadCount = (int)IntersectConfig.getPositiveLongProperty(BATCH_THREAD_COUNT, properties, 1L);
        configReloadWait = IntersectConfig.getPositiveLongProperty(CONFIG_RELOAD_WAIT, properties, 3600000L);
        preloadedShapeFiles = IntersectConfig.getProperty(PRELOADED_SHAPE_FILES, properties, null);
        gridBufferSize = (int)IntersectConfig.getPositiveLongProperty(GRID_BUFFER_SIZE, properties, 4096L);
        gridCachePath = IntersectConfig.getProperty(GRID_CACHE_PATH, properties, null);
        gridCacheReaderCount = (int)IntersectConfig.getPositiveLongProperty(GRID_CACHE_READER_COUNT, properties, 10L);
        localSampling = IntersectConfig.getProperty(LOCAL_SAMPLING, properties, "true").toLowerCase().equals("true");
        geoserverUrl = IntersectConfig.getProperty(GEOSERVER_URL, properties, null);
        geonetworkUrl = IntersectConfig.getProperty(GEONETWORK_URL, properties, null);
        gdalPath = IntersectConfig.getProperty(GDAL_PATH, properties, null);
        analysisResolutions = IntersectConfig.getDoublesFrom(IntersectConfig.getProperty(ANALYSIS_RESOLUTIONS, properties, "0.5"));
        occurrenceSpeciesRecordsFilename = IntersectConfig.getProperty(OCCURRENCE_SPECIES_RECORDS_FILENAME, properties, null);
        uploadedShapesFieldId = IntersectConfig.getProperty(UPLOADED_SHAPES_FIELD_ID, properties, null);
        apiKeyCheckUrlTemplate = IntersectConfig.getProperty(API_KEY_CHECK_URL_TEMPLATE, properties, null);
        spatialPortalAppName = IntersectConfig.getProperty(SPATIAL_PORTAL_APP_NAME, properties, null);
    }
}

