/*
 * Decompiled with CFR 0.152.
 */
package org.ala.layers.grid;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Polygon;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.ala.layers.grid.Pos;
import org.geotools.geometry.jts.JTSFactoryFinder;

public class Grid2Shape {
    static final byte lEdge = 1;
    static final byte rEdge = 2;
    static final byte tEdge = 4;
    static final byte bEdge = 8;

    public static String grid2Wkt(BitSet data, int nrows, int ncols, double minx, double miny, double resx, double resy) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            Grid2Shape.streamGrid2Wkt(baos, data, nrows, ncols, minx, miny, resx, resy);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return baos.toString();
    }

    public static HashMap grid2WktIndexed(BitSet data, int nrows, int ncols, double minx, double miny, double resx, double resy, int startKey) {
        int[] map = new int[nrows * ncols];
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        StringBuilder index = new StringBuilder();
        try {
            Grid2Shape.streamGrid2WktIndexed(baos, data, nrows, ncols, minx, miny, resx, resy, map, index, startKey);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        HashMap<String, Object> output = new HashMap<String, Object>();
        output.put("wkt", baos.toString());
        output.put("map", map);
        output.put("index", index.toString());
        return output;
    }

    public static void streamGrid2Wkt(OutputStream os, BitSet data, int nrows, int ncols, double minx, double miny, double resx, double resy) throws IOException {
        int gid = 0;
        os.write("MULTIPOLYGON(".getBytes());
        gid = Grid2Shape.getPolygonsWkt(os, gid, data, nrows, ncols, resx, resy, minx, miny);
        os.write(")".getBytes());
    }

    public static void streamGrid2WktIndexed(OutputStream os, BitSet data, int nrows, int ncols, double minx, double miny, double resx, double resy, int[] map, StringBuilder index, int startKey) throws IOException {
        int characterPos = 0;
        os.write("MULTIPOLYGON(".getBytes());
        characterPos += 13;
        characterPos = Grid2Shape.getPolygonsWktIndexed(os, characterPos, data, nrows, ncols, resx, resy, minx, miny, map, index, startKey);
        os.write(")".getBytes());
        ++characterPos;
    }

    public static MultiPolygon grid2Multipolygon(BitSet data, int nrows, int ncols, double minx, double miny, double resx, double resy) {
        int gid = 0;
        ArrayList<Polygon> polygons = new ArrayList<Polygon>();
        gid = Grid2Shape.getPolygons(polygons, gid, data, nrows, ncols, resx, resy, minx, miny);
        GeometryFactory geometryFactory = JTSFactoryFinder.getGeometryFactory(null);
        Polygon[] polygonArray = new Polygon[polygons.size()];
        polygons.toArray(polygonArray);
        return geometryFactory.createMultiPolygon(polygonArray);
    }

    public static String grid2Wkt(float[] data, double minValue, double maxValue, int nrows, int ncols, double minx, double miny, double resx, double resy) {
        return (String)Grid2Shape.grid2Object(true, data, minValue, maxValue, nrows, ncols, minx, miny, resx, resy, null);
    }

    public static HashMap grid2WktIndexed(float[] data, double minValue, double maxValue, int nrows, int ncols, double minx, double miny, double resx, double resy, int[] map) {
        int[] bbox = new int[4];
        int count = 0;
        for (int i = 0; i < data.length; ++i) {
            if (!((double)data[i] <= maxValue) || !((double)data[i] >= minValue)) continue;
            int x = i % ncols;
            int y = i / ncols;
            if (count == 0 || bbox[0] > x) {
                bbox[0] = x;
            }
            if (count == 0 || bbox[2] < x) {
                bbox[2] = x;
            }
            if (count == 0 || bbox[1] > y) {
                bbox[1] = y;
            }
            if (count == 0 || bbox[3] < y) {
                bbox[3] = y;
            }
            ++count;
        }
        int rows = bbox[3] - bbox[1] + 1;
        int cols = bbox[2] - bbox[0] + 1;
        int len = rows * cols;
        BitSet grid = new BitSet(rows * cols);
        for (int i = 0; i < len; ++i) {
            int x = i % cols;
            int y = i / cols;
            int pos = x + bbox[0] + ncols * (y + bbox[1]);
            if (!((double)data[pos] <= maxValue) || !((double)data[pos] >= minValue)) continue;
            grid.set(i);
        }
        if (map == null) {
            map = new int[nrows * ncols];
        }
        int startKey = Grid2Shape.getArrayMax(map) + 1;
        HashMap m = Grid2Shape.grid2WktIndexed(grid, rows, cols, minx + (double)bbox[0] * resx, miny + (double)(nrows - bbox[3] - 1) * resy, resx, resy, startKey);
        int[] partial = (int[])m.get("map");
        for (int i = 0; i < len; ++i) {
            int x = i % cols;
            int y = i / cols;
            int pos = x + bbox[0] + ncols * (y + bbox[1]);
            if (!((double)data[pos] <= maxValue) || !((double)data[pos] >= minValue)) continue;
            map[pos] = partial[i];
        }
        m.put("map", map);
        return m;
    }

    public static void streamGrid2Wkt(OutputStream os, float[] data, double minValue, double maxValue, int nrows, int ncols, double minx, double miny, double resx, double resy) {
        Grid2Shape.grid2Object(true, data, minValue, maxValue, nrows, ncols, minx, miny, resx, resy, os);
    }

    static Object grid2Object(boolean isWkt, float[] data, double minValue, double maxValue, int nrows, int ncols, double minx, double miny, double resx, double resy, OutputStream os) {
        int[] bbox = new int[4];
        int count = 0;
        for (int i = 0; i < data.length; ++i) {
            if (!((double)data[i] <= maxValue) || !((double)data[i] >= minValue)) continue;
            int x = i % ncols;
            int y = i / ncols;
            if (count == 0 || bbox[0] > x) {
                bbox[0] = x;
            }
            if (count == 0 || bbox[2] < x) {
                bbox[2] = x;
            }
            if (count == 0 || bbox[1] > y) {
                bbox[1] = y;
            }
            if (count == 0 || bbox[3] < y) {
                bbox[3] = y;
            }
            ++count;
        }
        int rows = bbox[3] - bbox[1] + 1;
        int cols = bbox[2] - bbox[0] + 1;
        int len = rows * cols;
        BitSet grid = new BitSet(rows * cols);
        for (int i = 0; i < len; ++i) {
            int x = i % cols;
            int y = i / cols;
            int pos = x + bbox[0] + ncols * (y + bbox[1]);
            if (!((double)data[pos] <= maxValue) || !((double)data[pos] >= minValue)) continue;
            grid.set(i);
        }
        if (isWkt) {
            if (os != null) {
                try {
                    Grid2Shape.streamGrid2Wkt(os, grid, rows, cols, minx + (double)bbox[0] * resx, miny + (double)(nrows - bbox[3] - 1) * resy, resx, resy);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                return null;
            }
            return Grid2Shape.grid2Wkt(grid, rows, cols, minx + (double)bbox[0] * resx, miny + (double)(nrows - bbox[3] - 1) * resy, resx, resy);
        }
        return Grid2Shape.grid2Multipolygon(grid, rows, cols, minx + (double)bbox[0] * resx, miny + (double)(nrows - bbox[3] - 1) * resy, resx, resy);
    }

    public static MultiPolygon grid2Multipolygon(float[] data, double minValue, double maxValue, int nrows, int ncols, double minx, double miny, double resx, double resy) {
        return (MultiPolygon)Grid2Shape.grid2Object(false, data, minValue, maxValue, nrows, ncols, minx, miny, resx, resy, null);
    }

    static int getX(int pos, int ncols) {
        return pos % ncols;
    }

    static int getY(int pos, int ncols) {
        return pos / ncols;
    }

    static int getPos(int x, int y, int ncols) {
        return x + y * ncols;
    }

    static int getPolygonsWkt(OutputStream os, int gid, BitSet data, int nrows, int ncols, double xres, double yres, double minx, double miny) throws IOException {
        int[] image = new int[data.size()];
        byte[] edges = new byte[data.size()];
        HashMap<Integer, Map.Entry<Integer, Set<Integer>>> polygons = new HashMap<Integer, Map.Entry<Integer, Set<Integer>>>();
        Grid2Shape.findEdges(data, image, edges, nrows, ncols, polygons, 1);
        gid = Grid2Shape.edgesToPolyonsWkt(os, gid, edges, image, nrows, ncols, xres, yres, minx, miny, polygons);
        return gid;
    }

    static int getPolygonsWktIndexed(OutputStream os, int gid, BitSet data, int nrows, int ncols, double xres, double yres, double minx, double miny, int[] map, StringBuilder index, int startKey) throws IOException {
        int[] image = null;
        image = map != null ? map : new int[data.size()];
        byte[] edges = new byte[data.size()];
        HashMap<Integer, Map.Entry<Integer, Set<Integer>>> polygons = new HashMap<Integer, Map.Entry<Integer, Set<Integer>>>();
        Grid2Shape.findEdges(data, image, edges, nrows, ncols, polygons, startKey);
        int len = nrows * ncols;
        for (int i = 0; i < len; ++i) {
            if (!data.get(i)) continue;
            map[i] = image[i];
        }
        gid = Grid2Shape.edgesToPolyonsWktIndexed(os, gid, edges, image, nrows, ncols, xres, yres, minx, miny, polygons, index);
        return gid;
    }

    public static int getPolygons(ArrayList<Polygon> output, int gid, BitSet data, int nrows, int ncols, double xres, double yres, double minx, double miny) {
        int[] image = new int[data.size()];
        byte[] edges = new byte[data.size()];
        HashMap<Integer, Map.Entry<Integer, Set<Integer>>> polygons = new HashMap<Integer, Map.Entry<Integer, Set<Integer>>>();
        Grid2Shape.findEdges(data, image, edges, nrows, ncols, polygons, 1);
        gid = Grid2Shape.edgesToPolyons(output, gid, edges, image, nrows, ncols, xres, yres, minx, miny, polygons);
        return gid;
    }

    static void findEdges(BitSet data, int[] image, byte[] edges, int nrows, int ncols, HashMap<Integer, Map.Entry<Integer, Set<Integer>>> polygons, int startKey) {
        int groups = startKey;
        SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yy hh:mm:ss:SSS");
        long time = System.currentTimeMillis() + 10000L;
        int groupCount = 0;
        for (int i = 0; i < nrows; ++i) {
            if (time < System.currentTimeMillis()) {
                System.out.println(sdf.format(new Date()) + " processing row " + i + " of " + nrows);
                time = System.currentTimeMillis() + 10000L;
            }
            for (int j = 0; j < ncols; ++j) {
                int pos = Grid2Shape.getPos(j, i, ncols);
                if (!data.get(pos)) continue;
                if (j > 0 && image[pos - 1] > 0) {
                    image[pos] = image[pos - 1];
                    boolean joinedWithNewGroup = false;
                    if (i > 0 && data.get(pos - ncols) && image[pos - ncols] != image[pos]) {
                        Set<Integer> oldStarts;
                        joinedWithNewGroup = true;
                        int oldGroup = Math.max(image[pos - ncols], image[pos]);
                        int newGroup = Math.min(image[pos - ncols], image[pos]);
                        for (int n = i; n >= 0; --n) {
                            boolean cellFound = false;
                            for (int m = 0; m < ncols; ++m) {
                                int p = Grid2Shape.getPos(m, n, ncols);
                                if (image[p] != oldGroup) continue;
                                image[p] = newGroup;
                                cellFound = true;
                            }
                            if (n != i && !cellFound) break;
                        }
                        if ((oldStarts = polygons.get(oldGroup).getValue()) != null) {
                            Set<Integer> newStarts = polygons.get(newGroup).getValue();
                            if (newStarts == null) {
                                newStarts = new HashSet<Integer>();
                                polygons.get(newGroup).setValue(newStarts);
                            }
                            newStarts.addAll(oldStarts);
                            polygons.put(oldGroup, null);
                        }
                        polygons.remove(oldGroup);
                        --groupCount;
                    }
                    if (!joinedWithNewGroup && (i == 0 || image[pos - ncols] != image[pos] || j > 0 && (edges[pos - 1] & 8) > 0)) {
                        if (j > 0 && i > 0 && image[pos - ncols] == image[pos]) {
                            if (image[pos - ncols - 1] != image[pos]) {
                                Set<Integer> starts = polygons.get(image[pos]).getValue();
                                if (starts == null) {
                                    starts = new HashSet<Integer>();
                                    polygons.get(image[pos]).setValue(starts);
                                }
                                starts.add(pos - ncols);
                            }
                        } else {
                            int n = pos;
                            edges[n] = (byte)(edges[n] | 8);
                        }
                    }
                    if (j == 0 || image[pos - 1] != image[pos]) {
                        int n = pos;
                        edges[n] = (byte)(edges[n] | 1);
                    }
                    if (j + 1 == ncols || !data.get(pos + 1)) {
                        int n = pos;
                        edges[n] = (byte)(edges[n] | 2);
                    }
                    if (i + 1 != nrows && data.get(pos + ncols)) continue;
                    int n = pos;
                    edges[n] = (byte)(edges[n] | 4);
                    continue;
                }
                if (i > 0 && image[pos - ncols] > 0) {
                    image[pos] = image[pos - ncols];
                    if (i == 0) {
                        int n = pos;
                        edges[n] = (byte)(edges[n] | 8);
                    }
                    if (j == 0 || image[pos - 1] != image[pos]) {
                        int n = pos;
                        edges[n] = (byte)(edges[n] | 1);
                    }
                    if (j + 1 == ncols || !data.get(pos + 1)) {
                        int n = pos;
                        edges[n] = (byte)(edges[n] | 2);
                    }
                    if (i + 1 != nrows && data.get(pos + ncols)) continue;
                    int n = pos;
                    edges[n] = (byte)(edges[n] | 4);
                    continue;
                }
                image[pos] = groups;
                polygons.put(groups, new AbstractMap.SimpleEntry<Integer, Object>(pos, null));
                ++groups;
                int n = pos;
                edges[n] = (byte)(edges[n] | 1);
                int n2 = pos;
                edges[n2] = (byte)(edges[n2] | 8);
                if (j + 1 == ncols || !data.get(pos + 1)) {
                    int n3 = pos;
                    edges[n3] = (byte)(edges[n3] | 2);
                }
                if (i + 1 == nrows || !data.get(pos + ncols)) {
                    int n4 = pos;
                    edges[n4] = (byte)(edges[n4] | 4);
                }
                ++groupCount;
            }
        }
    }

    static int edgesToPolyonsWkt(OutputStream os, int gid, byte[] edges, int[] image, int nrows, int ncols, double resx, double resy, double minx, double miny, HashMap<Integer, Map.Entry<Integer, Set<Integer>>> polygons) throws IOException {
        for (int key : polygons.keySet()) {
            if (polygons.get(key) == null) continue;
            if (gid > 0) {
                os.write(",".getBytes());
            }
            os.write("(".getBytes());
            Grid2Shape.getLinearRingWkt(os, 0, polygons.get(key).getKey(), null, edges, image, nrows, ncols, minx, miny, resx, resy, false);
            Set<Integer> holeStarts = polygons.get(key).getValue();
            if (holeStarts != null) {
                while (holeStarts.size() > 0) {
                    os.write(",".getBytes());
                    Grid2Shape.getLinearRingWkt(os, 0, holeStarts.iterator().next(), holeStarts, edges, image, nrows, ncols, minx, miny, resx, resy, true);
                }
            }
            os.write(")".getBytes());
            ++gid;
        }
        return gid;
    }

    static int edgesToPolyonsWktIndexed(OutputStream os, int characterPos, byte[] edges, int[] image, int nrows, int ncols, double resx, double resy, double minx, double miny, HashMap<Integer, Map.Entry<Integer, Set<Integer>>> polygons, StringBuilder index) throws IOException {
        int thisKey;
        ArrayList<Integer> keys = new ArrayList<Integer>(polygons.keySet());
        Collections.sort(keys);
        if (keys == null || keys.isEmpty()) {
            System.out.println("no polygons for this key value");
            return characterPos;
        }
        int startKey = thisKey = keys.get(0).intValue();
        int[] sequentialKeys = new int[keys.get(keys.size() - 1) + 1 - startKey];
        for (int i = 0; i < keys.size(); ++i) {
            int key = keys.get(i);
            sequentialKeys[key - startKey] = thisKey;
            if (polygons.get(key) == null) continue;
            if (characterPos > 15) {
                os.write(",".getBytes());
                ++characterPos;
            }
            index.append(thisKey).append(",").append(characterPos).append("\n");
            os.write("(".getBytes());
            ++characterPos;
            characterPos = Grid2Shape.getLinearRingWkt(os, characterPos, polygons.get(key).getKey(), null, edges, image, nrows, ncols, minx, miny, resx, resy, false);
            Set<Integer> holeStarts = polygons.get(key).getValue();
            if (holeStarts != null) {
                while (holeStarts.size() > 0) {
                    os.write(",".getBytes());
                    ++characterPos;
                    characterPos = Grid2Shape.getLinearRingWkt(os, characterPos, holeStarts.iterator().next(), holeStarts, edges, image, nrows, ncols, minx, miny, resx, resy, true);
                }
            }
            ++thisKey;
            os.write(")".getBytes());
            ++characterPos;
        }
        for (int k = 0; k < image.length; ++k) {
            if (image[k] <= 0) continue;
            image[k] = sequentialKeys[image[k] - startKey];
        }
        return characterPos;
    }

    private static int getLinearRingWkt(OutputStream os, int characterPos, int startPos, Set<Integer> holeStarts, byte[] edges, int[] image, int nrows, int ncols, double minx, double miny, double resx, double resy, boolean reverse) throws IOException {
        ArrayList<double[]> coords = new ArrayList<double[]>();
        byte startEdge = 0;
        boolean startCw = true;
        if ((edges[startPos] & 1) > 0) {
            startEdge = 1;
        } else if ((edges[startPos] & 2) > 0) {
            startEdge = 2;
        } else if ((edges[startPos] & 4) > 0) {
            startEdge = 4;
        } else if ((edges[startPos] & 8) > 0) {
            startEdge = 8;
        }
        if (holeStarts != null) {
            holeStarts.remove(startPos);
        }
        coords.add(Grid2Shape.createCoordinate(startPos, startEdge, ncols, nrows, minx, miny, resx, resy, true));
        Pos current = new Pos();
        current.cw = startCw;
        current.edge = startEdge;
        current.pos = startPos;
        Grid2Shape.moveNext(current, edges, image, nrows, ncols);
        if (holeStarts != null) {
            holeStarts.remove(current.pos);
        }
        while (current.pos != startPos || current.edge != startEdge || current.cw != startCw) {
            coords.add(Grid2Shape.createCoordinate(current.pos, current.edge, ncols, nrows, minx, miny, resx, resy, true));
            Grid2Shape.moveNext(current, edges, image, nrows, ncols);
            if (holeStarts == null) continue;
            holeStarts.remove(current.pos);
        }
        coords.add(Grid2Shape.createCoordinate(current.pos, current.edge, ncols, nrows, minx, miny, resx, resy, true));
        os.write("(".getBytes());
        ++characterPos;
        if (!reverse) {
            float nlat;
            float nlng;
            float tlng = nlng = (float)((double[])coords.get(0))[0];
            float plng = nlng;
            float tlat = nlat = (float)((double[])coords.get(0))[1];
            float plat = nlat;
            int count = 0;
            for (int i = 0; i < coords.size(); ++i) {
                String s;
                if (i + 1 < coords.size()) {
                    nlng = (float)((double[])coords.get(i + 1))[0];
                    nlat = (float)((double[])coords.get(i + 1))[1];
                    if (count == 0 || (plng != tlng || tlng != nlng) && (plat != tlat || tlat != nlat)) {
                        if (count > 0) {
                            os.write(",".getBytes());
                            ++characterPos;
                        }
                        s = tlng + " " + tlat;
                        os.write(s.getBytes());
                        characterPos += s.length();
                        ++count;
                    }
                } else {
                    if (count > 0) {
                        os.write(",".getBytes());
                        ++characterPos;
                    }
                    s = tlng + " " + tlat;
                    os.write(s.getBytes());
                    characterPos += s.length();
                    ++count;
                }
                plng = tlng;
                tlng = nlng;
                plat = tlat;
                tlat = nlat;
            }
        } else {
            float nlat;
            float nlng;
            float tlng = nlng = (float)((double[])coords.get(coords.size() - 1))[0];
            float plng = nlng;
            float tlat = nlat = (float)((double[])coords.get(coords.size() - 1))[1];
            float plat = nlat;
            int count = 0;
            for (int i = coords.size() - 1; i >= 0; --i) {
                String s;
                if (i > 0) {
                    nlng = (float)((double[])coords.get(i - 1))[0];
                    nlat = (float)((double[])coords.get(i - 1))[1];
                    if (count == 0 || (plng != tlng || tlng != nlng) && (plat != tlat || tlat != nlat)) {
                        if (count > 0) {
                            os.write(",".getBytes());
                            ++characterPos;
                        }
                        s = tlng + " " + tlat;
                        os.write(s.getBytes());
                        characterPos += s.length();
                        ++count;
                    }
                } else {
                    if (count > 0) {
                        os.write(",".getBytes());
                        ++characterPos;
                    }
                    s = tlng + " " + tlat;
                    os.write(s.getBytes());
                    characterPos += s.length();
                    ++count;
                }
                plng = tlng;
                tlng = nlng;
                plat = tlat;
                tlat = nlat;
            }
        }
        os.write(")".getBytes());
        return ++characterPos;
    }

    static int edgesToPolyons(ArrayList<Polygon> output, int gid, byte[] edges, int[] image, int nrows, int ncols, double resx, double resy, double minx, double miny, HashMap<Integer, Map.Entry<Integer, Set<Integer>>> polygons) {
        GeometryFactory geometryFactory = JTSFactoryFinder.getGeometryFactory(null);
        for (int key : polygons.keySet()) {
            if (polygons.get(key) == null) continue;
            LinearRing lr = Grid2Shape.getLinearRing(polygons.get(key).getKey(), null, edges, image, nrows, ncols, minx, miny, resx, resy, false);
            Set<Integer> holeStarts = polygons.get(key).getValue();
            LinearRing[] holesArray = null;
            if (holeStarts != null) {
                ArrayList<LinearRing> holes = new ArrayList<LinearRing>();
                while (holeStarts.size() > 0) {
                    holes.add(Grid2Shape.getLinearRing(holeStarts.iterator().next(), holeStarts, edges, image, nrows, ncols, minx, miny, resx, resy, true));
                }
                if (holes.size() > 0) {
                    holesArray = new LinearRing[holes.size()];
                    holes.toArray(holesArray);
                }
            }
            output.add(geometryFactory.createPolygon(lr, holesArray));
            ++gid;
        }
        return gid;
    }

    private static LinearRing getLinearRing(int startPos, Set<Integer> holeStarts, byte[] edges, int[] image, int nrows, int ncols, double minx, double miny, double resx, double resy, boolean reverse) {
        ArrayList<double[]> coords = new ArrayList<double[]>();
        byte startEdge = 0;
        boolean startCw = true;
        if ((edges[startPos] & 1) > 0) {
            startEdge = 1;
        } else if ((edges[startPos] & 2) > 0) {
            startEdge = 2;
        } else if ((edges[startPos] & 4) > 0) {
            startEdge = 4;
        } else if ((edges[startPos] & 8) > 0) {
            startEdge = 8;
        }
        if (holeStarts != null) {
            holeStarts.remove(startPos);
        }
        coords.add(Grid2Shape.createCoordinate(startPos, startEdge, ncols, nrows, minx, miny, resx, resy, true));
        Pos current = new Pos();
        current.cw = startCw;
        current.edge = startEdge;
        current.pos = startPos;
        Grid2Shape.moveNext(current, edges, image, nrows, ncols);
        if (holeStarts != null) {
            holeStarts.remove(current.pos);
        }
        while (current.pos != startPos || current.edge != startEdge || current.cw != startCw) {
            coords.add(Grid2Shape.createCoordinate(current.pos, current.edge, ncols, nrows, minx, miny, resx, resy, true));
            Grid2Shape.moveNext(current, edges, image, nrows, ncols);
            if (holeStarts == null) continue;
            holeStarts.remove(current.pos);
        }
        coords.add(Grid2Shape.createCoordinate(current.pos, current.edge, ncols, nrows, minx, miny, resx, resy, true));
        Coordinate[] ca = new Coordinate[coords.size()];
        int pos = 0;
        if (!reverse) {
            float nlat;
            float nlng;
            float tlng = nlng = (float)((double[])coords.get(0))[0];
            float plng = nlng;
            float tlat = nlat = (float)((double[])coords.get(0))[1];
            float plat = nlat;
            for (int i = 0; i < coords.size(); ++i) {
                if (i + 1 < coords.size()) {
                    nlng = (float)((double[])coords.get(i + 1))[0];
                    nlat = (float)((double[])coords.get(i + 1))[1];
                    if (pos == 0 || (plng != tlng || tlng != nlng) && (plat != tlat || tlat != nlat)) {
                        ca[pos] = new Coordinate((double)tlng, (double)tlat);
                        ++pos;
                    }
                } else {
                    ca[pos] = new Coordinate((double)tlng, (double)tlat);
                    ++pos;
                }
                plng = tlng;
                tlng = nlng;
                plat = tlat;
                tlat = nlat;
            }
        } else {
            float nlat;
            float nlng;
            float tlng = nlng = (float)((double[])coords.get(coords.size() - 1))[0];
            float plng = nlng;
            float tlat = nlat = (float)((double[])coords.get(coords.size() - 1))[1];
            float plat = nlat;
            for (int i = coords.size() - 1; i >= 0; --i) {
                if (i > 0) {
                    nlng = (float)((double[])coords.get(i - 1))[0];
                    nlat = (float)((double[])coords.get(i - 1))[1];
                    if (pos == 0 || (plng != tlng || tlng != nlng) && (plat != tlat || tlat != nlat)) {
                        ca[pos] = new Coordinate((double)tlng, (double)tlat);
                        ++pos;
                    }
                } else {
                    ca[pos] = new Coordinate((double)tlng, (double)tlat);
                    ++pos;
                }
                plng = tlng;
                tlng = nlng;
                plat = tlat;
                tlat = nlat;
            }
        }
        if (pos < ca.length) {
            ca = Arrays.copyOf(ca, pos);
        }
        return new LinearRing(ca, null, 4326);
    }

    static double[] createCoordinate(int pos, byte edge, int ncols, int nrows, double minx, double miny, double resx, double resy, boolean cw) {
        if (!cw) {
            if (edge == 1) {
                edge = (byte)4;
            }
            if (edge == 4) {
                edge = (byte)2;
            }
            if (edge == 2) {
                edge = (byte)8;
            }
            if (edge == 8) {
                edge = 1;
            }
        }
        double x = minx + (double)Grid2Shape.getX(pos, ncols) * resx;
        double y = miny + (double)(nrows - Grid2Shape.getY(pos, ncols)) * resy;
        switch (edge) {
            case 1: {
                break;
            }
            case 2: {
                y -= resy;
                x += resx;
                break;
            }
            case 4: {
                y -= resy;
                break;
            }
            case 8: {
                x += resx;
            }
        }
        return new double[]{x, y};
    }

    private static void moveNext(Pos current, byte[] edges, int[] image, int nrows, int ncols) {
        int thisImage = image[current.pos];
        int x = Grid2Shape.getX(current.pos, ncols);
        int y = Grid2Shape.getY(current.pos, ncols);
        if (current.cw) {
            switch (current.edge) {
                case 1: {
                    int checkPos;
                    if ((edges[current.pos] & 4) > 0) {
                        current.edge = (byte)4;
                        break;
                    }
                    if (y + 1 < nrows && image[checkPos = current.pos + ncols] == thisImage && (edges[checkPos] & 1) > 0) {
                        current.pos = checkPos;
                        break;
                    }
                    if (y + 1 < nrows && x > 0 && image[checkPos = current.pos + ncols - 1] == thisImage && (edges[checkPos] & 8) > 0) {
                        current.edge = (byte)8;
                        current.pos = checkPos;
                        break;
                    }
                    System.out.println("path not coded");
                    break;
                }
                case 2: {
                    int checkPos;
                    if ((edges[current.pos] & 8) > 0) {
                        current.edge = (byte)8;
                        break;
                    }
                    if (y > 0 && image[checkPos = current.pos - ncols] == thisImage && (edges[checkPos] & 2) > 0) {
                        current.pos = checkPos;
                        break;
                    }
                    if (y > 0 && x + 1 < ncols && image[checkPos = current.pos - ncols + 1] == thisImage && (edges[checkPos] & 4) > 0) {
                        current.edge = (byte)4;
                        current.pos = checkPos;
                        break;
                    }
                    System.out.println("path not coded");
                    break;
                }
                case 4: {
                    int checkPos;
                    if ((edges[current.pos] & 2) > 0) {
                        current.edge = (byte)2;
                        break;
                    }
                    if (x + 1 < ncols && image[checkPos = current.pos + 1] == thisImage && (edges[checkPos] & 4) > 0) {
                        current.pos = checkPos;
                        break;
                    }
                    if (y + 1 < nrows && x + 1 < ncols && image[checkPos = current.pos + ncols + 1] == thisImage && (edges[checkPos] & 1) > 0) {
                        current.edge = 1;
                        current.pos = checkPos;
                        break;
                    }
                    System.out.println("path not coded");
                    break;
                }
                case 8: {
                    int checkPos;
                    if ((edges[current.pos] & 1) > 0) {
                        current.edge = 1;
                        break;
                    }
                    if (x > 0 && image[checkPos = current.pos - 1] == thisImage && (edges[checkPos] & 8) > 0) {
                        current.pos = checkPos;
                        break;
                    }
                    if (y > 0 && x > 0 && image[checkPos = current.pos - ncols - 1] == thisImage && (edges[checkPos] & 2) > 0) {
                        current.edge = (byte)2;
                        current.pos = checkPos;
                        break;
                    }
                    System.out.println("path not coded");
                }
            }
        } else {
            System.out.println("path not coded");
        }
    }

    public static int getArrayMax(int[] wktMap) {
        int max = wktMap[0];
        for (int i = 1; i < wktMap.length; ++i) {
            if (wktMap[i] <= max) continue;
            max = wktMap[i];
        }
        return max;
    }

    public static int getArrayMin(int[] wktMap) {
        int min = wktMap[0];
        for (int i = 1; i < wktMap.length; ++i) {
            if (wktMap[i] == 0 || min != 0 && wktMap[i] >= min) continue;
            min = wktMap[i];
        }
        return min;
    }
}

