/*
 * Decompiled with CFR 0.152.
 */
package org.ala.layers.distribution;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.LinkedBlockingQueue;
import org.ala.layers.distribution.AreaThread;

public class DistributionGenerator {
    static int CONCURRENT_THREADS = 6;
    static String db_url = "jdbc:postgresql://localhost:5432/layersdb";
    static String db_usr = "postgres";
    static String db_pwd = "postgres";

    private static Connection getConnection() {
        Connection conn = null;
        try {
            Class.forName("org.postgresql.Driver");
            String url = db_url;
            conn = DriverManager.getConnection(url, db_usr, db_pwd);
        }
        catch (Exception e) {
            System.out.println("Unable to create Connection");
            e.printStackTrace(System.out);
        }
        return conn;
    }

    public static void main(String[] args) {
        System.out.println("Calculates and fills empty area_km in table distributionshapes.\n\nargs[0] = threadcount, args[1] = db connection string,\n args[2] = db username,\n args[3] = password\n");
        if (args.length >= 4) {
            CONCURRENT_THREADS = Integer.parseInt(args[0]);
            db_url = args[1];
            db_usr = args[2];
            db_pwd = args[3];
        }
        long start = System.currentTimeMillis();
        while (DistributionGenerator.updateArea() > 0) {
            System.out.println("time since start= " + (System.currentTimeMillis() - start) + "ms");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int updateArea() {
        Connection conn = null;
        try {
            int j;
            conn = DistributionGenerator.getConnection();
            String sql = "SELECT id, ST_AsText(the_geom) as wkt FROM distributionshapes WHERE area_km is null limit 100";
            if (conn == null) {
                System.out.println("connection is null");
            } else {
                System.out.println("connection is not null");
            }
            Statement s1 = conn.createStatement();
            ResultSet rs1 = s1.executeQuery(sql);
            LinkedBlockingQueue<String[]> data = new LinkedBlockingQueue<String[]>();
            while (rs1.next()) {
                data.put(new String[]{rs1.getString("id"), rs1.getString("wkt")});
            }
            System.out.println("next " + data.size());
            int size = data.size();
            if (size == 0) {
                int n = 0;
                return n;
            }
            CountDownLatch cdl = new CountDownLatch(data.size());
            AreaThread[] threads = new AreaThread[CONCURRENT_THREADS];
            for (j = 0; j < CONCURRENT_THREADS; ++j) {
                threads[j] = new AreaThread(data, cdl, DistributionGenerator.getConnection().createStatement());
                threads[j].start();
            }
            cdl.await();
            for (j = 0; j < CONCURRENT_THREADS; ++j) {
                try {
                    threads[j].s.getConnection().close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                threads[j].interrupt();
            }
            int n = size;
            return n;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return 0;
    }
}

