/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.dwc.terms;

import java.net.URI;
import org.gbif.dwc.terms.Term;

public class UnknownTerm
implements Term {
    private final URI uri;
    private final String name;

    public static UnknownTerm build(String qualifiedName) {
        return new UnknownTerm(URI.create(qualifiedName));
    }

    public static UnknownTerm build(String qualifiedName, String simpleName) {
        return new UnknownTerm(URI.create(qualifiedName), simpleName);
    }

    public UnknownTerm(URI uri, String name) {
        if (uri == null || !uri.isAbsolute()) {
            throw new IllegalArgumentException("The qualified name URI must be an absolute URI");
        }
        if (name == null || name.isEmpty()) {
            throw new IllegalArgumentException("The simple name is required");
        }
        this.uri = uri;
        this.name = name;
    }

    public UnknownTerm(URI uri) {
        if (uri == null || !uri.isAbsolute()) {
            throw new IllegalArgumentException("The qualified name URI is required and must be an absolute URI");
        }
        String name = null;
        if (uri.getFragment() != null) {
            name = uri.getFragment();
        } else if (uri.getPath() != null) {
            int pos;
            name = uri.getPath();
            if (name.endsWith("/")) {
                name = name.substring(0, name.length() - 1);
            }
            if (name.startsWith("/")) {
                name = name.substring(1);
            }
            if ((pos = name.lastIndexOf("/")) > 0) {
                name = name.substring(pos + 1);
            }
        } else {
            throw new IllegalArgumentException("The qualified name URI must have a path or fragment to automatically derive a simple name");
        }
        if (name == null || name.isEmpty()) {
            throw new IllegalArgumentException("The simple name is required");
        }
        this.uri = uri;
        this.name = name;
    }

    @Override
    public String qualifiedName() {
        return this.uri.toString();
    }

    @Override
    public String simpleName() {
        return this.name;
    }

    public String toString() {
        return this.uri.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Term)) {
            return false;
        }
        Term that = (Term)o;
        return this.qualifiedName().equals(that.qualifiedName());
    }

    public int hashCode() {
        return this.qualifiedName().hashCode();
    }
}

