/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.dwc.text;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.gbif.api.model.registry.Dataset;
import org.gbif.dwc.record.Record;
import org.gbif.dwc.terms.DcTerm;
import org.gbif.dwc.terms.DwcTerm;
import org.gbif.dwc.terms.Term;
import org.gbif.dwc.text.Archive;
import org.gbif.dwc.text.ArchiveField;
import org.gbif.dwc.text.ArchiveFile;
import org.gbif.dwc.text.MetaDescriptorWriter;
import org.gbif.file.TabWriter;
import org.gbif.registry.metadata.EMLWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DwcaWriter {
    private Logger log = LoggerFactory.getLogger(DwcaWriter.class);
    private final File dir;
    private final boolean useHeaders;
    private long recordNum;
    private String coreId;
    private Map<Term, String> coreRow;
    private final Term coreRowType;
    private final Term coreIdTerm;
    private final Map<Term, TabWriter> writers = Maps.newHashMap();
    private final Set<Term> headersOut = Sets.newHashSet();
    private final Map<Term, String> dataFileNames = Maps.newHashMap();
    private final Map<Term, List<Term>> terms = Maps.newHashMap();
    private final Map<Term, Map<Term, String>> defaultValues = Maps.newHashMap();
    private Dataset eml;

    public DwcaWriter(Term coreRowType, File dir) throws IOException {
        this(coreRowType, dir, false);
    }

    public DwcaWriter(Term coreRowType, File dir, boolean useHeaders) throws IOException {
        this(coreRowType, null, dir, useHeaders);
    }

    public DwcaWriter(Term coreRowType, Term coreIdTerm, File dir, boolean useHeaders) throws IOException {
        this.dir = dir;
        this.coreRowType = coreRowType;
        this.coreIdTerm = coreIdTerm;
        this.useHeaders = useHeaders;
        this.addRowType(coreRowType);
    }

    public static Map<Term, String> recordToMap(Record rec, ArchiveFile af) {
        HashMap<Term, String> map = new HashMap<Term, String>();
        for (Term t : af.getTerms()) {
            map.put(t, rec.value(t));
        }
        return map;
    }

    public static String dataFileName(Term rowType) {
        return rowType.simpleName().toLowerCase() + ".txt";
    }

    private void addRowType(Term rowType) throws IOException {
        this.terms.put(rowType, new ArrayList());
        String dfn = DwcaWriter.dataFileName(rowType);
        this.dataFileNames.put(rowType, dfn);
        File df = new File(this.dir, dfn);
        FileUtils.forceMkdir((File)df.getParentFile());
        FileOutputStream out = new FileOutputStream(df);
        TabWriter wr = new TabWriter(out);
        this.writers.put(rowType, wr);
    }

    public void newRecord(String id) throws IOException {
        this.flushLastCoreRecord();
        ++this.recordNum;
        this.coreId = id;
        this.coreRow = new HashMap<Term, String>();
    }

    private void flushLastCoreRecord() throws IOException {
        if (this.coreRow != null) {
            this.writeRow(this.coreRow, this.coreRowType);
        }
    }

    public long getRecordsWritten() {
        return this.recordNum;
    }

    private void writeRow(Map<Term, String> rowMap, Term rowType) throws IOException {
        TabWriter writer = this.writers.get(rowType);
        List<Term> columns = this.terms.get(rowType);
        if (this.useHeaders && !this.headersOut.contains(rowType)) {
            this.writeHeader(writer, rowType, columns);
        }
        if (this.coreRowType != rowType && this.coreId == null) {
            this.log.warn("Adding an {} extension record to a core without an Id! Skip this record", (Object)rowType);
        } else {
            String[] row = new String[columns.size() + 1];
            row[0] = this.coreId;
            for (Map.Entry<Term, String> conceptTermStringEntry : rowMap.entrySet()) {
                int column = 1 + columns.indexOf(conceptTermStringEntry.getKey());
                row[column] = conceptTermStringEntry.getValue();
            }
            writer.write(row);
        }
    }

    private void writeHeader(TabWriter writer, Term rowType, List<Term> columns) throws IOException {
        int idx = 0;
        String[] row = new String[columns.size() + 1];
        Enum idTerm = DwcTerm.Taxon == this.coreRowType ? DwcTerm.taxonID : (DwcTerm.Occurrence == this.coreRowType ? DwcTerm.occurrenceID : (DwcTerm.Identification == this.coreRowType ? DwcTerm.identificationID : (DwcTerm.Event == this.coreRowType ? DwcTerm.eventID : DcTerm.identifier)));
        row[idx] = idTerm.simpleName();
        for (Term term : columns) {
            row[++idx] = term.simpleName();
        }
        writer.write(row);
        this.headersOut.add(rowType);
    }

    public void addCoreColumn(Term term, String value) {
        if (this.coreIdTerm != null && this.coreIdTerm.equals(term)) {
            throw new IllegalStateException("You cannot add a term that was specified as coreId term");
        }
        List<Term> coreTerms = this.terms.get(this.coreRowType);
        if (!coreTerms.contains(term)) {
            if (this.useHeaders && this.recordNum > 1L) {
                throw new IllegalStateException("You cannot add new terms after the first row when headers are enabled");
            }
            coreTerms.add(term);
        }
        try {
            this.coreRow.put(term, value);
        }
        catch (NullPointerException e) {
            throw new IllegalStateException("No core record has been created yet. Call newRecord() at least once");
        }
    }

    public void addCoreDefaultValue(Term term, String defaultValue) {
        this.addDefaultValue(this.coreRowType, term, defaultValue);
    }

    public void addDefaultValue(Term rowType, Term term, String defaultValue) {
        Map<Term, String> currentDefaultValues;
        if (!this.defaultValues.containsKey(rowType)) {
            this.defaultValues.put(rowType, new HashMap());
        }
        if ((currentDefaultValues = this.defaultValues.get(rowType)).containsKey(term)) {
            throw new IllegalStateException("The default value of term " + term + " is already defined");
        }
        currentDefaultValues.put(term, defaultValue);
    }

    public Map<Term, String> getDataFiles() {
        return Maps.newHashMap(this.dataFileNames);
    }

    public void addExtensionRecord(Term rowType, Map<Term, String> row) throws IOException {
        if (!this.terms.containsKey(rowType)) {
            this.addRowType(rowType);
        }
        List<Term> knownTerms = this.terms.get(rowType);
        boolean isFirst = knownTerms.isEmpty();
        for (Term term : row.keySet()) {
            if (knownTerms.contains(term)) continue;
            if (this.useHeaders && !isFirst) {
                throw new IllegalStateException("You cannot add new terms after the first row when headers are enabled");
            }
            knownTerms.add(term);
        }
        this.writeRow(row, rowType);
    }

    public void setEml(Dataset eml) {
        this.eml = eml;
    }

    @Deprecated
    public void finalize() throws IOException {
        this.close();
    }

    public void close() throws IOException {
        this.addEml();
        this.addMeta();
        this.flushLastCoreRecord();
        for (TabWriter w : this.writers.values()) {
            w.close();
        }
    }

    private void addEml() throws IOException {
        if (this.eml != null) {
            FileWriter writer = new FileWriter(new File(this.dir, "eml.xml"));
            EMLWriter.write((Dataset)this.eml, (Writer)writer);
        }
    }

    private void addMeta() throws IOException {
        File metaFile = new File(this.dir, "meta.xml");
        Archive arch = new Archive();
        if (this.eml != null) {
            arch.setMetadataLocation("eml.xml");
        }
        arch.setCore(this.buildArchiveFile(arch, this.coreRowType, this.coreIdTerm));
        for (Term rowType : this.terms.keySet()) {
            if (this.coreRowType.equals(rowType)) continue;
            arch.addExtension(this.buildArchiveFile(arch, rowType, null));
        }
        MetaDescriptorWriter.writeMetaFile(metaFile, arch);
    }

    private ArchiveFile buildArchiveFile(Archive archive, Term rowType, Term idTerm) {
        ArchiveFile af = ArchiveFile.buildTabFile();
        af.setArchive(archive);
        af.addLocation(this.dataFileNames.get(rowType));
        af.setEncoding("utf-8");
        af.setIgnoreHeaderLines(this.useHeaders ? 1 : 0);
        af.setRowType(rowType);
        ArchiveField id = new ArchiveField();
        id.setIndex(0);
        af.setId(id);
        if (idTerm != null) {
            ArchiveField field = new ArchiveField();
            field.setIndex(0);
            field.setTerm(idTerm);
            af.addField(field);
        }
        Map<Term, String> termDefaultValueMap = this.defaultValues.get(rowType);
        List<Term> rowTypeTerms = this.terms.get(rowType);
        int idx = 0;
        for (Term c : rowTypeTerms) {
            ArchiveField field = new ArchiveField();
            field.setIndex(++idx);
            field.setTerm(c);
            if (termDefaultValueMap != null && termDefaultValueMap.containsKey(c)) {
                field.setDefaultValue(termDefaultValueMap.get(c));
            }
            af.addField(field);
        }
        if (termDefaultValueMap != null) {
            ArchiveField field = null;
            for (Term t : termDefaultValueMap.keySet()) {
                if (rowTypeTerms.contains(t)) continue;
                field = new ArchiveField();
                field.setTerm(t);
                field.setDefaultValue(termDefaultValueMap.get(t));
                af.addField(field);
            }
        }
        return af;
    }
}

