/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.dwc.text;

import com.google.common.base.Strings;
import com.google.common.collect.Iterators;
import com.google.common.collect.Maps;
import com.google.common.collect.PeekingIterator;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.gbif.api.model.registry.Dataset;
import org.gbif.dwc.record.DarwinCoreRecord;
import org.gbif.dwc.record.Record;
import org.gbif.dwc.record.RecordImpl;
import org.gbif.dwc.record.RecordIterator;
import org.gbif.dwc.record.StarRecord;
import org.gbif.dwc.record.StarRecordImpl;
import org.gbif.dwc.terms.DcTerm;
import org.gbif.dwc.terms.DwcTerm;
import org.gbif.dwc.terms.Term;
import org.gbif.dwc.text.ArchiveFile;
import org.gbif.dwc.text.MetadataException;
import org.gbif.file.CSVReader;
import org.gbif.registry.metadata.parse.DatasetParser;
import org.gbif.utils.file.ClosableIterator;
import org.gbif.utils.file.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Archive
implements Iterable<StarRecord> {
    private static final Logger LOG = LoggerFactory.getLogger(Archive.class);
    private String metadataLocation;
    private Dataset metadata;
    private File location;
    private ArchiveFile core;
    private Set<ArchiveFile> extensions = new HashSet<ArchiveFile>();
    private boolean sorted = false;

    public void addExtension(ArchiveFile extension) {
        extension.setArchive(this);
        this.extensions.add(extension);
    }

    public ArchiveFile getCore() {
        return this.core;
    }

    public ArchiveFile getExtension(Term rowType) {
        for (ArchiveFile af : this.extensions) {
            if (af.getRowType() == null || !af.getRowType().equals(rowType)) continue;
            return af;
        }
        return null;
    }

    public Set<ArchiveFile> getExtensions() {
        return this.extensions;
    }

    public File getLocation() {
        return this.location;
    }

    public Dataset getMetadata() throws MetadataException {
        if (this.metadata == null) {
            File mf = this.getMetadataLocationFile();
            try {
                InputStream stream;
                if (mf.exists()) {
                    stream = FileUtils.getInputStream((File)mf);
                } else {
                    URL url = new URL(this.metadataLocation);
                    stream = url.openStream();
                }
                this.metadata = DatasetParser.build((InputStream)stream);
            }
            catch (IOException e) {
                throw new MetadataException(e);
            }
            catch (RuntimeException e) {
                throw new MetadataException(e);
            }
        }
        return this.metadata;
    }

    public String getMetadataLocation() {
        return this.metadataLocation;
    }

    public File getMetadataLocationFile() {
        if (this.metadataLocation != null) {
            return new File(this.location, this.metadataLocation);
        }
        return null;
    }

    public Map<String, File> getConstituentMetadata() {
        File[] files;
        HashMap constituents = Maps.newHashMap();
        File constDir = new File(this.location, "dataset");
        if (constDir.exists() && (files = constDir.listFiles(new FilenameFilter(){

            public boolean accept(File dir, String filename) {
                return filename.endsWith(".xml");
            }
        })) != null) {
            for (File cf : files) {
                String name = cf.getName().split("\\.")[0];
                constituents.put(name, cf);
            }
        }
        return constituents;
    }

    @Override
    public ClosableIterator<StarRecord> iterator() {
        return new ArchiveIterator(this, true, true);
    }

    public ClosableIterator<StarRecord> iteratorRaw() {
        return new ArchiveIterator(this, false, false);
    }

    public ClosableIterator<DarwinCoreRecord> iteratorDwc() {
        return new ArchiveDwcIterator(this);
    }

    public void setCore(ArchiveFile core) {
        core.setArchive(this);
        this.core = core;
    }

    public void setExtensions(Set<ArchiveFile> extensions) {
        this.extensions = extensions;
    }

    public void setLocation(File location) {
        this.location = location;
    }

    public void setMetadataLocation(String metadataLocation) {
        this.metadataLocation = metadataLocation;
    }

    private void sortFiles() throws IOException {
        FileUtils futil = new FileUtils();
        try {
            futil.sort(this.core.getLocationFile(), ArchiveFile.getLocationFileSorted(this.core.getLocationFile()), this.core.getEncoding(), this.core.getId().getIndex().intValue(), this.core.getFieldsTerminatedBy(), this.core.getFieldsEnclosedBy(), this.core.getLinesTerminatedBy(), this.core.getIgnoreHeaderLines().intValue());
        }
        catch (IOException e) {
            LOG.error("Error sorting core file " + this.core.getLocationFile() + " : " + e.getMessage());
            throw e;
        }
        catch (RuntimeException e) {
            LOG.error("Error sorting core file " + this.core.getLocationFile() + " : " + e.getMessage());
            throw e;
        }
        for (ArchiveFile ext : this.extensions) {
            try {
                futil.sort(ext.getLocationFile(), ArchiveFile.getLocationFileSorted(ext.getLocationFile()), ext.getEncoding(), ext.getId().getIndex().intValue(), ext.getFieldsTerminatedBy(), ext.getFieldsEnclosedBy(), ext.getLinesTerminatedBy(), ext.getIgnoreHeaderLines().intValue());
            }
            catch (IOException e) {
                LOG.error("Error sorting extension file " + ext.getLocationFile() + " : " + e.getMessage());
                throw e;
            }
            catch (RuntimeException e) {
                LOG.error("Error sorting extension file " + ext.getLocationFile() + " : " + e.getMessage());
                throw e;
            }
        }
        this.sorted = true;
    }

    public String toString() {
        String result = "";
        result = result + (this.location == null ? "no archive file" : this.location.getAbsoluteFile());
        return result;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ArchiveIterator
    implements ClosableIterator<StarRecord> {
        private final StarRecordImpl rec;
        private RecordIterator coreIter;
        private Set<RecordIterator> closables = new HashSet<RecordIterator>();
        private Map<Term, PeekingIterator<Record>> extensionIters = new HashMap<Term, PeekingIterator<Record>>();
        private Map<Term, Integer> extensionRecordsSkipped = new HashMap<Term, Integer>();

        ArchiveIterator(Archive archive2, boolean replaceNulls, boolean replaceEntities) {
            ArrayList<Term> rowTypes = new ArrayList<Term>();
            try {
                if (Archive.this.extensions.isEmpty()) {
                    this.coreIter = RecordIterator.build(archive2.getCore(), replaceNulls, replaceEntities);
                } else {
                    if (!archive2.sorted) {
                        archive2.sortFiles();
                    }
                    this.coreIter = this.buildSortedIterator(archive2.getCore(), replaceNulls, replaceEntities);
                }
            }
            catch (IOException e) {
                LOG.warn("IOException opening core file", (Throwable)e);
            }
            for (ArchiveFile af : archive2.getExtensions()) {
                rowTypes.add(af.getRowType());
                RecordIterator iter = Archive.this.extensions.isEmpty() ? RecordIterator.build(af, replaceNulls, replaceEntities) : this.buildSortedIterator(af, replaceNulls, replaceNulls);
                this.closables.add(iter);
                this.extensionIters.put(af.getRowType(), (PeekingIterator<Record>)Iterators.peekingIterator((Iterator)((Object)iter)));
                this.extensionRecordsSkipped.put(af.getRowType(), 0);
            }
            this.rec = new StarRecordImpl(rowTypes);
        }

        private RecordIterator buildSortedIterator(ArchiveFile af, boolean replaceNulls, boolean replaceEntities) {
            String original = af.getLocation();
            af.getLocations().clear();
            af.addLocation(ArchiveFile.getLocationSorted(original));
            RecordIterator iter = RecordIterator.build(af, replaceNulls, replaceEntities);
            af.getLocations().clear();
            af.addLocation(original);
            return iter;
        }

        public void close() {
            this.coreIter.close();
            for (ClosableIterator closableIterator : this.closables) {
                closableIterator.close();
            }
            for (Map.Entry entry : this.extensionRecordsSkipped.entrySet()) {
                Integer skipped = (Integer)entry.getValue();
                if (skipped <= 0) continue;
                LOG.debug("{} {} extension records without matching core", (Object)skipped, entry.getKey());
            }
        }

        public boolean hasNext() {
            return this.coreIter.hasNext();
        }

        public StarRecord next() {
            Record core = this.coreIter.next();
            this.rec.newCoreRecord(core);
            if (core.id() != null) {
                String id = core.id();
                block0: for (Map.Entry<Term, PeekingIterator<Record>> ext : this.extensionIters.entrySet()) {
                    PeekingIterator<Record> it = ext.getValue();
                    Term rowType = ext.getKey();
                    while (it.hasNext()) {
                        String extId = ((Record)it.peek()).id();
                        if (Strings.isNullOrEmpty((String)extId)) {
                            it.next();
                            continue;
                        }
                        if (id.equals(extId)) {
                            this.rec.addRecord(rowType, (Record)it.next());
                            continue;
                        }
                        if (id.compareTo(extId) <= 0) continue block0;
                        it.next();
                        this.extensionRecordsSkipped.put(rowType, this.extensionRecordsSkipped.get(rowType) + 1);
                    }
                }
            }
            return this.rec;
        }

        public void remove() {
            throw new UnsupportedOperationException("Cannot remove a row from archive files");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ArchiveDwcIterator
    implements ClosableIterator<DarwinCoreRecord> {
        private CSVReader coreReader;
        private ArchiveFile core;
        private int lineCount = 0;
        private final RecordImpl record;
        private boolean hasNext = true;
        private final Set<Term> mappedTerms = new HashSet<Term>();

        ArchiveDwcIterator(Archive archive) {
            this.record = new RecordImpl(archive.getCore(), true, true);
            this.core = archive.getCore();
            for (DwcTerm dwcTerm : DwcTerm.values()) {
                if (!this.core.hasTerm(dwcTerm)) continue;
                this.mappedTerms.add(dwcTerm);
            }
            for (Enum enum_ : DcTerm.values()) {
                if (!this.core.hasTerm((Term)((Object)enum_))) continue;
                this.mappedTerms.add((Term)((Object)enum_));
            }
            try {
                this.coreReader = archive.getCore().getCSVReader();
                this.record.setRow(this.coreReader.next());
                if (!this.record.hasRow()) {
                    this.hasNext = false;
                }
            }
            catch (Exception e) {
                this.hasNext = false;
                LOG.warn("Exception caught", (Throwable)e);
            }
        }

        public void close() {
            this.coreReader.close();
        }

        public boolean hasNext() {
            return this.hasNext;
        }

        public DarwinCoreRecord next() {
            DarwinCoreRecord dwc = new DarwinCoreRecord();
            ++this.lineCount;
            try {
                for (Term term : this.mappedTerms) {
                    dwc.setProperty(term, this.record.value(term));
                }
                dwc.setId(this.record.id());
                this.record.setRow(this.coreReader.next());
                if (!this.record.hasRow()) {
                    this.hasNext = false;
                }
            }
            catch (Exception e) {
                LOG.warn("Bad row somewhere around core line: {}", (Object)this.lineCount, (Object)e);
            }
            return dwc;
        }

        public void remove() {
            throw new UnsupportedOperationException("Cannot remove a row from archive files");
        }
    }
}

