/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.store.hdfs;

import java.io.Closeable;
import java.io.IOException;
import java.net.URI;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.lucene.store.Lock;
import org.apache.lucene.store.LockFactory;
import org.apache.lucene.store.LockReleaseFailedException;
import org.apache.solr.util.IOUtils;

public class HdfsLockFactory
extends LockFactory {
    private Path lockPath;
    private Configuration configuration;

    public HdfsLockFactory(Path lockPath, Configuration configuration) {
        this.lockPath = lockPath;
        this.configuration = configuration;
    }

    public Lock makeLock(String lockName) {
        if (this.lockPrefix != null) {
            lockName = this.lockPrefix + "-" + lockName;
        }
        HdfsLock lock = new HdfsLock(this.lockPath, lockName, this.configuration);
        return lock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearLock(String lockName) throws IOException {
        FileSystem fs = null;
        try {
            fs = FileSystem.newInstance((URI)this.lockPath.toUri(), (Configuration)this.configuration);
            if (fs.exists(this.lockPath)) {
                Path lockFile;
                if (this.lockPrefix != null) {
                    lockName = this.lockPrefix + "-" + lockName;
                }
                if (fs.exists(lockFile = new Path(this.lockPath, lockName)) && !fs.delete(lockFile, false)) {
                    throw new IOException("Cannot delete " + lockFile);
                }
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(fs);
            throw throwable;
        }
        IOUtils.closeQuietly((Closeable)fs);
    }

    public Path getLockPath() {
        return this.lockPath;
    }

    public void setLockPath(Path lockPath) {
        this.lockPath = lockPath;
    }

    static class HdfsLock
    extends Lock {
        private Path lockPath;
        private String lockName;
        private Configuration conf;

        public HdfsLock(Path lockPath, String lockName, Configuration conf) {
            this.lockPath = lockPath;
            this.lockName = lockName;
            this.conf = conf;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean obtain() throws IOException {
            FSDataOutputStream file = null;
            FileSystem fs = null;
            try {
                fs = FileSystem.newInstance((URI)this.lockPath.toUri(), (Configuration)this.conf);
                file = fs.create(new Path(this.lockPath, this.lockName), false);
            }
            catch (IOException e) {
                boolean bl;
                try {
                    bl = false;
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(file);
                    IOUtils.closeQuietly(fs);
                    throw throwable;
                }
                IOUtils.closeQuietly(file);
                IOUtils.closeQuietly((Closeable)fs);
                return bl;
            }
            IOUtils.closeQuietly((Closeable)file);
            IOUtils.closeQuietly((Closeable)fs);
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void release() throws IOException {
            FileSystem fs = FileSystem.newInstance((URI)this.lockPath.toUri(), (Configuration)this.conf);
            try {
                if (fs.exists(new Path(this.lockPath, this.lockName)) && !fs.delete(new Path(this.lockPath, this.lockName), false)) {
                    throw new LockReleaseFailedException("failed to delete " + new Path(this.lockPath, this.lockName));
                }
            }
            finally {
                IOUtils.closeQuietly((Closeable)fs);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isLocked() throws IOException {
            boolean isLocked = false;
            FileSystem fs = FileSystem.newInstance((URI)this.lockPath.toUri(), (Configuration)this.conf);
            try {
                isLocked = fs.exists(new Path(this.lockPath, this.lockName));
            }
            finally {
                IOUtils.closeQuietly((Closeable)fs);
            }
            return isLocked;
        }
    }
}

