/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.highlight;

import org.apache.lucene.search.vectorhighlight.BoundaryScanner;
import org.apache.lucene.search.vectorhighlight.FragmentsBuilder;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.core.SolrInfoMBean;
import org.apache.solr.highlight.HighlightingPluginBase;
import org.apache.solr.util.plugin.NamedListInitializedPlugin;

public abstract class SolrFragmentsBuilder
extends HighlightingPluginBase
implements SolrInfoMBean,
NamedListInitializedPlugin {
    public static final String DEFAULT_PRE_TAGS = "<em>";
    public static final String DEFAULT_POST_TAGS = "</em>";

    public FragmentsBuilder getFragmentsBuilder(SolrParams params, BoundaryScanner bs) {
        ++this.numRequests;
        params = SolrParams.wrapDefaults((SolrParams)params, (SolrParams)this.defaults);
        return this.getFragmentsBuilder(params, this.getPreTags(params, null), this.getPostTags(params, null), bs);
    }

    public String[] getPreTags(SolrParams params, String fieldName) {
        return this.getTags(params, "hl.tag.pre", fieldName, DEFAULT_PRE_TAGS);
    }

    public String[] getPostTags(SolrParams params, String fieldName) {
        return this.getTags(params, "hl.tag.post", fieldName, DEFAULT_POST_TAGS);
    }

    private String[] getTags(SolrParams params, String paramName, String fieldName, String def) {
        params = SolrParams.wrapDefaults((SolrParams)params, (SolrParams)this.defaults);
        String value = null;
        value = fieldName == null ? params.get(paramName, def) : params.getFieldParam(fieldName, paramName, def);
        String[] tags = value.split(",");
        for (int i = 0; i < tags.length; ++i) {
            tags[i] = tags[i].trim();
        }
        return tags;
    }

    protected abstract FragmentsBuilder getFragmentsBuilder(SolrParams var1, String[] var2, String[] var3, BoundaryScanner var4);

    protected char getMultiValuedSeparatorChar(SolrParams params) {
        String separator = params.get("hl.multiValuedSeparatorChar", " ");
        if (separator.length() > 1) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "hl.multiValuedSeparatorChar parameter must be a char, but is \"" + separator + "\"");
        }
        return separator.charAt(0);
    }
}

