/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.core;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import javax.xml.xpath.XPathExpressionException;
import org.apache.commons.lang.StringUtils;
import org.apache.solr.cloud.CloudDescriptor;
import org.apache.solr.common.SolrException;
import org.apache.solr.core.Config;
import org.apache.solr.core.ConfigSolr;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.core.CoreDescriptor;
import org.apache.solr.core.SolrCore;
import org.apache.solr.core.SolrResourceLoader;
import org.apache.solr.core.SolrXMLSerializer;
import org.apache.solr.util.DOMUtil;
import org.slf4j.Logger;
import org.w3c.dom.Node;

class SolrCores {
    private static SolrXMLSerializer SOLR_XML_SERIALIZER = new SolrXMLSerializer();
    private static Object modifyLock = new Object();
    private final Map<String, SolrCore> cores = new LinkedHashMap<String, SolrCore>();
    private Map<String, SolrCore> transientCores = new LinkedHashMap<String, SolrCore>();
    private final Map<String, CoreDescriptor> dynamicDescriptors = new LinkedHashMap<String, CoreDescriptor>();
    private final Map<String, SolrCore> createdCores = new LinkedHashMap<String, SolrCore>();
    private Map<SolrCore, String> coreToOrigName = new ConcurrentHashMap<SolrCore, String>();
    private final CoreContainer container;
    private static final Set<String> pendingCoreOps = new HashSet<String>();
    private static final List<SolrCore> pendingCloses = new ArrayList<SolrCore>();

    SolrCores(CoreContainer container) {
        this.container = container;
    }

    protected void allocateLazyCores(ConfigSolr cfg, SolrResourceLoader loader) {
        final int transientCacheSize = cfg.getInt(ConfigSolr.CfgProp.SOLR_TRANSIENTCACHESIZE, Integer.MAX_VALUE);
        if (transientCacheSize != Integer.MAX_VALUE) {
            CoreContainer.log.info("Allocating transient cache for {} transient cores", (Object)transientCacheSize);
            this.transientCores = new LinkedHashMap<String, SolrCore>(transientCacheSize, 0.75f, true){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                protected boolean removeEldestEntry(Map.Entry<String, SolrCore> eldest) {
                    if (this.size() > transientCacheSize) {
                        Object object = modifyLock;
                        synchronized (object) {
                            pendingCloses.add(eldest.getValue());
                            modifyLock.notifyAll();
                        }
                        return true;
                    }
                    return false;
                }
            };
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void putDynamicDescriptor(String rawName, CoreDescriptor p) {
        Object object = modifyLock;
        synchronized (object) {
            this.dynamicDescriptors.put(rawName, p);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void close() {
        ArrayList<SolrCore> coreList = new ArrayList<SolrCore>();
        do {
            coreList.clear();
            Object object = modifyLock;
            synchronized (object) {
                coreList.addAll(this.cores.values());
                this.cores.clear();
                coreList.addAll(this.transientCores.values());
                this.transientCores.clear();
                coreList.addAll(pendingCloses);
                pendingCloses.clear();
            }
            for (SolrCore core : coreList) {
                try {
                    core.close();
                }
                catch (Throwable t) {
                    SolrException.log((Logger)CoreContainer.log, (String)"Error shutting down core", (Throwable)t);
                }
            }
        } while (coreList.size() > 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SolrCore putTransientCore(ConfigSolr cfg, String name, SolrCore core, SolrResourceLoader loader) {
        SolrCore retCore;
        CoreContainer.log.info("Opening transient core {}", (Object)name);
        Object object = modifyLock;
        synchronized (object) {
            retCore = this.transientCores.put(name, core);
        }
        return retCore;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SolrCore putCore(String name, SolrCore core) {
        Object object = modifyLock;
        synchronized (object) {
            return this.cores.put(name, core);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<SolrCore> getCores() {
        ArrayList<SolrCore> lst = new ArrayList<SolrCore>();
        Object object = modifyLock;
        synchronized (object) {
            lst.addAll(this.cores.values());
            return lst;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Set<String> getCoreNames() {
        TreeSet<String> set = new TreeSet<String>();
        Object object = modifyLock;
        synchronized (object) {
            set.addAll(this.cores.keySet());
            set.addAll(this.transientCores.keySet());
        }
        return set;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<String> getCoreNames(SolrCore core) {
        ArrayList<String> lst = new ArrayList<String>();
        Object object = modifyLock;
        synchronized (object) {
            for (Map.Entry<String, SolrCore> entry : this.cores.entrySet()) {
                if (core != entry.getValue()) continue;
                lst.add(entry.getKey());
            }
            for (Map.Entry<String, SolrCore> entry : this.transientCores.entrySet()) {
                if (core != entry.getValue()) continue;
                lst.add(entry.getKey());
            }
        }
        return lst;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<String> getAllCoreNames() {
        TreeSet<String> set = new TreeSet<String>();
        Object object = modifyLock;
        synchronized (object) {
            set.addAll(this.cores.keySet());
            set.addAll(this.transientCores.keySet());
            set.addAll(this.dynamicDescriptors.keySet());
            set.addAll(this.createdCores.keySet());
        }
        return set;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    SolrCore getCore(String name) {
        Object object = modifyLock;
        synchronized (object) {
            return this.cores.get(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void swap(String n0, String n1) {
        Object object = modifyLock;
        synchronized (object) {
            SolrCore c0 = this.cores.get(n0);
            SolrCore c1 = this.cores.get(n1);
            if (c0 == null && (c0 = this.container.getCore(n0)) == null) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "No such core: " + n0);
            }
            if (c1 == null && (c1 = this.container.getCore(n1)) == null) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "No such core: " + n1);
            }
            this.cores.put(n0, c1);
            this.cores.put(n1, c0);
            c0.setName(n1);
            c0.getCoreDescriptor().putProperty("name", n1);
            c1.setName(n0);
            c1.getCoreDescriptor().putProperty("name", n0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SolrCore remove(String name, boolean removeOrig) {
        Object object = modifyLock;
        synchronized (object) {
            SolrCore tmp = this.cores.remove(name);
            SolrCore ret = null;
            if (removeOrig && tmp != null) {
                this.coreToOrigName.remove(tmp);
            }
            ret = ret == null ? tmp : ret;
            tmp = this.transientCores.remove(name);
            ret = ret == null ? tmp : ret;
            tmp = this.createdCores.remove(name);
            ret = ret == null ? tmp : ret;
            this.dynamicDescriptors.remove(name);
            return ret;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void putCoreToOrigName(SolrCore c, String name) {
        Object object = modifyLock;
        synchronized (object) {
            this.coreToOrigName.put(c, name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeCoreToOrigName(SolrCore newCore, SolrCore core) {
        Object object = modifyLock;
        synchronized (object) {
            String origName = this.coreToOrigName.remove(core);
            if (origName != null) {
                this.coreToOrigName.put(newCore, origName);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SolrCore getCoreFromAnyList(String name, boolean incRefCount) {
        Object object = modifyLock;
        synchronized (object) {
            SolrCore core = this.cores.get(name);
            if (core == null) {
                core = this.transientCores.get(name);
            }
            if (core != null && incRefCount) {
                core.open();
            }
            return core;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected CoreDescriptor getDynamicDescriptor(String name) {
        Object object = modifyLock;
        synchronized (object) {
            return this.dynamicDescriptors.get(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isLoaded(String name) {
        Object object = modifyLock;
        synchronized (object) {
            if (this.cores.containsKey(name)) {
                return true;
            }
            if (this.transientCores.containsKey(name)) {
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected CoreDescriptor getUnloadedCoreDescriptor(String cname) {
        Object object = modifyLock;
        synchronized (object) {
            CoreDescriptor desc = this.dynamicDescriptors.get(cname);
            if (desc == null) {
                return null;
            }
            return new CoreDescriptor(desc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getCoreToOrigName(SolrCore solrCore) {
        Object object = modifyLock;
        synchronized (object) {
            return this.coreToOrigName.get(solrCore);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void persistCores(Config cfg, Properties containerProperties, Map<String, String> rootSolrAttribs, Map<String, String> coresAttribs, Map<String, String> loggingAttribs, Map<String, String> watcherAttribs, Node shardHandlerNode, File file, SolrResourceLoader loader) throws XPathExpressionException {
        ArrayList<SolrXMLSerializer.SolrCoreXMLDef> solrCoreXMLDefs = new ArrayList<SolrXMLSerializer.SolrCoreXMLDef>();
        Object object = modifyLock;
        synchronized (object) {
            this.persistCores(cfg, this.cores, loader, solrCoreXMLDefs);
            this.persistCores(cfg, this.transientCores, loader, solrCoreXMLDefs);
            for (Map.Entry<String, CoreDescriptor> entry : this.dynamicDescriptors.entrySet()) {
                if (this.cores.containsKey(entry.getKey()) || this.transientCores.containsKey(entry.getKey())) continue;
                this.addCoreToPersistList(cfg, loader, entry.getValue(), null, solrCoreXMLDefs);
            }
            for (Map.Entry<String, Object> entry : this.createdCores.entrySet()) {
                if (this.cores.containsKey(entry.getKey()) || this.transientCores.containsKey(entry.getKey()) || this.dynamicDescriptors.containsKey(entry.getKey())) continue;
                this.addCoreToPersistList(cfg, loader, ((SolrCore)entry.getValue()).getCoreDescriptor(), null, solrCoreXMLDefs);
            }
            SolrXMLSerializer.SolrXMLDef solrXMLDef = new SolrXMLSerializer.SolrXMLDef();
            solrXMLDef.coresDefs = solrCoreXMLDefs;
            solrXMLDef.containerProperties = containerProperties;
            solrXMLDef.solrAttribs = rootSolrAttribs;
            solrXMLDef.coresAttribs = coresAttribs;
            solrXMLDef.loggingAttribs = loggingAttribs;
            solrXMLDef.watcherAttribs = watcherAttribs;
            solrXMLDef.shardHandlerNode = shardHandlerNode;
            SOLR_XML_SERIALIZER.persistFile(file, solrXMLDef);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SolrCore waitAddPendingCoreOps(String name) {
        Object object = modifyLock;
        synchronized (object) {
            boolean pending;
            do {
                if (!(pending = pendingCoreOps.contains(name))) {
                    for (SolrCore core : pendingCloses) {
                        if (!core.getName().equals(name)) continue;
                        pending = true;
                        break;
                    }
                }
                if (this.container.isShutDown()) {
                    return null;
                }
                if (!pending) continue;
                try {
                    modifyLock.wait();
                }
                catch (InterruptedException e) {
                    return null;
                }
            } while (pending);
            if (!this.container.isShutDown()) {
                if (!pendingCoreOps.add(name)) {
                    CoreContainer.log.warn("Replaced an entry in pendingCoreOps {}, we should not be doing this", (Object)name);
                }
                return this.getCoreFromAnyList(name, false);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeFromPendingOps(String name) {
        Object object = modifyLock;
        synchronized (object) {
            if (!pendingCoreOps.remove(name)) {
                CoreContainer.log.warn("Tried to remove core {} from pendingCoreOps and it wasn't there. ", (Object)name);
            }
            modifyLock.notifyAll();
        }
    }

    protected void persistCores(Config cfg, Map<String, SolrCore> whichCores, SolrResourceLoader loader, List<SolrXMLSerializer.SolrCoreXMLDef> solrCoreXMLDefs) throws XPathExpressionException {
        for (SolrCore solrCore : whichCores.values()) {
            this.addCoreToPersistList(cfg, loader, solrCore.getCoreDescriptor(), this.getCoreToOrigName(solrCore), solrCoreXMLDefs);
        }
    }

    private void addCoreProperty(Map<String, String> propMap, SolrResourceLoader loader, Node node, String name, String value) {
        this.addCoreProperty(propMap, loader, node, name, value, null);
    }

    private void addCoreProperty(Map<String, String> propMap, SolrResourceLoader loader, Node node, String name, String value, String defaultValue) {
        if (node == null) {
            propMap.put(name, value);
            return;
        }
        if (node != null) {
            String rawAttribValue = DOMUtil.getAttr(node, name, null);
            if (rawAttribValue == null) {
                return;
            }
            if (value == null) {
                propMap.put(name, rawAttribValue);
                return;
            }
            String defComp = this.regularizeAttr(defaultValue);
            if (defComp != null && this.regularizeAttr(value).equals(defComp)) {
                return;
            }
            String rawComp = this.regularizeAttr(rawAttribValue);
            if (rawComp != null && this.regularizeAttr(value).equals(this.regularizeAttr(DOMUtil.substituteProperty(rawAttribValue, loader.getCoreProperties())))) {
                propMap.put(name, rawAttribValue);
            } else {
                propMap.put(name, value);
            }
        }
    }

    protected String regularizeAttr(String path) {
        if (path == null) {
            return null;
        }
        path = path.replace('/', File.separatorChar);
        if ((path = path.replace('\\', File.separatorChar)).endsWith(File.separator)) {
            path = path.substring(0, path.length() - 1);
        }
        return path;
    }

    protected void addCoreToPersistList(Config cfg, SolrResourceLoader loader, CoreDescriptor dcore, String origCoreName, List<SolrXMLSerializer.SolrCoreXMLDef> solrCoreXMLDefs) throws XPathExpressionException {
        HashMap<String, String> coreAttribs = new HashMap<String, String>();
        Properties newProps = new Properties();
        if (dcore.getCreatedProperties().size() > 0) {
            ArrayList<String> stdNames = new ArrayList<String>(Arrays.asList(CoreDescriptor.standardPropNames));
            coreAttribs.put("name", dcore.getName());
            for (String key : dcore.getCreatedProperties().stringPropertyNames()) {
                if (!stdNames.contains(key) && !key.startsWith("property.")) continue;
                if (key.indexOf("property.") == 0) {
                    newProps.put(key.substring("property.".length()), dcore.getCreatedProperties().getProperty(key));
                    continue;
                }
                if ("name".equals(key)) continue;
                coreAttribs.put(key, dcore.getCreatedProperties().getProperty(key));
            }
            if (!dcore.getCreatedProperties().containsKey("instanceDir")) {
                coreAttribs.put("instanceDir", dcore.getRawInstanceDir());
            }
        } else {
            String coreName = dcore.getProperty("name");
            CloudDescriptor cd = dcore.getCloudDescriptor();
            String collection = null;
            if (cd != null) {
                collection = cd.getCollectionName();
            }
            if (origCoreName == null) {
                origCoreName = coreName;
            }
            Node node = null;
            if (cfg != null) {
                node = cfg.getNode("/solr/cores/core[@name='" + origCoreName + "']", false);
            }
            coreAttribs.put("name", coreName);
            this.addCoreProperty(coreAttribs, loader, node, "instanceDir", dcore.getRawInstanceDir(), null);
            this.addCoreProperty(coreAttribs, loader, node, "collection", StringUtils.isNotBlank((String)collection) ? collection : dcore.getName());
            this.addCoreProperty(coreAttribs, loader, node, "dataDir", dcore.getDataDir());
            this.addCoreProperty(coreAttribs, loader, node, "ulogDir", dcore.getUlogDir());
            this.addCoreProperty(coreAttribs, loader, node, "transient", Boolean.toString(dcore.isTransient()));
            this.addCoreProperty(coreAttribs, loader, node, "loadOnStartup", Boolean.toString(dcore.isLoadOnStartup()));
            this.addCoreProperty(coreAttribs, loader, node, "config", dcore.getConfigName());
            this.addCoreProperty(coreAttribs, loader, node, "schema", dcore.getSchemaName());
            this.addCoreProperty(coreAttribs, loader, node, "collection", collection, dcore.getName());
            String shard = null;
            String roles = null;
            String node_name = null;
            if (cd != null) {
                shard = cd.getShardId();
                roles = cd.getRoles();
                node_name = cd.getCoreNodeName();
            }
            this.addCoreProperty(coreAttribs, loader, node, "shard", shard);
            this.addCoreProperty(coreAttribs, loader, node, "roles", roles);
            this.addCoreProperty(coreAttribs, loader, node, "coreNodeName", node_name);
            for (Object key : dcore.getCoreProperties().keySet()) {
                Node propNode;
                if (cfg == null || (propNode = cfg.getNode("/solr/cores/core[@name='" + origCoreName + "']/property[@name='" + key + "']", false)) == null) continue;
                newProps.put(DOMUtil.getAttr(propNode, "name", null), DOMUtil.getAttr(propNode, "value", null));
            }
        }
        SolrXMLSerializer.SolrCoreXMLDef solrCoreXMLDef = new SolrXMLSerializer.SolrCoreXMLDef();
        solrCoreXMLDef.coreAttribs = coreAttribs;
        solrCoreXMLDef.coreProperties = newProps;
        solrCoreXMLDefs.add(solrCoreXMLDef);
    }

    protected Object getModifyLock() {
        return modifyLock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SolrCore getCoreToClose() {
        Object object = modifyLock;
        synchronized (object) {
            for (SolrCore core : pendingCloses) {
                if (pendingCoreOps.contains(core.getName())) continue;
                pendingCoreOps.add(core.getName());
                pendingCloses.remove(core);
                return core;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addCreated(SolrCore core) {
        Object object = modifyLock;
        synchronized (object) {
            this.createdCores.put(core.getName(), core);
        }
    }
}

