/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.core;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.lucene.util.IOUtils;
import org.apache.solr.common.SolrException;
import org.apache.solr.core.Config;
import org.apache.solr.core.ConfigSolr;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.core.CoreDescriptor;
import org.apache.solr.core.SolrCoreDiscoverer;
import org.apache.solr.util.PropertiesUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigSolrXml
extends ConfigSolr {
    protected static Logger log = LoggerFactory.getLogger(ConfigSolrXml.class);
    private SolrCoreDiscoverer solrCoreDiscoverer = new SolrCoreDiscoverer();
    private final Map<String, CoreDescriptor> coreDescriptorMap;

    public ConfigSolrXml(Config config, CoreContainer container) {
        super(config);
        try {
            this.checkForIllegalConfig();
            this.fillPropMap();
            config.substituteProperties();
            String coreRoot = this.get(ConfigSolr.CfgProp.SOLR_COREROOTDIRECTORY, container == null ? config.getResourceLoader().getInstanceDir() : container.getSolrHome());
            this.coreDescriptorMap = this.solrCoreDiscoverer.discover(container, new File(coreRoot));
        }
        catch (IOException e) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, (Throwable)e);
        }
    }

    private void checkForIllegalConfig() throws IOException {
        this.failIfFound("solr/@coreLoadThreads");
        this.failIfFound("solr/@persistent");
        this.failIfFound("solr/@sharedLib");
        this.failIfFound("solr/@zkHost");
        this.failIfFound("solr/logging/@class");
        this.failIfFound("solr/logging/@enabled");
        this.failIfFound("solr/logging/watcher/@size");
        this.failIfFound("solr/logging/watcher/@threshold");
        this.failIfFound("solr/cores/@adminHandler");
        this.failIfFound("solr/cores/@distribUpdateConnTimeout");
        this.failIfFound("solr/cores/@distribUpdateSoTimeout");
        this.failIfFound("solr/cores/@host");
        this.failIfFound("solr/cores/@hostContext");
        this.failIfFound("solr/cores/@hostPort");
        this.failIfFound("solr/cores/@leaderVoteWait");
        this.failIfFound("solr/cores/@genericCoreNodeNames");
        this.failIfFound("solr/cores/@managementPath");
        this.failIfFound("solr/cores/@shareSchema");
        this.failIfFound("solr/cores/@transientCacheSize");
        this.failIfFound("solr/cores/@zkClientTimeout");
        this.failIfFound("solr/cores/@defaultCoreName");
        this.failIfFound("solr/@persistent");
        this.failIfFound("solr/cores/@adminPath");
    }

    private void failIfFound(String xPath) {
        if (this.config.getVal(xPath, false) != null) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Should not have found " + xPath + " solr.xml may be a mix of old and new style formats.");
        }
    }

    private String doSub(String path) {
        String val = this.config.getVal(path, false);
        if (val != null) {
            val = PropertiesUtil.substituteProperty(val, null);
        }
        return val;
    }

    private void fillPropMap() {
        this.propMap.put(ConfigSolr.CfgProp.SOLR_ADMINHANDLER, this.doSub("solr/str[@name='adminHandler']"));
        this.propMap.put(ConfigSolr.CfgProp.SOLR_CORELOADTHREADS, this.doSub("solr/int[@name='coreLoadThreads']"));
        this.propMap.put(ConfigSolr.CfgProp.SOLR_COREROOTDIRECTORY, this.doSub("solr/str[@name='coreRootDirectory']"));
        this.propMap.put(ConfigSolr.CfgProp.SOLR_DISTRIBUPDATECONNTIMEOUT, this.doSub("solr/solrcloud/int[@name='distribUpdateConnTimeout']"));
        this.propMap.put(ConfigSolr.CfgProp.SOLR_DISTRIBUPDATESOTIMEOUT, this.doSub("solr/solrcloud/int[@name='distribUpdateSoTimeout']"));
        this.propMap.put(ConfigSolr.CfgProp.SOLR_HOST, this.doSub("solr/solrcloud/str[@name='host']"));
        this.propMap.put(ConfigSolr.CfgProp.SOLR_HOSTCONTEXT, this.doSub("solr/solrcloud/str[@name='hostContext']"));
        this.propMap.put(ConfigSolr.CfgProp.SOLR_HOSTPORT, this.doSub("solr/solrcloud/int[@name='hostPort']"));
        this.propMap.put(ConfigSolr.CfgProp.SOLR_LEADERVOTEWAIT, this.doSub("solr/solrcloud/int[@name='leaderVoteWait']"));
        this.propMap.put(ConfigSolr.CfgProp.SOLR_GENERICCORENODENAMES, this.doSub("solr/solrcloud/bool[@name='genericCoreNodeNames']"));
        this.propMap.put(ConfigSolr.CfgProp.SOLR_MANAGEMENTPATH, this.doSub("solr/str[@name='managementPath']"));
        this.propMap.put(ConfigSolr.CfgProp.SOLR_SHAREDLIB, this.doSub("solr/str[@name='sharedLib']"));
        this.propMap.put(ConfigSolr.CfgProp.SOLR_SHARESCHEMA, this.doSub("solr/str[@name='shareSchema']"));
        this.propMap.put(ConfigSolr.CfgProp.SOLR_TRANSIENTCACHESIZE, this.doSub("solr/int[@name='transientCacheSize']"));
        this.propMap.put(ConfigSolr.CfgProp.SOLR_ZKCLIENTTIMEOUT, this.doSub("solr/solrcloud/int[@name='zkClientTimeout']"));
        this.propMap.put(ConfigSolr.CfgProp.SOLR_ZKHOST, this.doSub("solr/solrcloud/str[@name='zkHost']"));
        this.propMap.put(ConfigSolr.CfgProp.SOLR_LOGGING_CLASS, this.doSub("solr/logging/str[@name='class']"));
        this.propMap.put(ConfigSolr.CfgProp.SOLR_LOGGING_ENABLED, this.doSub("solr/logging/str[@name='enabled']"));
        this.propMap.put(ConfigSolr.CfgProp.SOLR_LOGGING_WATCHER_SIZE, this.doSub("solr/logging/watcher/int[@name='size']"));
        this.propMap.put(ConfigSolr.CfgProp.SOLR_LOGGING_WATCHER_THRESHOLD, this.doSub("solr/logging/watcher/int[@name='threshold']"));
    }

    @Override
    public Map<String, String> readCoreAttributes(String coreName) {
        HashMap<String, String> attrs = new HashMap<String, String>();
        return attrs;
    }

    @Override
    public List<String> getAllCoreNames() {
        ArrayList<String> ret = new ArrayList<String>(this.coreDescriptorMap.keySet());
        return ret;
    }

    @Override
    public String getProperty(String coreName, String property, String defaultVal) {
        CoreDescriptor cd = this.coreDescriptorMap.get(coreName);
        if (cd == null) {
            return defaultVal;
        }
        return cd.getProperty(property, defaultVal);
    }

    @Override
    public Properties readCoreProperties(String coreName) {
        CoreDescriptor cd = this.coreDescriptorMap.get(coreName);
        if (cd == null) {
            return null;
        }
        return new Properties(cd.getCoreProperties());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Properties getCoreProperties(String instanceDir, CoreDescriptor dcore) {
        File corePropsFile;
        String file = dcore.getPropertiesName();
        if (file == null) {
            file = "conf" + File.separator + "solrcore.properties";
        }
        if (!(corePropsFile = new File(file)).isAbsolute()) {
            corePropsFile = new File(instanceDir, file);
        }
        Properties p = dcore.getCoreProperties();
        if (corePropsFile.exists() && corePropsFile.isFile()) {
            p = new Properties(dcore.getCoreProperties());
            FileInputStream is = null;
            try {
                is = new FileInputStream(corePropsFile);
                p.load(new InputStreamReader((InputStream)is, IOUtils.CHARSET_UTF_8));
            }
            catch (IOException e) {
                try {
                    log.warn("Error loading properties ", (Throwable)e);
                }
                catch (Throwable throwable) {
                    IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{is});
                    throw throwable;
                }
                IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{is});
            }
            IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{is});
        }
        return p;
    }

    @Override
    protected String getShardHandlerFactoryConfigPath() {
        return "solr/shardHandlerFactory";
    }

    @Override
    public void substituteProperties() {
        this.config.substituteProperties();
    }
}

