/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.core;

import com.google.common.base.Charsets;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import org.apache.commons.io.IOUtils;
import org.apache.solr.common.SolrException;
import org.apache.solr.core.Config;
import org.apache.solr.core.ConfigSolrXml;
import org.apache.solr.core.ConfigSolrXmlOld;
import org.apache.solr.core.PluginInfo;
import org.apache.solr.core.SolrResourceLoader;
import org.apache.solr.util.DOMUtil;
import org.apache.solr.util.PropertiesUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public abstract class ConfigSolr {
    protected static Logger log = LoggerFactory.getLogger(ConfigSolr.class);
    public static final String SOLR_XML_FILE = "solr.xml";
    protected Config config;
    protected Map<CfgProp, String> propMap = new HashMap<CfgProp, String>();

    public static ConfigSolr fromFile(SolrResourceLoader loader, File configFile) {
        ConfigSolr configSolr;
        log.info("Loading container configuration from {}", (Object)configFile.getAbsolutePath());
        InputStream inputStream = null;
        try {
            if (!configFile.exists()) {
                log.info("{} does not exist, using default configuration", (Object)configFile.getAbsolutePath());
                inputStream = new ByteArrayInputStream("<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\n<solr persistent=\"false\">\n  <cores adminPath=\"/admin/cores\" defaultCoreName=\"collection1\" host=\"${host:}\" hostPort=\"${hostPort:}\" hostContext=\"${hostContext:}\" zkClientTimeout=\"${zkClientTimeout:15000}\">\n    <core name=\"collection1\" shard=\"${shard:}\" collection=\"${collection:}\" instanceDir=\"collection1\" />\n  </cores>\n</solr>".getBytes(Charsets.UTF_8));
            } else {
                inputStream = new FileInputStream(configFile);
            }
            configSolr = ConfigSolr.fromInputStream(loader, inputStream);
        }
        catch (Exception e) {
            try {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Could not load SOLR configuration", (Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(inputStream);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)inputStream);
        return configSolr;
    }

    public static ConfigSolr fromString(SolrResourceLoader loader, String xml) {
        return ConfigSolr.fromInputStream(loader, new ByteArrayInputStream(xml.getBytes(Charsets.UTF_8)));
    }

    public static ConfigSolr fromInputStream(SolrResourceLoader loader, InputStream is) {
        try {
            Config config = new Config(loader, null, new InputSource(is), null, false);
            return ConfigSolr.fromConfig(config);
        }
        catch (Exception e) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, (Throwable)e);
        }
    }

    public static ConfigSolr fromSolrHome(SolrResourceLoader loader, String solrHome) {
        return ConfigSolr.fromFile(loader, new File(solrHome, SOLR_XML_FILE));
    }

    public static ConfigSolr fromConfig(Config config) {
        boolean oldStyle = config.getNode("solr/cores", false) != null;
        return oldStyle ? new ConfigSolrXmlOld(config) : new ConfigSolrXml(config, null);
    }

    public PluginInfo getShardHandlerFactoryPluginInfo() {
        Node node = this.config.getNode(this.getShardHandlerFactoryConfigPath(), false);
        return node == null ? null : new PluginInfo(node, "shardHandlerFactory", false, true);
    }

    public Node getUnsubsititutedShardHandlerFactoryPluginNode() {
        return this.config.getUnsubstitutedNode(this.getShardHandlerFactoryConfigPath(), false);
    }

    protected abstract String getShardHandlerFactoryConfigPath();

    public ConfigSolr(Config config) {
        this.config = config;
    }

    protected ConfigSolr() {
    }

    public Config getConfig() {
        return this.config;
    }

    public int getInt(CfgProp prop, int def) {
        String val = this.propMap.get((Object)prop);
        if (val != null) {
            val = PropertiesUtil.substituteProperty(val, null);
        }
        return val == null ? def : Integer.parseInt(val);
    }

    public boolean getBool(CfgProp prop, boolean defValue) {
        String val = this.propMap.get((Object)prop);
        if (val != null) {
            val = PropertiesUtil.substituteProperty(val, null);
        }
        return val == null ? defValue : Boolean.parseBoolean(val);
    }

    public String get(CfgProp prop, String def) {
        String val = this.propMap.get((Object)prop);
        if (val != null) {
            val = PropertiesUtil.substituteProperty(val, null);
        }
        return val == null ? def : val;
    }

    public String getOrigProp(CfgProp prop, String def) {
        String val = this.propMap.get((Object)prop);
        return val == null ? def : val;
    }

    public Properties getSolrProperties(String path) {
        try {
            return this.readProperties(((NodeList)this.config.evaluate(path, XPathConstants.NODESET)).item(0));
        }
        catch (Throwable e) {
            SolrException.log((Logger)log, null, (Throwable)e);
            return null;
        }
    }

    protected Properties readProperties(Node node) throws XPathExpressionException {
        XPath xpath = this.config.getXPath();
        NodeList props = (NodeList)xpath.evaluate("property", node, XPathConstants.NODESET);
        Properties properties = new Properties();
        for (int i = 0; i < props.getLength(); ++i) {
            Node prop = props.item(i);
            properties.setProperty(DOMUtil.getAttr(prop, "name"), PropertiesUtil.substituteProperty(DOMUtil.getAttr(prop, "value"), null));
        }
        return properties;
    }

    public abstract void substituteProperties();

    public abstract List<String> getAllCoreNames();

    public abstract String getProperty(String var1, String var2, String var3);

    public abstract Properties readCoreProperties(String var1);

    public abstract Map<String, String> readCoreAttributes(String var1);

    public static enum CfgProp {
        SOLR_ADMINHANDLER,
        SOLR_CORELOADTHREADS,
        SOLR_COREROOTDIRECTORY,
        SOLR_DISTRIBUPDATECONNTIMEOUT,
        SOLR_DISTRIBUPDATESOTIMEOUT,
        SOLR_HOST,
        SOLR_HOSTCONTEXT,
        SOLR_HOSTPORT,
        SOLR_LEADERVOTEWAIT,
        SOLR_LOGGING_CLASS,
        SOLR_LOGGING_ENABLED,
        SOLR_LOGGING_WATCHER_SIZE,
        SOLR_LOGGING_WATCHER_THRESHOLD,
        SOLR_MANAGEMENTPATH,
        SOLR_SHAREDLIB,
        SOLR_SHARESCHEMA,
        SOLR_TRANSIENTCACHESIZE,
        SOLR_GENERICCORENODENAMES,
        SOLR_ZKCLIENTTIMEOUT,
        SOLR_ZKHOST,
        SOLR_PERSISTENT,
        SOLR_CORES_DEFAULT_CORE_NAME,
        SOLR_ADMINPATH;

    }
}

