/*
 * Decompiled with CFR 0.152.
 */
package org.rev6.scf;

import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import java.io.File;
import java.util.Properties;
import java.util.logging.Logger;
import org.rev6.scf.SshException;
import org.rev6.scf.SshTask;

public class SshConnection {
    private static final Properties SSH_PROPERTIES = new Properties();
    protected final Logger logger = Logger.getLogger(this.getClass().getPackage().getName());
    String host;
    int port = 22;
    String username;
    String password;
    File privateKeyFile;
    boolean usePrivateKey = false;
    Session sshSession;

    public SshConnection() {
    }

    public SshConnection(String host, String username) {
        this.setHost(host);
        this.setUsername(username);
    }

    public SshConnection(String host, String username, File privateKeyFile) {
        this.setHost(host);
        this.setUsername(username);
        this.setPrivateKeyFile(privateKeyFile);
        this.setUsePrivateKey(true);
    }

    public SshConnection(String host, String username, String password) {
        this.setHost(host);
        this.setUsername(username);
        this.setPassword(password);
    }

    public void disconnect() {
        if (this.sshSession != null) {
            this.sshSession.disconnect();
        }
    }

    public void connect() throws SshException {
        this.exceptIfAlreadyConnected();
        try {
            JSch jsch = new JSch();
            this.validateMembers();
            if (this.usePrivateKey) {
                jsch.addIdentity(this.privateKeyFile.getAbsolutePath());
            }
            this.sshSession = jsch.getSession(this.username, this.host, this.port);
            this.sshSession.setConfig(SSH_PROPERTIES);
            if (!this.usePrivateKey && this.password != null) {
                this.sshSession.setPassword(this.password);
            }
            this.sshSession.connect();
        }
        catch (JSchException e) {
            throw new SshException(e);
        }
    }

    private void exceptIfAlreadyConnected() {
        if (this.sshSession != null && this.sshSession.isConnected()) {
            throw new IllegalStateException("connect() failed.  Connection already established to " + this.username + "@" + this.host + ":" + Integer.toString(this.port));
        }
    }

    public void executeTask(SshTask sshTask) throws SshException {
        long startTime = System.currentTimeMillis();
        this.logger.info("Beginning SshTask of " + sshTask.toString());
        sshTask.execute(this.sshSession);
        long totalTime = (System.currentTimeMillis() - startTime) / 1000L;
        this.logger.info("Completed SshTask of " + sshTask.toString() + " in " + totalTime + " seconds.");
    }

    protected void finalize() {
        this.disconnect();
    }

    public void setHost(String host) {
        this.exceptIfAlreadyConnected();
        this.host = host;
    }

    public void setPassword(String password) {
        this.exceptIfAlreadyConnected();
        this.password = password;
    }

    public void setPort(int port) {
        this.exceptIfAlreadyConnected();
        this.port = port;
    }

    public void setPrivateKeyFile(File privateKeyFile) {
        this.exceptIfAlreadyConnected();
        this.privateKeyFile = privateKeyFile;
    }

    public void setPrivateKeyFile(String privateKeyFileName) {
        this.exceptIfAlreadyConnected();
        this.setPrivateKeyFile(new File(privateKeyFileName));
    }

    public void setUsePrivateKey(boolean usePrivateKey) {
        this.exceptIfAlreadyConnected();
        this.usePrivateKey = usePrivateKey;
    }

    public void setUsername(String username) {
        this.exceptIfAlreadyConnected();
        this.username = username;
    }

    private void validateMembers() throws SshException {
        if (this.host == null) {
            throw new SshException("host not set.  setHost must be called before calling sendFile");
        }
        if (this.username == null) {
            throw new SshException("username not set. setUsername must be called before calling sendFile");
        }
        if (this.usePrivateKey) {
            if (this.privateKeyFile == null || !this.privateKeyFile.canRead()) {
                throw new SshException("if usePrivateKey is true, then a readable privateKeyFile must be specified.");
            }
        } else if (this.password == null) {
            throw new SshException("password not set.  setPassword must be called before calling sendFile");
        }
    }

    static {
        SSH_PROPERTIES.put("StrictHostKeyChecking", "No");
    }
}

