/*
 * Decompiled with CFR 0.152.
 */
package org.rev6.scf;

import com.jcraft.jsch.ChannelExec;
import com.jcraft.jsch.Session;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.rev6.scf.SshException;
import org.rev6.scf.SshTask;

public class SshCommand
extends SshTask {
    static String SSH_EXEC_COMMAND = "EXEC";
    protected final Logger logger = Logger.getLogger(this.getClass().getPackage().getName());
    String command;
    OutputStream out;

    public SshCommand(String command, OutputStream out) {
        this.setCommand(command);
        this.setOutputStream(out);
    }

    public SshCommand(String command) {
        this(command, System.out);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void execute(Session sshSession) throws SshException {
        InputStream in = null;
        ChannelExec channel = null;
        if (this.command == null) {
            throw new IllegalStateException("command attribute of " + this.getClass().getName() + " can't be null.");
        }
        try {
            try {
                channel = this.setUpChannel(sshSession, this.command);
                in = channel.getInputStream();
                channel.connect();
                this.streamOutput(channel, in);
            }
            finally {
                if (in != null) {
                    in.close();
                }
                if (channel != null) {
                    channel.disconnect();
                }
            }
        }
        catch (Exception e) {
            throw new SshException(e);
        }
    }

    private void streamOutput(ChannelExec channel, InputStream in) throws IOException {
        byte[] buf = new byte[1024];
        while (true) {
            int bytesRead;
            if (in.available() > 1 && (bytesRead = in.read(buf)) >= 0) {
                this.out.write(buf);
                continue;
            }
            if (channel.isClosed()) break;
            this.sleepForOneSecondAndIgnoreInterrupt();
        }
    }

    private void sleepForOneSecondAndIgnoreInterrupt() {
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException e) {
            this.logger.log(Level.FINE, "Interrupt caught and ignored: ", e);
        }
    }

    public void setCommand(String command) {
        if (command == null) {
            throw new IllegalArgumentException("command can't be null");
        }
        this.command = command;
    }

    public void setOutputStream(OutputStream out) {
        if (out == null) {
            throw new IllegalArgumentException("out can't be null");
        }
        this.out = out;
    }

    public String toString() {
        if (this.command != null) {
            return this.getClass().getName() + " Task: " + this.command;
        }
        return this.getClass().getName() + "Task: command property is null.";
    }
}

