/*
 * Decompiled with CFR 0.152.
 */
package com.jayway.jsonpath.internal.filter.eval;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class ExpressionEvaluator {
    private static final String NULL_VALUE = "null";
    private static Map<String, Operator> operatorsByRepresentation;

    public static <T> boolean eval(T actual, String comparator, String expected) {
        Operator operator = operatorsByRepresentation.get(comparator);
        if (operator == null) {
            throw new IllegalArgumentException("Unsupported operator " + comparator);
        }
        if (actual == null) {
            if (operator == Operator.equal) {
                return NULL_VALUE.equals(expected);
            }
            if (operator == Operator.not_equal || operator == Operator.less_or_greater_than) {
                return !NULL_VALUE.equals(expected);
            }
        } else if ((operator == Operator.not_equal || operator == Operator.less_or_greater_than) && NULL_VALUE.equals(expected)) {
            return true;
        }
        if (actual instanceof Long) {
            Long a = (Long)actual;
            Long e = Long.parseLong(expected.trim());
            switch (operator) {
                case equal: {
                    return a.longValue() == e.longValue();
                }
                case not_equal: 
                case less_or_greater_than: {
                    return a.longValue() != e.longValue();
                }
                case greater_than: {
                    return a > e;
                }
                case greater_than_or_equal: {
                    return a >= e;
                }
                case less_than: {
                    return a < e;
                }
                case less_than_or_equal: {
                    return a <= e;
                }
            }
            throw new UnsupportedOperationException("Cannot handle operator " + (Object)((Object)operator));
        }
        if (actual instanceof Integer) {
            Integer a = (Integer)actual;
            Integer e = Integer.parseInt(expected.trim());
            switch (operator) {
                case equal: {
                    return a.intValue() == e.intValue();
                }
                case not_equal: 
                case less_or_greater_than: {
                    return a.intValue() != e.intValue();
                }
                case greater_than: {
                    return a > e;
                }
                case greater_than_or_equal: {
                    return a >= e;
                }
                case less_than: {
                    return a < e;
                }
                case less_than_or_equal: {
                    return a <= e;
                }
            }
            throw new UnsupportedOperationException("Cannot handle operator " + (Object)((Object)operator));
        }
        if (actual instanceof Double) {
            Double a = (Double)actual;
            Double e = Double.parseDouble(expected.trim());
            switch (operator) {
                case equal: {
                    return a.doubleValue() == e.doubleValue();
                }
                case not_equal: 
                case less_or_greater_than: {
                    return a.doubleValue() != e.doubleValue();
                }
                case greater_than: {
                    return a > e;
                }
                case greater_than_or_equal: {
                    return a >= e;
                }
                case less_than: {
                    return a < e;
                }
                case less_than_or_equal: {
                    return a <= e;
                }
            }
            throw new UnsupportedOperationException("Cannot handle operator " + (Object)((Object)operator));
        }
        if (actual instanceof String) {
            switch (operator) {
                case greater_than: 
                case greater_than_or_equal: 
                case less_than: 
                case less_than_or_equal: {
                    return false;
                }
                case equal: 
                case not_equal: 
                case less_or_greater_than: {
                    String a = (String)actual;
                    String expectedTrimmed = expected.trim();
                    if (expectedTrimmed.startsWith("'")) {
                        expectedTrimmed = expectedTrimmed.substring(1);
                    }
                    if (expectedTrimmed.endsWith("'")) {
                        expectedTrimmed = expectedTrimmed.substring(0, expected.length() - 1);
                    }
                    if (operator == Operator.equal) {
                        return a.equals(expectedTrimmed);
                    }
                    if (operator != Operator.not_equal && operator != Operator.less_or_greater_than) break;
                    return !a.equals(expectedTrimmed);
                }
            }
            throw new UnsupportedOperationException("Cannot handle operator " + (Object)((Object)operator));
        }
        if (actual instanceof Boolean) {
            switch (operator) {
                case equal: 
                case not_equal: 
                case less_or_greater_than: {
                    Boolean a = (Boolean)actual;
                    Boolean e = Boolean.valueOf(expected);
                    if (operator == Operator.equal) {
                        return a.equals(e);
                    }
                    if (operator != Operator.not_equal && operator != Operator.less_or_greater_than) break;
                    return !a.equals(e);
                }
            }
            throw new UnsupportedOperationException("Cannot handle operator " + (Object)((Object)operator));
        }
        if (actual instanceof BigInteger) {
            BigInteger a = (BigInteger)actual;
            BigInteger e = new BigInteger(expected.trim());
            switch (operator) {
                case equal: {
                    return a.compareTo(e) == 0;
                }
                case not_equal: {
                    return a.compareTo(e) != 0;
                }
                case less_or_greater_than: {
                    return a.compareTo(e) != 0;
                }
                case greater_than: {
                    return a.compareTo(e) > 0;
                }
                case greater_than_or_equal: {
                    return a.compareTo(e) >= 0;
                }
                case less_than: {
                    return a.compareTo(e) < 0;
                }
                case less_than_or_equal: {
                    return a.compareTo(e) <= 0;
                }
            }
            throw new UnsupportedOperationException("Cannot handle operator " + (Object)((Object)operator));
        }
        if (actual instanceof BigDecimal) {
            BigDecimal a = (BigDecimal)actual;
            BigDecimal e = new BigDecimal(expected);
            switch (operator) {
                case equal: {
                    return a.compareTo(e) == 0;
                }
                case not_equal: {
                    return a.compareTo(e) != 0;
                }
                case less_or_greater_than: {
                    return a.compareTo(e) != 0;
                }
                case greater_than: {
                    return a.compareTo(e) > 0;
                }
                case greater_than_or_equal: {
                    return a.compareTo(e) >= 0;
                }
                case less_than: {
                    return a.compareTo(e) < 0;
                }
                case less_than_or_equal: {
                    return a.compareTo(e) <= 0;
                }
            }
            throw new UnsupportedOperationException("Cannot handle operator " + (Object)((Object)operator));
        }
        return false;
    }

    static {
        HashMap<String, Operator> map = new HashMap<String, Operator>();
        for (Operator op : Operator.values()) {
            map.put(op.getRepresentation(), op);
        }
        operatorsByRepresentation = Collections.unmodifiableMap(map);
    }

    public static enum Operator {
        equal("=="),
        not_equal("!="),
        less_or_greater_than("<>"),
        greater_than(">"),
        greater_than_or_equal(">="),
        less_than("<"),
        less_than_or_equal("<=");

        private final String representation;

        private Operator(String representation) {
            this.representation = representation;
        }

        public String getRepresentation() {
            return this.representation;
        }
    }
}

