/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.biocache.tool;

import au.com.bytecode.opencsv.CSVReader;
import au.org.ala.biocache.Config$;
import au.org.ala.biocache.cmd.Tool;
import au.org.ala.biocache.cmd.Tool$class;
import au.org.ala.biocache.dao.OccurrenceDAO;
import au.org.ala.biocache.persistence.PersistenceManager;
import au.org.ala.biocache.util.OptionParser;
import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LongRef;
import scala.runtime.ObjectRef;

public final class CopyDataNewColumn$
implements Tool {
    public static final CopyDataNewColumn$ MODULE$;
    private final OccurrenceDAO occurrenceDAO;
    private final PersistenceManager persistenceManager;

    static {
        new CopyDataNewColumn$();
    }

    @Override
    public String help() {
        return Tool$class.help(this);
    }

    @Override
    public String cmd() {
        return "copy-column";
    }

    @Override
    public String desc() {
        return "Copy column utility";
    }

    public OccurrenceDAO occurrenceDAO() {
        return this.occurrenceDAO;
    }

    public PersistenceManager persistenceManager() {
        return this.persistenceManager;
    }

    @Override
    public void main(String[] args) {
        block4: {
            Predef$.MODULE$.println((Object)"Starting...");
            ObjectRef sourceColumnFamily = new ObjectRef((Object)"");
            ObjectRef targetColumnFamily = new ObjectRef((Object)"");
            ObjectRef start = new ObjectRef((Object)None$.MODULE$);
            BooleanRef delete = new BooleanRef(false);
            ObjectRef dr = new ObjectRef((Object)None$.MODULE$);
            ObjectRef source = new ObjectRef((Object)"");
            ObjectRef target = new ObjectRef((Object)"");
            ObjectRef rowKeyFile = new ObjectRef((Object)"");
            BooleanRef dryRun = new BooleanRef(false);
            OptionParser parser = new OptionParser(sourceColumnFamily, targetColumnFamily, start, delete, dr, source, target, rowKeyFile, dryRun){
                {
                    this.arg("sourceColumnFamily", "The columns family to copy from.", (Function1<String, BoxedUnit>)new Serializable(this, sourceColumnFamily$1){
                        public static final long serialVersionUID = 0L;
                        private final ObjectRef sourceColumnFamily$1;

                        public final void apply(String v) {
                            this.sourceColumnFamily$1.elem = v;
                        }
                        {
                            this.sourceColumnFamily$1 = sourceColumnFamily$1;
                        }
                    });
                    this.arg("sourceColumn", "The column to copy from.", (Function1<String, BoxedUnit>)new Serializable(this, source$1){
                        public static final long serialVersionUID = 0L;
                        private final ObjectRef source$1;

                        public final void apply(String v) {
                            this.source$1.elem = v;
                        }
                        {
                            this.source$1 = source$1;
                        }
                    });
                    this.arg("targetColumnFamily", "The columns family to copy from.", (Function1<String, BoxedUnit>)new Serializable(this, targetColumnFamily$1){
                        public static final long serialVersionUID = 0L;
                        private final ObjectRef targetColumnFamily$1;

                        public final void apply(String v) {
                            this.targetColumnFamily$1.elem = v;
                        }
                        {
                            this.targetColumnFamily$1 = targetColumnFamily$1;
                        }
                    });
                    this.arg("targetColumn", "The column to copy from.", (Function1<String, BoxedUnit>)new Serializable(this, target$1){
                        public static final long serialVersionUID = 0L;
                        private final ObjectRef target$1;

                        public final void apply(String v) {
                            this.target$1.elem = v;
                        }
                        {
                            this.target$1 = target$1;
                        }
                    });
                    this.opt("s", "start", "The record to start with", (Function1<String, BoxedUnit>)new Serializable(this, start$1){
                        public static final long serialVersionUID = 0L;
                        private final ObjectRef start$1;

                        public final void apply(String v) {
                            this.start$1.elem = new Some((Object)v);
                        }
                        {
                            this.start$1 = start$1;
                        }
                    });
                    this.opt("dr", "resource", "The data resource to process", (Function1<String, BoxedUnit>)new Serializable(this, dr$1){
                        public static final long serialVersionUID = 0L;
                        private final ObjectRef dr$1;

                        public final void apply(String v) {
                            this.dr$1.elem = new Some((Object)v);
                        }
                        {
                            this.dr$1 = dr$1;
                        }
                    });
                    this.opt("delete", "delete the source value", (Function0<BoxedUnit>)new Serializable(this, delete$1){
                        public static final long serialVersionUID = 0L;
                        private final BooleanRef delete$1;

                        public final void apply() {
                            this.apply$mcV$sp();
                        }

                        public void apply$mcV$sp() {
                            this.delete$1.elem = true;
                        }
                        {
                            this.delete$1 = delete$1;
                        }
                    });
                    this.opt("rkf", "rowKeyFile", "Row key file", (Function1<String, BoxedUnit>)new Serializable(this, rowKeyFile$1){
                        public static final long serialVersionUID = 0L;
                        private final ObjectRef rowKeyFile$1;

                        public final void apply(String v) {
                            this.rowKeyFile$1.elem = v;
                        }
                        {
                            this.rowKeyFile$1 = rowKeyFile$1;
                        }
                    });
                    this.opt("dry", "dryRun", "Perform dry run and just output the change that would be made", (Function0<BoxedUnit>)new Serializable(this, dryRun$1){
                        public static final long serialVersionUID = 0L;
                        private final BooleanRef dryRun$1;

                        public final void apply() {
                            this.apply$mcV$sp();
                        }

                        public void apply$mcV$sp() {
                            this.dryRun$1.elem = true;
                        }
                        {
                            this.dryRun$1 = dryRun$1;
                        }
                    });
                }
            };
            if (parser.parse((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])args))) {
                Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"Copying from ").append((Object)((String)source.elem)).append((Object)" to ").append((Object)((String)target.elem)).append((Object)" in ").append((Object)((String)sourceColumnFamily.elem)).toString());
                String startUuid = ((Option)start.elem).isDefined() ? (String)((Option)start.elem).get() : (((Option)dr.elem).isDefined() ? new StringBuilder().append((Object)((String)((Option)dr.elem).get())).append((Object)"|").toString() : "");
                String endUuid = ((Option)dr.elem).isDefined() ? new StringBuilder().append((Object)((String)((Option)dr.elem).get())).append((Object)"|~").toString() : "";
                long originalStartTime = System.currentTimeMillis();
                String string = (String)rowKeyFile.elem;
                String string2 = "";
                if (!(string != null ? !string.equals(string2) : string2 != null)) {
                    IntRef count = new IntRef(0);
                    LongRef startTime = new LongRef(System.currentTimeMillis());
                    this.persistenceManager().pageOverSelect((String)sourceColumnFamily.elem, (Function2<String, Map<String, String>, Object>)new Serializable(sourceColumnFamily, targetColumnFamily, delete, source, target, originalStartTime, count, startTime){
                        public static final long serialVersionUID = 0L;
                        private final ObjectRef sourceColumnFamily$1;
                        private final ObjectRef targetColumnFamily$1;
                        private final BooleanRef delete$1;
                        private final ObjectRef source$1;
                        private final ObjectRef target$1;
                        private final long originalStartTime$1;
                        private final IntRef count$1;
                        private final LongRef startTime$1;

                        public final boolean apply(String guid, Map<String, String> map) {
                            CopyDataNewColumn$.MODULE$.copyData(guid, map, (String)this.sourceColumnFamily$1.elem, (String)this.source$1.elem, (String)this.targetColumnFamily$1.elem, (String)this.target$1.elem, this.delete$1.elem);
                            if (this.count$1.elem % 1000 == 0) {
                                long finishTime = System.currentTimeMillis();
                                Predef$.MODULE$.println((Object)new StringBuilder().append(this.count$1.elem).append((Object)" >> Last key : ").append((Object)guid).append((Object)", records per sec: ").append((Object)BoxesRunTime.boxToFloat((float)(1000.0f / ((float)(finishTime - this.startTime$1.elem) / 1000.0f)))).append((Object)", time taken for ").append((Object)BoxesRunTime.boxToInteger((int)1000)).append((Object)" records: ").append((Object)BoxesRunTime.boxToFloat((float)((float)(finishTime - this.startTime$1.elem) / 1000.0f))).append((Object)", total time: ").append((Object)BoxesRunTime.boxToFloat((float)((float)(finishTime - this.originalStartTime$1) / 60000.0f))).append((Object)" minutes").toString());
                                this.startTime$1.elem = System.currentTimeMillis();
                            }
                            ++this.count$1.elem;
                            return true;
                        }
                        {
                            this.sourceColumnFamily$1 = sourceColumnFamily$1;
                            this.targetColumnFamily$1 = targetColumnFamily$1;
                            this.delete$1 = delete$1;
                            this.source$1 = source$1;
                            this.target$1 = target$1;
                            this.originalStartTime$1 = originalStartTime$1;
                            this.count$1 = count$1;
                            this.startTime$1 = startTime$1;
                        }
                    }, startUuid, endUuid, 1000, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"rowKey", "uuid", (String)source.elem}));
                } else {
                    Option<Map<String, String>> option;
                    CSVReader reader = new CSVReader((Reader)new FileReader(new File((String)rowKeyFile.elem)));
                    String[] line = reader.readNext();
                    while (true) {
                        if (line == null) break block4;
                        String guid = line[0];
                        option = this.persistenceManager().get(guid, (String)sourceColumnFamily.elem);
                        if (!(option instanceof Some)) break;
                        Some some = (Some)option;
                        Map map = (Map)some.x();
                        this.copyData(guid, (Map<String, String>)map, (String)sourceColumnFamily.elem, (String)source.elem, (String)targetColumnFamily.elem, (String)target.elem, delete.elem);
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        line = reader.readNext();
                    }
                    throw new MatchError(option);
                }
            }
        }
        this.persistenceManager().shutdown();
    }

    public void copyData(String guid, Map<String, String> map, String sourceColumnFamily, String source, String targetColumnFamily, String target, boolean delete) {
        Option sourceValue = map.get((Object)source);
        if (sourceValue.isDefined()) {
            this.persistenceManager().put(guid, targetColumnFamily, target, (String)sourceValue.get());
            if (delete) {
                this.persistenceManager().deleteColumns(guid, sourceColumnFamily, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{source}));
            }
        }
    }

    private CopyDataNewColumn$() {
        MODULE$ = this;
        Tool$class.$init$(this);
        this.occurrenceDAO = Config$.MODULE$.occurrenceDAO();
        this.persistenceManager = Config$.MODULE$.persistenceManager();
    }
}

