/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.biocache.load;

import au.org.ala.biocache.Config$;
import au.org.ala.biocache.caches.TaxonSpeciesListDAO$;
import au.org.ala.biocache.caches.WebServiceLoader$;
import au.org.ala.biocache.cmd.Tool;
import au.org.ala.biocache.cmd.Tool$class;
import au.org.ala.biocache.model.ConservationStatus;
import au.org.ala.biocache.util.Json$;
import java.text.MessageFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.RichInt$;
import scala.util.parsing.json.JSON$;

public final class ConservationListLoader$
implements Tool {
    public static final ConservationListLoader$ MODULE$;
    private final Logger logger;
    private final String guidUrl;
    private final ArrayBuffer<String> guidsArray;

    static {
        new ConservationListLoader$();
    }

    @Override
    public String help() {
        return Tool$class.help(this);
    }

    public Logger logger() {
        return this.logger;
    }

    @Override
    public String cmd() {
        return "update-conservation-data";
    }

    @Override
    public String desc() {
        return "Load conservation data from sources (e.g. list tool)";
    }

    public String guidUrl() {
        return this.guidUrl;
    }

    public ArrayBuffer<String> guidsArray() {
        return this.guidsArray;
    }

    /*
     * WARNING - void declaration
     */
    public Seq<Tuple2<String, String>> getListsForQuery(String listToolQuery) {
        void var3_3;
        java.util.Map<String, Object> speciesLists = Json$.MODULE$.toJavaMap(WebServiceLoader$.MODULE$.getWSStringContent(new StringBuilder().append((Object)Config$.MODULE$.listToolUrl()).append((Object)"/speciesList?").append((Object)listToolQuery).toString()));
        ListBuffer ids = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        if (speciesLists.containsKey("lists")) {
            java.util.List authLists = (java.util.List)speciesLists.get("lists");
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), authLists.size()).foreach((Function1)new Serializable(ids, authLists){
                public static final long serialVersionUID = 0L;
                private final ListBuffer ids$1;
                private final java.util.List authLists$1;

                public final Object apply(int listIdx) {
                    java.util.Map listProperties = (java.util.Map)this.authLists$1.get(listIdx);
                    return listProperties.containsKey("dataResourceUid") && listProperties.get("region") != null ? this.ids$1.$plus$eq((Object)new Tuple2((Object)listProperties.get("dataResourceUid").toString(), (Object)listProperties.get("region").toString())) : BoxedUnit.UNIT;
                }
                {
                    this.ids$1 = ids$1;
                    this.authLists$1 = authLists$1;
                }
            });
        }
        return var3_3;
    }

    @Override
    public void main(String[] args) {
        Seq<Tuple2<String, String>> listUids = this.getListsForQuery("isThreatened=eq:true");
        listUids.foreach((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Object apply(Tuple2<String, String> x0$1) {
                Tuple2<String, String> tuple2 = x0$1;
                if (tuple2 != null) {
                    BoxedUnit boxedUnit;
                    String response;
                    String listUid = (String)tuple2._1();
                    String url = MessageFormat.format(ConservationListLoader$.MODULE$.guidUrl(), listUid);
                    String string = response = WebServiceLoader$.MODULE$.getWSStringContent(url);
                    String string2 = "";
                    if (!(string != null ? !string.equals(string2) : string2 != null)) {
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        List list = (List)JSON$.MODULE$.parseFull(response).get();
                        boxedUnit = ConservationListLoader$.MODULE$.guidsArray().$plus$plus$eq((TraversableOnce)list.filter((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final boolean apply(String x$1) {
                                return x$1 != null;
                            }
                        }));
                    }
                    BoxedUnit boxedUnit2 = boxedUnit;
                    return boxedUnit2;
                }
                throw new MatchError(tuple2);
            }
        });
        Set guids = this.guidsArray().toSet();
        this.logger().info(new StringBuilder().append((Object)"The number of distinct species ").append((Object)BoxesRunTime.boxToInteger((int)guids.size())).toString());
        IntRef counter = new IntRef(0);
        guids.foreach((Function1)new Serializable(listUids, counter){
            public static final long serialVersionUID = 0L;
            private final Seq listUids$1;
            private final IntRef counter$2;

            public final Object apply(String guid) {
                Tuple2<List<String>, Map<String, String>> tuple2;
                ++this.counter$2.elem;
                if (this.counter$2.elem % 100 == 0) {
                    ConservationListLoader$.MODULE$.logger().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " species load"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.counter$2.elem)})));
                }
                if ((tuple2 = TaxonSpeciesListDAO$.MODULE$.getCachedListsForTaxon(guid)) != null) {
                    Object object;
                    Tuple2 tuple22;
                    List lists = (List)tuple2._1();
                    Map props = (Map)tuple2._2();
                    Tuple2 tuple23 = tuple22 = new Tuple2((Object)lists, (Object)props);
                    List lists2 = (List)tuple23._1();
                    Map props2 = (Map)tuple23._2();
                    ListBuffer buff = new ListBuffer();
                    this.listUids$1.foreach((Function1)new Serializable(this, guid, props2, buff){
                        public static final long serialVersionUID = 0L;
                        private final String guid$2;
                        private final Map props$1;
                        private final ListBuffer buff$1;

                        public final Object apply(Tuple2<String, String> x0$2) {
                            Tuple2<String, String> tuple2 = x0$2;
                            if (tuple2 != null) {
                                BoxedUnit boxedUnit;
                                String listUid = (String)tuple2._1();
                                String region = (String)tuple2._2();
                                Object object = this.props$1.getOrElse((Object)new StringBuilder().append((Object)listUid).append((Object)"_status").toString(), (Function0)new Serializable(this){
                                    public static final long serialVersionUID = 0L;

                                    public final String apply() {
                                        return "";
                                    }
                                });
                                String string = "";
                                if (!(object != null ? !object.equals(string) : string != null)) {
                                    boxedUnit = BoxedUnit.UNIT;
                                } else {
                                    String status = (String)this.props$1.getOrElse((Object)new StringBuilder().append((Object)listUid).append((Object)"_status").toString(), (Function0)new Serializable(this){
                                        public static final long serialVersionUID = 0L;

                                        public final String apply() {
                                            return "";
                                        }
                                    });
                                    String rawStatus = (String)this.props$1.getOrElse((Object)new StringBuilder().append((Object)listUid).append((Object)"_sourceStatus").toString(), (Function0)new Serializable(this){
                                        public static final long serialVersionUID = 0L;

                                        public final String apply() {
                                            return "";
                                        }
                                    });
                                    ConservationStatus conservationStatus = new ConservationStatus(region, "", status, rawStatus);
                                    Predef$.MODULE$.println((Object)new StringBuilder().append((Object)this.guid$2).append((Object)": ").append((Object)conservationStatus).toString());
                                    boxedUnit = this.buff$1.$plus$eq((Object)conservationStatus);
                                }
                                BoxedUnit boxedUnit2 = boxedUnit;
                                return boxedUnit2;
                            }
                            throw new MatchError(tuple2);
                        }
                        {
                            this.guid$2 = guid$2;
                            this.props$1 = props$1;
                            this.buff$1 = buff$1;
                        }
                    });
                    if (buff.isEmpty()) {
                        object = BoxedUnit.UNIT;
                    } else {
                        String csAsJson = Json$.MODULE$.toJSON((List<Object>)buff.toList());
                        object = Config$.MODULE$.persistenceManager().put(guid, "taxon", (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"conservation"), (Object)csAsJson)}))));
                    }
                    return object;
                }
                throw new MatchError(tuple2);
            }
            {
                this.listUids$1 = listUids$1;
                this.counter$2 = counter$2;
            }
        });
    }

    private ConservationListLoader$() {
        MODULE$ = this;
        Tool$class.$init$(this);
        this.logger = LoggerFactory.getLogger((String)"ConservationListLoader");
        this.guidUrl = new StringBuilder().append((Object)Config$.MODULE$.listToolUrl()).append((Object)"/speciesList/{0}/taxa").toString();
        this.guidsArray = new ArrayBuffer();
    }
}

