/*
 * Decompiled with CFR 0.152.
 */
package com.drew.imaging.tiff;

import com.drew.lang.annotations.NotNull;
import com.drew.metadata.Metadata;
import com.drew.metadata.exif.ExifReader;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class TiffMetadataReader {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static Metadata readMetadata(@NotNull File file) throws IOException {
        byte[] byArray;
        Metadata metadata = new Metadata();
        FileInputStream fileInputStream = null;
        FilterInputStream filterInputStream = null;
        try {
            fileInputStream = new FileInputStream(file);
            filterInputStream = new DataInputStream(fileInputStream);
            byArray = new byte[(int)file.length()];
            ((DataInputStream)filterInputStream).readFully(byArray);
        }
        finally {
            if (filterInputStream != null) {
                filterInputStream.close();
            }
            if (fileInputStream != null) {
                fileInputStream.close();
            }
        }
        new ExifReader().extractTiff(byArray, metadata);
        return metadata;
    }

    @NotNull
    public static Metadata readMetadata(@NotNull InputStream inputStream, boolean bl) throws IOException {
        int n;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        while ((n = inputStream.read()) != -1) {
            byteArrayOutputStream.write(n);
        }
        Metadata metadata = new Metadata();
        new ExifReader().extractTiff(byteArrayOutputStream.toByteArray(), metadata);
        return metadata;
    }
}

