/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.sds.validation;

import au.org.ala.sds.model.Message;
import au.org.ala.sds.model.SdsMessage;
import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class MessageFactory {
    public static final String LOCATION_GENERALISED = "LocGen";
    public static final String LOCATION_NOT_GENERALISED = "LocNotGen";
    public static final String LOCATION_ALREADY_GENERALISED = "LocAlreadyGen";
    public static final String LOCATION_WITHHELD = "LocWithheld";
    public static final String LOCATION_INVALID = "LatLongInvalid";
    public static final String LOCATION_MISSING = "LatLongMissing";
    public static final String STATE_INVALID = "StateInvalid";
    public static final String NOT_AUSTRALIA = "NotAus";
    public static final String PLANT_PEST_MSG_CAT1_A0 = "PPC1";
    public static final String PLANT_PEST_MSG_CAT1_A1 = "PPC1-A1";
    public static final String PLANT_PEST_MSG_CAT1_A2 = "PPC1-A2";
    public static final String PLANT_PEST_MSG_CAT1_A3 = "PPC1-A3";
    public static final String PLANT_PEST_MSG_CAT1_A4 = "PPC1-A4";
    public static final String PLANT_PEST_MSG_CAT1_B1 = "PPC1-B1";
    public static final String PLANT_PEST_MSG_CAT1_D1 = "PPC1-D1";
    public static final String PLANT_PEST_MSG_CAT2_A1 = "PPC2-A1";
    public static final String PLANT_PEST_MSG_CAT2_B1 = "PPC2-B1";
    public static final String PLANT_PEST_MSG_CAT2_B2 = "PPC2-B2";
    public static final String PLANT_PEST_MSG_CAT2_C1 = "PPC2-C1";
    public static final String PLANT_PEST_MSG_CAT2_C2 = "PPC2-C2";
    public static final String PLANT_PEST_MSG_CAT3_A1 = "PPC3-A1";
    public static final String PLANT_PEST_MSG_CAT3_B1 = "PPC3-B1";
    public static final String PLANT_PEST_MSG_CAT3_B2 = "PPC3-B2";
    public static final String PLANT_PEST_MSG_CAT3_ALL1 = "PPC3-ALL-1";
    public static final String PLANT_PEST_MSG_CAT3_ALL2 = "PPC3-ALL-2";
    public static final String PLANT_PEST_MSG_CAT3_ALL3 = "PPC3-ALL-3";
    public static final String PLANT_PEST_MSG_CAT4_A1 = "PPC4-A1";
    public static final String PLANT_PEST_MSG_CAT4_B1 = "PPC4-B1";
    public static final String PLANT_PEST_MSG_CAT4_B2 = "PPC4-B2";
    public static final String PLANT_PEST_MSG_CAT4_B3 = "PPC4-B3";
    public static final String PLANT_PEST_MSG_CAT5A_A1 = "PPC5a-A1";
    public static final String PLANT_PEST_MSG_CAT5A_A2 = "PPC5a-A2";
    public static final String PLANT_PEST_MSG_CAT5A_B1 = "PPC5a-B1";
    public static final String PLANT_PEST_MSG_CAT5A_B2 = "PPC5a-B2";
    public static final String PLANT_PEST_MSG_CAT5A_C1 = "PPC5a-A1";
    public static final String PLANT_PEST_MSG_CAT5A_C2 = "PPC5a-C2";
    public static final String PLANT_PEST_MSG_CAT5A_D1 = "PPC5a-A1";
    public static final String PLANT_PEST_MSG_CAT5A_D2 = "PPC5a-D2";
    public static final String PLANT_PEST_MSG_CAT5B_A1 = "PPC5b-A1";
    public static final String PLANT_PEST_MSG_CAT5B_A2 = "PPC5b-A2";
    public static final String PLANT_PEST_MSG_CAT5B_A3 = "PPC5b-A3";
    public static final String PLANT_PEST_MSG_CAT6_A1 = "PPC6-A1";
    public static final String PLANT_PEST_MSG_CAT6_A2 = "PPC6-A2";
    public static final String PLANT_PEST_MSG_CAT7 = "PBC7";
    public static final String PLANT_PEST_MSG_CAT8 = "PBC8";
    public static final String PLANT_PEST_MSG_CAT9 = "PBC9";
    public static final String PLANT_PEST_MSG_CAT10 = "PBC10";
    private static String BUNDLE_NAME = "sds-messages";

    public static Message createMessage(Message.Type type, String messageKey, Object ... context) {
        return new SdsMessage(type, MessageFactory.getMessageText(messageKey, context) + ". (" + messageKey + ")", messageKey);
    }

    public static Message createInfoMessage(String messageKey, Object ... context) {
        return MessageFactory.createMessage(Message.Type.INFO, messageKey, context);
    }

    public static Message createErrorMessage(String messageKey, Object ... context) {
        return MessageFactory.createMessage(Message.Type.ERROR, messageKey, context);
    }

    public static Message createAlertMessage(String messageKey, Object ... context) {
        return MessageFactory.createMessage(Message.Type.ALERT, messageKey, context);
    }

    public static Message createWarningMessage(String messageKey, Object ... context) {
        return MessageFactory.createMessage(Message.Type.WARNING, messageKey, context);
    }

    public static Message createMessage(Message.Type type, String messageKey) {
        return new SdsMessage(type, MessageFactory.getMessageText(messageKey, new Object[0]) + ". (" + messageKey + ")", messageKey);
    }

    public static Message createInfoMessage(String messageKey) {
        return MessageFactory.createMessage(Message.Type.INFO, messageKey);
    }

    public static Message createErrorMessage(String messageKey) {
        return MessageFactory.createMessage(Message.Type.ERROR, messageKey);
    }

    public static Message createAlertMessage(String messageKey) {
        return MessageFactory.createMessage(Message.Type.ALERT, messageKey);
    }

    public static Message createWarningMessage(String messageKey) {
        return MessageFactory.createMessage(Message.Type.WARNING, messageKey);
    }

    public static String getMessageText(String messageKey, Object ... context) {
        String msgTemplate;
        try {
            msgTemplate = MessagesHolder.messages.getString(messageKey);
        }
        catch (MissingResourceException mre) {
            msgTemplate = "Message definition not found for supplied message key (" + messageKey + ")";
        }
        return MessageFormat.format(msgTemplate, context);
    }

    public static String getMessageText(String messageKey) {
        String msgTemplate;
        try {
            msgTemplate = MessagesHolder.messages.getString(messageKey);
        }
        catch (MissingResourceException mre) {
            msgTemplate = "Message definition not found for supplied message key (" + messageKey + ")";
        }
        return msgTemplate;
    }

    protected static void setMessageBundleName(String MessageBundle) {
        BUNDLE_NAME = MessageBundle;
    }

    static /* synthetic */ String access$000() {
        return BUNDLE_NAME;
    }

    private static class MessagesHolder {
        public static ResourceBundle messages = ResourceBundle.getBundle(MessageFactory.access$000());

        private MessagesHolder() {
        }
    }
}

