/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.sds.util;

import au.org.ala.sds.model.SensitivityZone;
import au.org.ala.sds.model.SensitivityZoneFactory;
import au.org.ala.sds.util.Configuration;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.log4j.Logger;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.map.ObjectMapper;

public class GeoLocationHelper {
    static final Logger logger = Logger.getLogger(GeoLocationHelper.class);
    public static final String COASTAL_WATERS_LAYER = "cl927";
    public static final String LGA_BOUNDARIES_LAYER = "cl23";
    static final String TSPZ_LAYER = "cl937";
    static final String TSSQZ_LAYER = "cl941";
    static final String FFEZ_TRI_STATE_LAYER = "cl938";
    static final String PCN_VIC_LAYER = "cl939";
    static final String PIZ_NSW_ALBURY_LAYER = "cl936";
    static final String PIZ_NSW_SYDNEY_LAYER = "cl940";
    static final String PIZ_VIC_NORTH_EAST_LAYER = "cl963";
    static final String PIZ_VIC_MAROONDAH_LAYER = "cl962";
    static final String PIZ_VIC_NAGAMBIE_LAYER = "cl961";
    static final String PIZ_VIC_MOOROOPNA_LAYER = "cl960";
    static final String PIZ_VIC_UPTON_LAYER = "cl964";
    static final String PIZ_VIC_WHITEBRIDGE_LAYER = "cl965";
    static final String STATES_TERRITORIES_LAYER = "cl22";
    static final List<String> SDS_GEOSPATIAL_LAYERS = Arrays.asList("cl927", "cl23", "cl937", "cl941", "cl938", "cl939", "cl936", "cl940", "cl963", "cl962", "cl961", "cl960", "cl964", "cl965", "cl22");

    public static Set<SensitivityZone> getZonesContainingPoint(String latitude, String longitude) throws Exception {
        HashSet<SensitivityZone> zones = new HashSet<SensitivityZone>();
        URL url = new URL(Configuration.getInstance().getSpatialUrl() + GeoLocationHelper.getLayersForUri() + "/" + latitude + "/" + longitude);
        URLConnection connection = url.openConnection();
        logger.debug((Object)("Looking up location using " + url));
        InputStream inStream = connection.getInputStream();
        logger.debug((Object)"Parsing location results");
        ObjectMapper mapper = new ObjectMapper();
        JsonNode rootNode = (JsonNode)mapper.readValue(inStream, JsonNode.class);
        for (JsonNode node : rootNode) {
            String field = node.get("field").getTextValue();
            String value = node.get("value").getTextValue();
            if (field.equalsIgnoreCase(COASTAL_WATERS_LAYER)) {
                String state = value.replace(" (including Coastal Waters)", "");
                state = state.replace("Captial", "Capital");
                SensitivityZone zone = SensitivityZoneFactory.getZoneByName(state = state.replace("Jervis Bay Territory", "Australian Capital Territory"));
                if (zone != null) {
                    zones.add(zone);
                }
                if (!state.equalsIgnoreCase("Queensland") || !((double)NumberUtils.toFloat((String)latitude) >= -19.0) || !((double)NumberUtils.toFloat((String)longitude) >= 144.25)) continue;
                zones.add(SensitivityZoneFactory.getZone("PFFPQA1995"));
                continue;
            }
            if (field.equalsIgnoreCase(STATES_TERRITORIES_LAYER)) {
                SensitivityZone zone = SensitivityZoneFactory.getZoneByName(value);
                if (zone == null) continue;
                zones.add(zone);
                continue;
            }
            if (field.equalsIgnoreCase(LGA_BOUNDARIES_LAYER)) {
                if (!value.equalsIgnoreCase("Bauhinia") && !value.equalsIgnoreCase("Emerald") && !value.equalsIgnoreCase("Peak Downs")) continue;
                zones.add(SensitivityZoneFactory.getZone("ECCPQA2004"));
                continue;
            }
            if (field.equalsIgnoreCase(TSPZ_LAYER) && !value.equalsIgnoreCase("n/a")) {
                zones.add(SensitivityZoneFactory.getZone("TSPZ"));
                continue;
            }
            if (field.equalsIgnoreCase(TSSQZ_LAYER) && !value.equalsIgnoreCase("n/a")) {
                zones.add(SensitivityZoneFactory.getZone("TSSQZ"));
                continue;
            }
            if (field.equalsIgnoreCase(FFEZ_TRI_STATE_LAYER) && !value.equalsIgnoreCase("n/a")) {
                zones.add(SensitivityZoneFactory.getZone("FFEZ"));
                continue;
            }
            if (field.equalsIgnoreCase(PCN_VIC_LAYER)) {
                if (value.equalsIgnoreCase("Thorpedale")) {
                    zones.add(SensitivityZoneFactory.getZone("PCNCAVICTHO"));
                    continue;
                }
                if (value.equalsIgnoreCase("Koo Wee Rup")) {
                    zones.add(SensitivityZoneFactory.getZone("PCNCAVICKWR"));
                    continue;
                }
                if (value.equalsIgnoreCase("Gembrook")) {
                    zones.add(SensitivityZoneFactory.getZone("PCNCAVICGEM"));
                    continue;
                }
                if (!value.equalsIgnoreCase("Wandin")) continue;
                zones.add(SensitivityZoneFactory.getZone("PCNCAVICWAN"));
                continue;
            }
            if (field.equalsIgnoreCase(PIZ_NSW_ALBURY_LAYER) && !value.equalsIgnoreCase("n/a")) {
                zones.add(SensitivityZoneFactory.getZone("PIZNSWAC"));
                continue;
            }
            if (field.equalsIgnoreCase(PIZ_NSW_SYDNEY_LAYER) && !value.equalsIgnoreCase("n/a")) {
                zones.add(SensitivityZoneFactory.getZone("PIZNSWSR"));
                continue;
            }
            if (field.equalsIgnoreCase(PIZ_VIC_NORTH_EAST_LAYER) && !value.equalsIgnoreCase("n/a")) {
                zones.add(SensitivityZoneFactory.getZone("PIZVICNE"));
                continue;
            }
            if (field.equalsIgnoreCase(PIZ_VIC_MAROONDAH_LAYER) && !value.equalsIgnoreCase("n/a")) {
                zones.add(SensitivityZoneFactory.getZone("PIZVICMAR"));
                continue;
            }
            if (field.equalsIgnoreCase(PIZ_VIC_NAGAMBIE_LAYER) && !value.equalsIgnoreCase("n/a")) {
                zones.add(SensitivityZoneFactory.getZone("PIZVICNAG"));
                continue;
            }
            if (field.equalsIgnoreCase(PIZ_VIC_MOOROOPNA_LAYER) && !value.equalsIgnoreCase("n/a")) {
                zones.add(SensitivityZoneFactory.getZone("PIZVICMOR"));
                continue;
            }
            if (field.equalsIgnoreCase(PIZ_VIC_UPTON_LAYER) && !value.equalsIgnoreCase("n/a")) {
                zones.add(SensitivityZoneFactory.getZone("PIZVICUPT"));
                continue;
            }
            if (!field.equalsIgnoreCase(PIZ_VIC_WHITEBRIDGE_LAYER) || value.equalsIgnoreCase("n/a")) continue;
            zones.add(SensitivityZoneFactory.getZone("PIZVICWHB"));
        }
        if (zones.isEmpty()) {
            logger.debug((Object)("Zone could not be determined from location: Lat " + latitude + ", Long " + longitude));
            zones.add(SensitivityZoneFactory.getZone("NOTAUS"));
        }
        return zones;
    }

    public static List<String> getGeospatialLayers() {
        return SDS_GEOSPATIAL_LAYERS;
    }

    public static List<SensitivityZone> filterForZoneType(List<SensitivityZone> zones, SensitivityZone.ZoneType type) {
        ArrayList<SensitivityZone> newZones = new ArrayList<SensitivityZone>();
        for (SensitivityZone zone : zones) {
            if (zone.getType() != type) continue;
            newZones.add(zone);
        }
        return newZones;
    }

    private static String getLayersForUri() {
        StringBuilder layers = new StringBuilder();
        for (String layer : SDS_GEOSPATIAL_LAYERS) {
            layers.append(layer).append(',');
        }
        layers.setLength(layers.length() - 1);
        return layers.toString();
    }
}

