/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.sds.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;

public class Configuration {
    private static final Configuration instance = new Configuration();
    private final Properties config = new Properties();

    private Configuration() {
        File configFile = new File("/data/sds/sds-config.properties");
        try {
            this.config.load(new FileInputStream(configFile));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static Configuration getInstance() {
        return instance;
    }

    public String get(String field) {
        return this.config.getProperty(field, field);
    }

    public String getFlagRules() {
        return this.config.getProperty("flag-rules", "PBC7,PBC8,PBC9");
    }

    public String getSpeciesUrl() {
        return this.config.getProperty("species-data", "http://sds.ala.org.au/sensitive-species-data.xml");
    }

    public String getCategoryUrl() {
        return this.config.getProperty("category-data", "http://sds.ala.org.au/sensitivity-categories.xml");
    }

    public String getZoneUrl() {
        return this.config.getProperty("zone-data", "http://sds.ala.org.au/sensitivity-zones.xml");
    }

    public boolean isCached() {
        return this.config.getProperty("species-cache", "false").equalsIgnoreCase("true");
    }

    public String getCacheUrl() {
        return this.config.getProperty("cache-data", "/data/sds/species-cache.ser");
    }

    public String getSpatialUrl() {
        return this.config.getProperty("spatial-layer-ws", "http://spatial.ala.org.au/layers-service/intersect/");
    }

    public String getNameMatchingIndex() {
        return this.config.getProperty("namematching-index", "/data/lucene/namematching_v13");
    }

    public String getListToolUrl() {
        return this.config.getProperty("list-url", "http://lists.ala.org.au");
    }
}

