/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.sds.model;

import au.org.ala.sds.dao.SensitivityCategoryXmlDao;
import au.org.ala.sds.model.SensitivityCategory;
import au.org.ala.sds.util.Configuration;
import java.io.InputStream;
import java.net.URL;
import java.util.Map;
import org.apache.log4j.Logger;

public class SensitivityCategoryFactory {
    protected static final Logger logger = Logger.getLogger(SensitivityCategoryFactory.class);
    private static final String CATEGORIES_RESOURCE = "sensitivity-categories.xml";
    private static Map<String, SensitivityCategory> categories;

    public static SensitivityCategory getCategory(String key) {
        if (categories == null) {
            SensitivityCategoryFactory.initCategories();
        }
        return categories.get(key);
    }

    private static void initCategories() {
        URL url = null;
        InputStream is = null;
        try {
            url = new URL(Configuration.getInstance().getCategoryUrl());
            is = url.openStream();
        }
        catch (Exception e) {
            logger.warn((Object)("Exception occurred getting categories list from " + url), (Throwable)e);
            is = SensitivityCategoryFactory.class.getClassLoader().getResourceAsStream(CATEGORIES_RESOURCE);
            if (is == null) {
                logger.error((Object)"Unable to read sensitivity-categories.xml from jar file");
            }
            logger.info((Object)"Reading bundled resource sensitivity-categories.xml from jar file");
        }
        SensitivityCategoryXmlDao dao = new SensitivityCategoryXmlDao(is);
        try {
            categories = dao.getMap();
        }
        catch (Exception e) {
            logger.error((Object)("Exception occurred parsing categories list from " + is), (Throwable)e);
        }
    }
}

