/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.sds.dao;

import au.org.ala.sds.dao.SensitiveSpeciesDao;
import au.org.ala.sds.dto.SensitiveSpeciesDto;
import au.org.ala.sds.model.ConservationInstance;
import au.org.ala.sds.model.PlantPestInstance;
import au.org.ala.sds.model.SensitiveTaxon;
import au.org.ala.sds.model.SensitivityCategory;
import au.org.ala.sds.model.SensitivityCategoryFactory;
import au.org.ala.sds.model.SensitivityZoneFactory;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.sql.DataSource;
import org.apache.commons.lang.StringUtils;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.support.JdbcDaoSupport;

public class SensitiveSpeciesMySqlDao
extends JdbcDaoSupport
implements SensitiveSpeciesDao {
    public static final String SELECT_ALL = "SELECT z.scientific_name, common_name, family, sensitivity_category, sensitivity_zone, reason, remarks, authority_name, data_resource_id, from_date, to_date, location_generalisation FROM sensitive_species_zones z, sensitive_species s WHERE z.scientific_name = s.scientific_name ORDER BY z.scientific_name";

    public SensitiveSpeciesMySqlDao(DataSource dataSource) throws Exception {
        this.setDataSource(dataSource);
    }

    public void initDao() throws Exception {
        super.initDao();
    }

    @Override
    public List<SensitiveTaxon> getAll() {
        List dtoList = this.getJdbcTemplate().query(SELECT_ALL, (RowMapper)new RowMapper<SensitiveSpeciesDto>(){

            public SensitiveSpeciesDto mapRow(ResultSet rs, int row) throws SQLException {
                SensitiveSpeciesDto dto = new SensitiveSpeciesDto();
                dto.setScientificName(rs.getString("scientific_name"));
                dto.setCommonName(rs.getString("common_name"));
                dto.setFamily(rs.getString("family"));
                dto.setSensitivityZone(rs.getString("sensitivity_zone"));
                dto.setAuthority(rs.getString("authority_name"));
                dto.setDataResourceId(rs.getString("data_resource_id"));
                dto.setReason(rs.getString("reason"));
                dto.setRemarks(rs.getString("remarks"));
                dto.setFromDate(rs.getString("from_date"));
                dto.setToDate(rs.getString("to_date"));
                dto.setSensitivityCategory(rs.getString("sensitivity_category"));
                dto.setLocationGeneralisation(rs.getString("location_generalisation"));
                return dto;
            }
        });
        ArrayList<SensitiveTaxon> speciesList = new ArrayList<SensitiveTaxon>();
        SensitiveTaxon ss = null;
        String currentName = "";
        for (SensitiveSpeciesDto dto : dtoList) {
            SensitivityCategory category;
            if (!dto.getScientificName().equals(currentName)) {
                ss = StringUtils.contains((String)dto.getScientificName(), (char)' ') ? new SensitiveTaxon(dto.getScientificName(), SensitiveTaxon.Rank.SPECIES) : new SensitiveTaxon(dto.getScientificName(), SensitiveTaxon.Rank.GENUS);
                if (StringUtils.isNotBlank((String)dto.getFamily())) {
                    ss.setFamily(dto.getFamily());
                }
                if (StringUtils.isNotBlank((String)dto.getCommonName())) {
                    ss.setCommonName(dto.getCommonName());
                }
                speciesList.add(ss);
                currentName = dto.getScientificName();
            }
            if ((category = SensitivityCategoryFactory.getCategory(dto.getSensitivityCategory())).isConservationSensitive()) {
                ss.getInstances().add(new ConservationInstance(category, dto.getAuthority(), dto.getDataResourceId(), SensitivityZoneFactory.getZone(dto.getSensitivityZone()), dto.getReason(), dto.getRemarks(), dto.getLocationGeneralisation()));
                continue;
            }
            if (!category.isPlantPest()) continue;
            ss.getInstances().add(new PlantPestInstance(category, dto.getAuthority(), dto.getDataResourceId(), SensitivityZoneFactory.getZone(dto.getSensitivityZone()), dto.getReason(), dto.getRemarks(), dto.getFromDate(), dto.getToDate()));
        }
        Collections.sort(speciesList);
        return speciesList;
    }
}

