/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.sds.dao;

import au.org.ala.sds.dao.DataRowHandler;
import au.org.ala.sds.dao.DataStreamDao;
import au.org.ala.sds.dto.DataColumnMapper;
import au.org.ala.sds.dto.DataStreamProperties;
import au.org.ala.sds.util.DateHelper;
import au.org.ala.sds.util.ExcelUtils;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.poi.hssf.usermodel.HSSFDateUtil;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class DataStreamExcelDao
implements DataStreamDao {
    protected static final Logger logger = Logger.getLogger(DataStreamExcelDao.class);
    private final String fileName;
    private final InputStream stream;

    public DataStreamExcelDao(String fileName, InputStream stream) {
        this.fileName = fileName;
        this.stream = stream;
    }

    @Override
    public void processStream(DataColumnMapper mapper, DataStreamProperties properties, DataRowHandler rowHandler) throws IOException {
        HSSFWorkbook wb = null;
        if (this.fileName.endsWith(".xls")) {
            wb = new HSSFWorkbook(this.stream);
        } else if (this.fileName.endsWith(".xlsx")) {
            wb = new XSSFWorkbook(this.stream);
        } else {
            throw new IllegalStateException("File extension not supported");
        }
        Sheet sheet = wb.getSheetAt(properties.getSheetIndex() - 1);
        logger.debug((Object)("Reading Excel workbook = " + this.fileName));
        logger.debug((Object)("Sheet = " + sheet.getSheetName()));
        HashMap<String, Integer> columnMap = new HashMap<String, Integer>();
        for (String key : mapper.getKeySet()) {
            String value = mapper.get(key);
            if (StringUtils.isNumeric((String)value)) {
                columnMap.put(key, Integer.parseInt(value) - 1);
                continue;
            }
            columnMap.put(key, ExcelUtils.getOrdinal(value) - 1);
        }
        int rowCount = 0;
        int start = properties.getStartRow() - 1;
        int end = properties.getEndRow() == 0 ? sheet.getLastRowNum() : properties.getEndRow() - 1;
        for (int i = start; i <= end; ++i) {
            Row row = sheet.getRow(i);
            if (row == null) continue;
            HashMap<String, String> facts = new HashMap<String, String>();
            for (String key : columnMap.keySet()) {
                Cell cell = row.getCell(((Integer)columnMap.get(key)).intValue());
                if (cell == null) continue;
                switch (cell.getCellType()) {
                    case 1: {
                        facts.put(key, cell.getStringCellValue().trim());
                        break;
                    }
                    case 0: 
                    case 2: {
                        double d = cell.getNumericCellValue();
                        try {
                            if (HSSFDateUtil.isCellDateFormatted((Cell)cell)) {
                                facts.put(key, DateHelper.formattedIso8601Date(HSSFDateUtil.getJavaDate((double)d)));
                                break;
                            }
                            facts.put(key, Double.toString(d));
                        }
                        catch (Exception e) {
                            logger.warn((Object)("Exception caught trying to check if cell '" + key + "' is a date - " + e.getMessage()));
                            facts.put(key, Double.toString(d));
                        }
                        break;
                    }
                    default: {
                        facts.put(key, "");
                    }
                }
            }
            if (facts.isEmpty()) continue;
            facts.put("row", Integer.toString(i + 1));
            ++rowCount;
            rowHandler.handleRow(facts);
        }
        System.out.println("Total no of rows = " + rowCount);
    }
}

