/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.sds;

import au.org.ala.sds.SensitiveSpeciesFinder;
import au.org.ala.sds.model.Message;
import au.org.ala.sds.model.SensitiveTaxon;
import au.org.ala.sds.util.Configuration;
import au.org.ala.sds.util.ValidationUtils;
import au.org.ala.sds.validation.MessageFactory;
import au.org.ala.sds.validation.ReportFactory;
import au.org.ala.sds.validation.SdsReportFactory;
import au.org.ala.sds.validation.ServiceFactory;
import au.org.ala.sds.validation.ValidationOutcome;
import au.org.ala.sds.validation.ValidationService;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.kie.internal.KnowledgeBase;

public class SensitiveDataService {
    private KnowledgeBase knowledgeBase;
    private ReportFactory reportFactory = new SdsReportFactory();
    protected static final Logger logger = Logger.getLogger(SensitiveDataService.class);

    public ValidationOutcome testMapDetails(SensitiveSpeciesFinder finder, Map<String, String> properties, String scientificName) {
        return this.testMapDetails(finder, properties, scientificName, null);
    }

    public ValidationOutcome testMapDetails(SensitiveSpeciesFinder finder, Map<String, String> properties, String scientificName, String taxonId) {
        Configuration config = Configuration.getInstance();
        for (String rule : config.getFlagRules().split(",")) {
            if (!StringUtils.isNotBlank((String)properties.get(rule))) continue;
            return this.restrictRecord(properties, rule, scientificName);
        }
        SensitiveTaxon st = null;
        if (taxonId != null) {
            st = finder.findSensitiveSpeciesByLsid(taxonId);
        }
        if (st == null && scientificName != null) {
            st = finder.findSensitiveSpecies(scientificName);
        }
        if (st != null) {
            ValidationService service = ServiceFactory.createValidationService(st);
            return service.validate(properties);
        }
        ValidationOutcome vo = new ValidationOutcome();
        vo.setLoadable(true);
        return null;
    }

    private ValidationOutcome restrictRecord(Map<String, String> properties, String rule, String scientificName) {
        ValidationOutcome vo = new ValidationOutcome(this.reportFactory.createValidationReport(null));
        vo.setLoadable(true);
        vo.getReport().setCategory(rule);
        vo.getReport().setAssertion(MessageFactory.getMessageText(rule, scientificName));
        vo.getReport().addMessage(MessageFactory.createMessage(Message.Type.INFO, rule, scientificName));
        Map<String, Object> results = ValidationUtils.restrictForPests(properties);
        vo.setResult(results);
        return vo;
    }

    private String constructScientificName(Map<String, String> properties) {
        String value = properties.get("scientificName");
        if (value == null) {
            return "";
        }
        return value;
    }
}

