/*
 * Decompiled with CFR 0.152.
 */
package au.org.ala.sds;

import au.org.ala.names.search.ALANameSearcher;
import au.org.ala.names.search.SearchResultException;
import au.org.ala.sds.SensitiveSpeciesFinder;
import au.org.ala.sds.SensitiveSpeciesFinderFactory;
import au.org.ala.sds.dao.RawOccurrenceDao;
import au.org.ala.sds.model.SensitiveTaxon;
import au.org.ala.sds.util.Configuration;
import au.org.ala.sds.validation.ServiceFactory;
import au.org.ala.sds.validation.ValidationOutcome;
import au.org.ala.sds.validation.ValidationService;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.dbcp.BasicDataSource;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class GeneraliseOccurrenceLocations {
    protected static final Logger logger = Logger.getLogger(GeneraliseOccurrenceLocations.class);
    private static RawOccurrenceDao rawOccurrenceDao;
    private static BasicDataSource occurrenceDataSource;
    private static ALANameSearcher nameSearcher;
    private static SensitiveSpeciesFinder sensitiveSpeciesFinder;

    public static void main(String[] args) throws Exception {
        nameSearcher = new ALANameSearcher(Configuration.getInstance().getNameMatchingIndex());
        sensitiveSpeciesFinder = SensitiveSpeciesFinderFactory.getSensitiveSpeciesFinder("file:///data/sds/sensitive-species.xml", nameSearcher);
        occurrenceDataSource = new BasicDataSource();
        occurrenceDataSource.setDriverClassName("com.mysql.jdbc.Driver");
        occurrenceDataSource.setUrl("jdbc:mysql://localhost/portal");
        occurrenceDataSource.setUsername("root");
        occurrenceDataSource.setPassword("password");
        GeneraliseOccurrenceLocations.run(args.length == 1 ? args[0] : null);
    }

    private static void run(String startAt) throws SQLException, SearchResultException {
        ResultSet rs;
        Connection conn = occurrenceDataSource.getConnection();
        PreparedStatement pst = conn.prepareStatement("SELECT id, scientific_name, latitude, longitude, generalised_metres, raw_latitude, raw_longitude FROM raw_occurrence_record LIMIT ?,?");
        int offset = startAt == null ? 0 : Integer.parseInt(startAt);
        int stride = 10000;
        int recCount = 0;
        pst.setInt(2, stride);
        pst.setInt(1, offset);
        while ((rs = pst.executeQuery()).isBeforeFirst()) {
            while (rs.next()) {
                ++recCount;
                String rawScientificName = rs.getString("scientific_name");
                int id = rs.getInt("id");
                String latitude = rs.getString("latitude");
                String longitude = rs.getString("longitude");
                String generalised_metres = rs.getString("generalised_metres");
                String raw_latitude = rs.getString("raw_latitude");
                String raw_longitude = rs.getString("raw_longitude");
                if (StringUtils.isEmpty((String)rawScientificName) || StringUtils.isEmpty((String)latitude) || StringUtils.isEmpty((String)longitude)) continue;
                SensitiveTaxon ss = sensitiveSpeciesFinder.findSensitiveSpecies(rawScientificName);
                if (ss != null) {
                    HashMap<String, String> facts = new HashMap<String, String>();
                    facts.put("decimalLatitude", latitude);
                    facts.put("decimalLongitude", longitude);
                    ValidationService service = ServiceFactory.createValidationService(ss);
                    ValidationOutcome outcome = service.validate(facts);
                    Map<String, Object> result = outcome.getResult();
                    String speciesName = ss.getTaxonName();
                    if (StringUtils.isNotEmpty((String)ss.getCommonName())) {
                        speciesName = speciesName + " [" + ss.getCommonName() + "]";
                    }
                    if (!result.get("decimalLatitude").equals(facts.get("decimalLatitude")) || !result.get("decimalLongitude").equals(facts.get("decimalLongitude"))) {
                        if (StringUtils.isEmpty((String)generalised_metres)) {
                            logger.info((Object)("Generalising location for " + id + " '" + rawScientificName + "' using Name='" + speciesName + "', Lat=" + result.get("decimalLatitude") + ", Long=" + result.get("decimalLongitude")));
                            continue;
                        }
                        if (generalised_metres == result.get("generalisationInMetres")) continue;
                        logger.info((Object)("Re-generalising location for " + id + " '" + rawScientificName + "' using Name='" + speciesName + "', Lat=" + result.get("decimalLatitude") + ", Long=" + result.get("decimalLongitude")));
                        continue;
                    }
                    logger.info((Object)("Not generalising location for " + id + " '" + rawScientificName + "' using Name='" + speciesName + "', Lat=" + result.get("decimalLatitude") + ", Long=" + result.get("decimalLongitude") + " - " + result.get("dataGeneralizations")));
                    continue;
                }
                if (!StringUtils.isNotEmpty((String)generalised_metres)) continue;
                logger.info((Object)("De-generalising location for " + id + " '" + rawScientificName + "', Lat=" + raw_latitude + ", Long=" + raw_longitude));
            }
            rs.close();
            logger.info((Object)("Processed " + recCount + " occurrence records."));
            pst.setInt(1, offset += stride);
        }
        rs.close();
        pst.close();
        conn.close();
    }
}

