/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.shef.wit.simmetrics.arbitrators;

import java.io.Serializable;
import java.util.ArrayList;
import uk.ac.shef.wit.simmetrics.arbitrators.InterfaceMetricArbitrator;
import uk.ac.shef.wit.simmetrics.similaritymetrics.InterfaceStringMetric;

public final class MeanMetricArbitrator
implements InterfaceMetricArbitrator,
Serializable {
    private ArrayList<InterfaceStringMetric> metricsForArbitration = new ArrayList();

    @Override
    public ArrayList<InterfaceStringMetric> getArbitrationMetrics() {
        return this.metricsForArbitration;
    }

    @Override
    public void setArbitrationMetrics(ArrayList<InterfaceStringMetric> arbitrationMetrics) {
        this.metricsForArbitration = arbitrationMetrics;
    }

    @Override
    public void addArbitrationMetric(InterfaceStringMetric arbitrationMetric) {
        this.metricsForArbitration.add(arbitrationMetric);
    }

    @Override
    public void addArbitrationMetrics(ArrayList<InterfaceStringMetric> arbitrationMetrics) {
        this.metricsForArbitration.addAll(arbitrationMetrics);
    }

    @Override
    public void clearArbitrationMetrics() {
        this.metricsForArbitration.clear();
    }

    @Override
    public String getShortDescriptionString() {
        return "MeanMetricArbitrator";
    }

    @Override
    public String getLongDescriptionString() {
        return "MeanMetricArbitrator gives equal weightings too all metrics and returns an arbitrated score for all";
    }

    @Override
    public long getArbitrationTimingActual(String string1, String string2) {
        long timeBefore = System.currentTimeMillis();
        this.getArbitrationScore(string1, string2);
        long timeAfter = System.currentTimeMillis();
        return timeAfter - timeBefore;
    }

    @Override
    public float getArbitrationTimingEstimated(String string1, String string2) {
        float estimatedTime = 0.0f;
        for (InterfaceStringMetric aMetricsForArbitration : this.metricsForArbitration) {
            estimatedTime += aMetricsForArbitration.getSimilarityTimingEstimated(string1, string2);
        }
        return estimatedTime;
    }

    @Override
    public float getArbitrationScore(String string1, String string2) {
        float score = 0.0f;
        if (this.metricsForArbitration.size() == 0) {
            return score;
        }
        for (InterfaceStringMetric aMetricsForArbitration : this.metricsForArbitration) {
            score += aMetricsForArbitration.getSimilarity(string1, string2);
        }
        return score / (float)this.metricsForArbitration.size();
    }
}

