/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.beliefsystem.jtms;

import org.drools.core.beliefsystem.BeliefSet;
import org.drools.core.beliefsystem.BeliefSystem;
import org.drools.core.beliefsystem.jtms.JTMSBeliefSet;
import org.drools.core.beliefsystem.jtms.JTMSBeliefSetImpl;
import org.drools.core.beliefsystem.simple.SimpleLogicalDependency;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.LogicalDependency;
import org.drools.core.common.NamedEntryPoint;
import org.drools.core.common.TruthMaintenanceSystem;
import org.drools.core.reteoo.ObjectTypeConf;
import org.drools.core.spi.Activation;
import org.drools.core.spi.PropagationContext;
import org.drools.core.util.LinkedListEntry;

public class JTMSBeliefSystem
implements BeliefSystem {
    public static boolean STRICT = false;
    private TruthMaintenanceSystem tms;
    private NamedEntryPoint defEP;
    private NamedEntryPoint negEP;

    public JTMSBeliefSystem(NamedEntryPoint ep, TruthMaintenanceSystem tms) {
        this.defEP = ep;
        this.tms = tms;
        this.initMainEntryPoints();
    }

    private void initMainEntryPoints() {
        this.negEP = (NamedEntryPoint)this.defEP.getWorkingMemoryEntryPoint(JTMSBeliefSetImpl.MODE.NEGATIVE.getId());
    }

    @Override
    public TruthMaintenanceSystem getTruthMaintenanceSystem() {
        return this.tms;
    }

    @Override
    public void insert(LogicalDependency node, BeliefSet beliefSet, PropagationContext context, ObjectTypeConf typeConf) {
        JTMSBeliefSet jtmsBeliefSet = (JTMSBeliefSet)beliefSet;
        boolean wasEmpty = jtmsBeliefSet.isEmpty();
        boolean wasNegated = jtmsBeliefSet.isNegated();
        boolean wasUndecided = jtmsBeliefSet.isUndecided();
        jtmsBeliefSet.add(node.getJustifierEntry());
        if (wasEmpty) {
            if (!jtmsBeliefSet.isUndecided()) {
                this.insertBelief(node, typeConf, jtmsBeliefSet, context, wasEmpty, wasNegated, wasUndecided);
            } else {
                this.defEP.getObjectStore().removeHandle(jtmsBeliefSet.getFactHandle());
            }
        } else if (!wasUndecided && jtmsBeliefSet.isUndecided()) {
            if (STRICT) {
                throw new IllegalStateException("FATAL : A fact and its negation have been asserted " + jtmsBeliefSet.getFactHandle().getObject());
            }
            if (wasNegated) {
                InternalFactHandle fh = jtmsBeliefSet.getNegativeFactHandle();
                jtmsBeliefSet.setNegativeFactHandle(null);
                boolean fullyRetract = true;
                ((NamedEntryPoint)fh.getEntryPoint()).delete(fh, context.getRuleOrigin(), node.getJustifier());
            } else {
                InternalFactHandle fh = jtmsBeliefSet.getPositiveFactHandle();
                jtmsBeliefSet.setPositiveFactHandle(null);
                boolean fullyRetract = false;
                NamedEntryPoint nep = (NamedEntryPoint)fh.getEntryPoint();
                nep.getEntryPointNode().retractObject(fh, context, typeConf, nep.getInternalWorkingMemory());
            }
        } else if (wasUndecided && !jtmsBeliefSet.isUndecided()) {
            this.insertBelief(node, typeConf, jtmsBeliefSet, context, wasEmpty, wasNegated, wasUndecided);
        }
    }

    private void insertBelief(LogicalDependency node, ObjectTypeConf typeConf, JTMSBeliefSet jtmsBeliefSet, PropagationContext context, boolean wasEmpty, boolean wasNegated, boolean isUndecided) {
        if (jtmsBeliefSet.isNegated() && !jtmsBeliefSet.isUndecided()) {
            jtmsBeliefSet.setNegativeFactHandle((InternalFactHandle)this.negEP.insert(node.getObject()));
            jtmsBeliefSet.getNegativeFactHandle().setEqualityKey(jtmsBeliefSet.getFactHandle().getEqualityKey());
            jtmsBeliefSet.setPositiveFactHandle(null);
            if (!wasNegated && !isUndecided) {
                this.defEP.getObjectStore().removeHandle(jtmsBeliefSet.getFactHandle());
            }
        } else if (jtmsBeliefSet.isPositive() && !jtmsBeliefSet.isUndecided()) {
            jtmsBeliefSet.setPositiveFactHandle(jtmsBeliefSet.getFactHandle());
            jtmsBeliefSet.setNegativeFactHandle(null);
            if (!wasEmpty && (wasNegated || isUndecided)) {
                jtmsBeliefSet.getFactHandle().setObject(node.getObject());
                this.defEP.getObjectStore().addHandle(jtmsBeliefSet.getPositiveFactHandle(), jtmsBeliefSet.getPositiveFactHandle().getObject());
            }
            this.defEP.insert(jtmsBeliefSet.getPositiveFactHandle(), node.getObject(), node.getJustifier().getRule(), node.getJustifier(), typeConf, null);
        }
    }

    @Override
    public void read(LogicalDependency node, BeliefSet beliefSet, PropagationContext context, ObjectTypeConf typeConf) {
        throw new UnsupportedOperationException("This is not serializable yet");
    }

    @Override
    public void delete(LogicalDependency node, BeliefSet beliefSet, PropagationContext context) {
        JTMSBeliefSet jtmsBeliefSet = (JTMSBeliefSet)beliefSet;
        boolean wasConflicting = jtmsBeliefSet.isUndecided();
        boolean wasNegated = jtmsBeliefSet.isNegated();
        boolean primeChanged = false;
        if (jtmsBeliefSet.getPositiveFactHandle() != null && jtmsBeliefSet.getPositiveFactHandle().getObject() == node.getObject() || jtmsBeliefSet.getNegativeFactHandle() != null && jtmsBeliefSet.getNegativeFactHandle().getObject() == node.getObject()) {
            primeChanged = true;
        }
        beliefSet.remove(node.getJustifierEntry());
        if (beliefSet.isEmpty()) {
            InternalFactHandle fh;
            if (wasNegated) {
                this.defEP.getObjectStore().addHandle(beliefSet.getFactHandle(), beliefSet.getFactHandle().getObject());
                fh = jtmsBeliefSet.getNegativeFactHandle();
                ((NamedEntryPoint)fh.getEntryPoint()).delete(fh, context.getRuleOrigin(), node.getJustifier());
            }
            if (context.getType() != 1 || context.getFactHandle() != beliefSet.getFactHandle()) {
                fh = jtmsBeliefSet.getFactHandle();
                ((NamedEntryPoint)fh.getEntryPoint()).delete(fh, context.getRuleOrigin(), node.getJustifier());
            }
        } else if (wasConflicting && !jtmsBeliefSet.isUndecided()) {
            this.insertBelief(node, this.defEP.getObjectTypeConfigurationRegistry().getObjectTypeConf(this.defEP.getEntryPoint(), node.getObject()), jtmsBeliefSet, context, false, wasNegated, wasConflicting);
        } else if (primeChanged) {
            InternalFactHandle handle;
            Object object = null;
            if (jtmsBeliefSet.isNegated()) {
                if (!wasNegated) {
                    jtmsBeliefSet.setNegativeFactHandle(jtmsBeliefSet.getPositiveFactHandle());
                    jtmsBeliefSet.setPositiveFactHandle(null);
                }
                String value = JTMSBeliefSetImpl.MODE.NEGATIVE.getId();
                handle = jtmsBeliefSet.getNegativeFactHandle();
                for (LinkedListEntry entry = (LinkedListEntry)jtmsBeliefSet.getLast(); entry != null; entry = (LinkedListEntry)entry.getPrevious()) {
                    if (!((LogicalDependency)entry.getObject()).getValue().equals(value)) continue;
                    object = ((LogicalDependency)entry.getObject()).getObject();
                    break;
                }
            } else {
                if (wasNegated) {
                    jtmsBeliefSet.setPositiveFactHandle(jtmsBeliefSet.getNegativeFactHandle());
                    jtmsBeliefSet.setNegativeFactHandle(null);
                }
                String value = JTMSBeliefSetImpl.MODE.POSITIVE.getId();
                handle = jtmsBeliefSet.getPositiveFactHandle();
                for (LinkedListEntry entry = (LinkedListEntry)jtmsBeliefSet.getFirst(); entry != null; entry = (LinkedListEntry)entry.getNext()) {
                    if (((LogicalDependency)entry.getObject()).getValue() != null && !((LogicalDependency)entry.getObject()).getValue().equals(value)) continue;
                    object = ((LogicalDependency)entry.getObject()).getObject();
                    break;
                }
            }
            if (handle.getObject() != object) {
                ((NamedEntryPoint)handle.getEntryPoint()).getObjectStore().updateHandle(handle, object);
                ((NamedEntryPoint)handle.getEntryPoint()).update(handle, true, handle.getObject(), Long.MAX_VALUE, Object.class, null);
            }
        }
    }

    @Override
    public BeliefSet newBeliefSet(InternalFactHandle fh) {
        return new JTMSBeliefSetImpl(this, fh);
    }

    @Override
    public LogicalDependency newLogicalDependency(Activation activation, BeliefSet beliefSet, Object object, Object value) {
        return new SimpleLogicalDependency(activation, beliefSet, object, value);
    }
}

