/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.common.parsers.date;

import com.google.common.base.Strings;
import javax.annotation.Nullable;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

public class YearMonthDay {
    protected String year;
    protected String month;
    protected String day;

    public YearMonthDay(String year, String month, String day) {
        this.setYear(year);
        this.setMonth(month);
        this.setDay(day);
    }

    public YearMonthDay() {
    }

    public String getYear() {
        return this.year;
    }

    public Integer getIntegerYear() {
        return YearMonthDay.parseInt(this.year);
    }

    private static Integer parseInt(String x) {
        if (!Strings.isNullOrEmpty((String)x)) {
            try {
                return Integer.valueOf(x);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return null;
    }

    public void setYear(@Nullable String year) {
        this.year = year;
        if (year != null) {
            for (int i = year.length(); i < 4; ++i) {
                this.year = "0" + year;
            }
        }
    }

    public String getMonth() {
        return this.month;
    }

    public Integer getIntegerMonth() {
        return YearMonthDay.parseInt(this.month);
    }

    public void setMonth(@Nullable String month) {
        this.month = month;
        if (month != null) {
            for (int i = month.length(); i < 2; ++i) {
                this.month = "0" + month;
            }
        }
    }

    public String getDay() {
        return this.day;
    }

    public Integer getIntegerDay() {
        return YearMonthDay.parseInt(this.day);
    }

    public void setDay(@Nullable String day) {
        this.day = day;
        if (day != null) {
            for (int i = day.length(); i < 2; ++i) {
                this.day = "0" + day;
            }
        }
    }

    public boolean representsNull() {
        return this.year == null && this.month == null && this.day == null;
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.year).append((Object)this.month).append((Object)this.day).toHashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof YearMonthDay) {
            YearMonthDay ymd = (YearMonthDay)obj;
            return new EqualsBuilder().append((Object)this.year, (Object)ymd.getYear()).append((Object)this.month, (Object)ymd.getMonth()).append((Object)this.day, (Object)ymd.getDay()).isEquals();
        }
        return false;
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("year", (Object)this.year).append("month", (Object)this.month).append("day", (Object)this.day).toString();
    }
}

