/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.common.parsers.core;

import com.google.common.base.CharMatcher;
import com.google.common.base.Strings;
import java.io.InputStream;
import java.util.regex.Pattern;
import org.gbif.api.util.VocabularyUtils;
import org.gbif.common.parsers.core.ASCIIParser;
import org.gbif.common.parsers.core.FileBasedDictionaryParser;
import org.gbif.common.parsers.core.ParseResult;

public class EnumParser<T extends Enum<T>>
extends FileBasedDictionaryParser<T> {
    private final Class<T> clazz;
    private final Pattern NORMALIZER;
    private final ASCIIParser ascii = ASCIIParser.getInstance();
    private static final CharMatcher LETTER_MATCHER = CharMatcher.JAVA_LETTER.or(CharMatcher.WHITESPACE).precomputed();
    private static final CharMatcher WHITESPACE_MATCHER = CharMatcher.WHITESPACE.precomputed();

    protected EnumParser(Class<T> clazz, boolean allowDigits, InputStream ... inputs) {
        super(false);
        this.NORMALIZER = allowDigits ? Pattern.compile("\\W+") : Pattern.compile("[^a-zA-Z]+");
        this.clazz = clazz;
        this.addEnumValues();
        if (inputs != null) {
            for (InputStream input : inputs) {
                this.init(input);
            }
        }
    }

    private void addEnumValues() {
        Enum[] values = (Enum[])this.clazz.getEnumConstants();
        if (values != null) {
            for (Enum val : values) {
                this.add(val.name(), val);
            }
        }
    }

    protected String normalizeALT(String value) {
        if (value != null) {
            String cleaned = LETTER_MATCHER.retainFrom((CharSequence)value);
            cleaned = WHITESPACE_MATCHER.trimAndCollapseFrom((CharSequence)cleaned, ' ');
            if (Strings.isNullOrEmpty((String)(cleaned = Strings.emptyToNull((String)cleaned)))) {
                return null;
            }
            ParseResult<String> asci = this.ascii.parse(cleaned);
            return this.NORMALIZER.matcher(asci.getPayload()).replaceAll("").toUpperCase();
        }
        return null;
    }

    @Override
    protected String normalize(String value) {
        if (Strings.isNullOrEmpty((String)value)) {
            return null;
        }
        ParseResult<String> asci = this.ascii.parse(value);
        return this.NORMALIZER.matcher(asci.getPayload()).replaceAll("").toUpperCase();
    }

    @Override
    protected T fromDictFile(String value) {
        try {
            return (T)VocabularyUtils.lookupEnum((String)value, this.clazz);
        }
        catch (RuntimeException e) {
            return null;
        }
    }
}

