/*
 * Decompiled with CFR 0.152.
 */
package org.scale7.cassandra.pelops;

import org.apache.cassandra.thrift.Cassandra;
import org.apache.thrift.transport.TTransportException;
import org.scale7.cassandra.pelops.Cluster;
import org.scale7.cassandra.pelops.IConnectionAuthenticator;

public interface IConnection {
    public Cassandra.Client getAPI();

    public Cluster.Node getNode();

    public boolean isOpen();

    public void open() throws TTransportException;

    public void close();

    public static class Config {
        private final int thriftPort;
        private final boolean framedTransportRequired;
        private final int timeout;
        private IConnectionAuthenticator connectionAuthenticator;

        public Config(int thriftPort, boolean framedTransportRequired, int timeout) {
            this.thriftPort = thriftPort;
            this.framedTransportRequired = framedTransportRequired;
            this.timeout = timeout;
            this.connectionAuthenticator = null;
        }

        public Config(int thriftPort, boolean framedTransportRequired, int timeout, IConnectionAuthenticator connectionAuthenticator) {
            this.thriftPort = thriftPort;
            this.framedTransportRequired = framedTransportRequired;
            this.timeout = timeout;
            this.connectionAuthenticator = connectionAuthenticator;
        }

        public int getThriftPort() {
            return this.thriftPort;
        }

        public boolean isFramedTransportRequired() {
            return this.framedTransportRequired;
        }

        public int getTimeout() {
            return this.timeout;
        }

        public IConnectionAuthenticator getConnectionAuthenticator() {
            return this.connectionAuthenticator;
        }

        public boolean isTimeoutSet() {
            return this.getTimeout() > 0;
        }
    }
}

