/*
 * Decompiled with CFR 0.152.
 */
package org.scale7.cassandra.pelops;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.cassandra.thrift.KsDef;
import org.apache.cassandra.thrift.TokenRange;
import org.scale7.cassandra.pelops.IConnection;
import org.scale7.cassandra.pelops.IConnectionAuthenticator;
import org.scale7.cassandra.pelops.KeyspaceManager;
import org.scale7.cassandra.pelops.Pelops;
import org.scale7.portability.SystemProxy;
import org.slf4j.Logger;

public class Cluster {
    public static final int DEFAULT_TIMEOUT = 4000;
    private final Logger logger = SystemProxy.getLoggerFromFactory(Cluster.class);
    private String[] nodes;
    private final IConnection.Config connectionConfig;
    private final INodeFilter nodeFilter;
    private boolean dynamicNodeDiscovery = false;
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private final Lock lockRead = this.lock.readLock();
    private final Lock lockWrite = this.lock.writeLock();

    public Cluster(String nodes, int thriftPort) {
        this(Cluster.splitAndTrim(nodes), new IConnection.Config(thriftPort, true, 4000), false);
    }

    public Cluster(String nodes, int thriftPort, IConnectionAuthenticator connectionAuthenticator) {
        this(Cluster.splitAndTrim(nodes), new IConnection.Config(thriftPort, true, 4000, connectionAuthenticator), false);
    }

    public Cluster(String nodes, int thriftPort, boolean dynamicNodeDiscovery) {
        this(Cluster.splitAndTrim(nodes), new IConnection.Config(thriftPort, true, 4000), dynamicNodeDiscovery);
    }

    public Cluster(String nodes, int thriftPort, boolean dynamicNodeDiscovery, IConnectionAuthenticator connectionAuthenticator) {
        this(Cluster.splitAndTrim(nodes), new IConnection.Config(thriftPort, true, 4000, connectionAuthenticator), dynamicNodeDiscovery);
    }

    public Cluster(String nodes, int thriftPort, int timeout, boolean dynamicNodeDiscovery) {
        this(Cluster.splitAndTrim(nodes), new IConnection.Config(thriftPort, true, timeout), dynamicNodeDiscovery);
    }

    public Cluster(String nodes, int thriftPort, int timeout, boolean dynamicNodeDiscovery, IConnectionAuthenticator connectionAuthenticator) {
        this(Cluster.splitAndTrim(nodes), new IConnection.Config(thriftPort, true, timeout, connectionAuthenticator), dynamicNodeDiscovery);
    }

    public Cluster(String nodes, IConnection.Config connectionConfig, boolean dynamicNodeDiscovery) {
        this(Cluster.splitAndTrim(nodes), connectionConfig, dynamicNodeDiscovery);
    }

    public Cluster(String[] nodes, IConnection.Config connectionConfig, boolean dynamicNodeDiscovery) {
        this(nodes, connectionConfig, dynamicNodeDiscovery, (INodeFilter)new AcceptAllNodeFilter());
    }

    public Cluster(String[] nodes, IConnection.Config connectionConfig, boolean dynamicNodeDiscovery, INodeFilter nodeFilter) {
        this.connectionConfig = connectionConfig;
        this.nodeFilter = nodeFilter;
        this.dynamicNodeDiscovery = dynamicNodeDiscovery;
        this.nodes = new HashSet<String>(Arrays.asList(nodes)).toArray(new String[nodes.length]);
        if (!dynamicNodeDiscovery) {
            this.logger.info("Dynamic node discovery is disabled, using {} as a static list of nodes", (Object)Arrays.toString(nodes));
        } else {
            this.logger.info("Dynamic node discovery is enabled, detecting initial list of nodes from {}", (Object)Arrays.toString(nodes));
            this.refresh();
        }
    }

    public Cluster(String nodes, IConnection.Config connectionConfig, boolean dynamicNodeDiscovery, INodeFilter nodeFilter) {
        this(Cluster.splitAndTrim(nodes), connectionConfig, dynamicNodeDiscovery, nodeFilter);
    }

    private static String[] splitAndTrim(String contactNodes) {
        String[] splitContactNodes = contactNodes.split(",");
        for (int i = 0; i < splitContactNodes.length; ++i) {
            splitContactNodes[i] = splitContactNodes[i].trim();
        }
        return splitContactNodes;
    }

    public IConnection.Config getConnectionConfig() {
        return this.connectionConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Node[] getNodes() {
        try {
            this.lockRead.lock();
            Node[] nodes = new Node[this.nodes.length];
            for (int i = 0; i < this.nodes.length; ++i) {
                String hostAddress = this.nodes[i];
                nodes[i] = new Node(hostAddress, this.getConnectionConfig());
            }
            Node[] nodeArray = nodes;
            return nodeArray;
        }
        finally {
            this.lockRead.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh(String keyspace) {
        String[] latestNodes;
        if (!this.dynamicNodeDiscovery) {
            return;
        }
        try {
            latestNodes = keyspace != null ? this.refreshInternal(keyspace) : this.refreshInternal();
        }
        catch (Exception e) {
            this.logger.error("Failed to discover nodes dynamically, using existing list of nodes.  See cause for details...", (Throwable)e);
            return;
        }
        try {
            this.lockWrite.lock();
            this.nodes = latestNodes;
        }
        finally {
            this.lockWrite.unlock();
        }
    }

    public void refresh() {
        this.refresh(null);
    }

    private String[] refreshInternal() throws Exception {
        ClusterKeyspaceManager kspcMngr = new ClusterKeyspaceManager(this);
        List<KsDef> keyspaces = kspcMngr.getKeyspaceNames();
        Iterator<KsDef> k = keyspaces.iterator();
        KsDef appKeyspace = null;
        while (k.hasNext()) {
            KsDef keyspace = k.next();
            if (keyspace.getName().equals("system")) continue;
            appKeyspace = keyspace;
            break;
        }
        if (appKeyspace == null) {
            throw new Exception("Cannot obtain a node list from a ring mapping. No keyspaces are defined for this cluster.");
        }
        return this.refreshInternal(appKeyspace.getName());
    }

    private String[] refreshInternal(String keyspace) throws Exception {
        KeyspaceManager manager = Pelops.createKeyspaceManager(this);
        this.logger.debug("Fetching nodes using keyspace '{}'", (Object)keyspace);
        List<TokenRange> mappings = manager.getKeyspaceRingMappings(keyspace);
        HashSet clusterNodes = new HashSet();
        for (TokenRange tokenRange : mappings) {
            List endPointList = tokenRange.getEndpoints();
            clusterNodes.addAll(endPointList);
        }
        Iterator iterator = clusterNodes.iterator();
        while (iterator.hasNext()) {
            String node = (String)iterator.next();
            this.logger.debug("Checking node '{}' against node filter", (Object)node);
            if (this.nodeFilter.accept(node)) continue;
            this.logger.debug("Removing node '{}' as directed by node filter", (Object)node);
            iterator.remove();
        }
        Object[] nodes = clusterNodes.toArray(new String[clusterNodes.size()]);
        this.logger.debug("Final set of refreshed nodes: {}", (Object)Arrays.toString(nodes));
        return nodes;
    }

    public class ClusterKeyspaceManager
    extends KeyspaceManager {
        public ClusterKeyspaceManager(Cluster cluster2) {
            super(cluster2, 0);
        }
    }

    public static class Node {
        private final String address;
        private final IConnection.Config config;

        public Node(String address, IConnection.Config config) {
            this.address = address;
            this.config = config;
        }

        public String getAddress() {
            return this.address;
        }

        public IConnection.Config getConfig() {
            return this.config;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Node node = (Node)o;
            return this.address.equals(node.address);
        }

        public int hashCode() {
            return this.address.hashCode();
        }

        public String toString() {
            return this.address + ":" + this.config.getThriftPort();
        }
    }

    public static class AcceptAllNodeFilter
    implements INodeFilter {
        @Override
        public boolean accept(String node) {
            return true;
        }
    }

    public static interface INodeFilter {
        public boolean accept(String var1);
    }
}

