/*
 * Decompiled with CFR 0.152.
 */
package com.jayway.jsonpath.internal.filter;

import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.internal.filter.PathTokenFilter;
import com.jayway.jsonpath.spi.JsonProvider;

public class ScanFilter
extends PathTokenFilter {
    public ScanFilter(String condition) {
        super(condition);
    }

    @Override
    public Object filter(Object obj, Configuration configuration) {
        JsonProvider jsonProvider = configuration.getProvider();
        Iterable result = jsonProvider.createArray();
        this.scan(obj, result, jsonProvider);
        return result;
    }

    @Override
    public boolean isArrayFilter() {
        return true;
    }

    @Override
    public Object getRef(Object obj, Configuration configuration) {
        throw new UnsupportedOperationException();
    }

    private void scan(Object container, Object result, JsonProvider jsonProvider) {
        if (jsonProvider.isMap(container)) {
            jsonProvider.setProperty(result, jsonProvider.length(result), container);
        }
        for (Object value : jsonProvider.toIterable(container)) {
            if (!jsonProvider.isContainer(value)) continue;
            this.scan(value, result, jsonProvider);
        }
    }
}

