/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.operation.builder;

import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.util.HashMap;
import org.geotools.geometry.DirectPosition2D;
import org.geotools.referencing.operation.builder.TINTriangle;
import org.geotools.referencing.operation.transform.AbstractMathTransform;
import org.opengis.geometry.DirectPosition;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransform2D;
import org.opengis.referencing.operation.NoninvertibleTransformException;
import org.opengis.referencing.operation.TransformException;

class RubberSheetTransform
extends AbstractMathTransform
implements MathTransform2D {
    private TINTriangle previousTriangle = null;
    private HashMap trianglesToKeysMap;

    public RubberSheetTransform(HashMap trianglesToAffineTransform) {
        this.trianglesToKeysMap = trianglesToAffineTransform;
    }

    public final int getSourceDimensions() {
        return 2;
    }

    public final int getTargetDimensions() {
        return 2;
    }

    public String toString() {
        String lineSeparator = System.getProperty("line.separator", "\n");
        StringBuilder buffer = new StringBuilder();
        for (TINTriangle trian : this.trianglesToKeysMap.keySet()) {
            MathTransform mt = (MathTransform)this.trianglesToKeysMap.get(trian);
            buffer.append(trian.toString());
            buffer.append(lineSeparator);
            buffer.append(mt.toString());
            buffer.append(lineSeparator);
        }
        return buffer.toString();
    }

    public void transform(double[] srcPts, int srcOff, double[] dstPt, int dstOff, int numPts) throws TransformException {
        for (int i = srcOff; i < numPts; ++i) {
            DirectPosition2D pos = new DirectPosition2D(srcPts[2 * i], srcPts[2 * i + 1]);
            TINTriangle triangle = this.searchTriangle(pos);
            AffineTransform AT = (AffineTransform)this.trianglesToKeysMap.get(triangle);
            Point2D dst = AT.transform(pos, null);
            dstPt[2 * i] = dst.getX();
            dstPt[2 * i + 1] = dst.getY();
        }
    }

    private TINTriangle searchTriangle(DirectPosition p) throws TransformException {
        if (this.previousTriangle != null && this.previousTriangle.containsOrIsVertex(p)) {
            return this.previousTriangle;
        }
        for (TINTriangle triangle : this.trianglesToKeysMap.keySet()) {
            if (!triangle.containsOrIsVertex(p)) continue;
            this.previousTriangle = triangle;
            return triangle;
        }
        throw new TransformException("Points are outside the scope");
    }

    public MathTransform2D inverse() throws NoninvertibleTransformException {
        return (MathTransform2D)super.inverse();
    }
}

