/*
 * Decompiled with CFR 0.152.
 */
package org.scale7.collections;

import java.util.Arrays;

public class ShortCopyOnWriteArraySet {
    volatile short[] array;

    public ShortCopyOnWriteArraySet() {
    }

    public ShortCopyOnWriteArraySet(short[] values) {
        this.set(values);
    }

    public void set(short[] values) {
        short[] newArray = Arrays.copyOf(values, values.length);
        Arrays.sort(newArray, 0, newArray.length);
        this.array = newArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean add(short[] values) {
        ShortCopyOnWriteArraySet shortCopyOnWriteArraySet = this;
        synchronized (shortCopyOnWriteArraySet) {
            if (this.array == null) {
                this.set(values);
                return true;
            }
            int newValueCount = 0;
            for (short value : values) {
                if (this.contains(value)) continue;
                ++newValueCount;
            }
            if (newValueCount == 0) {
                return false;
            }
            int newArrayLen = this.array.length + newValueCount;
            short[] newArray = Arrays.copyOf(this.array, newArrayLen);
            int i = this.array.length;
            for (short value : values) {
                if (this.contains(value)) continue;
                newArray[i++] = value;
            }
            Arrays.sort(newArray, 0, newArray.length);
            this.array = newArray;
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(short[] values) {
        ShortCopyOnWriteArraySet shortCopyOnWriteArraySet = this;
        synchronized (shortCopyOnWriteArraySet) {
            if (this.array == null) {
                return false;
            }
            int removeCount = 0;
            for (short rem : values) {
                if (!this.contains(rem)) continue;
                ++removeCount;
            }
            if (removeCount == 0) {
                return false;
            }
            int newArrayLen = this.array.length - removeCount;
            short[] newArray = new short[newArrayLen];
            int copiedIdx = 0;
            for (int i = 0; i < this.array.length; ++i) {
                short existingValue = this.array[i];
                boolean keep = true;
                for (short rem : values) {
                    if (existingValue != rem) continue;
                    keep = false;
                    break;
                }
                if (!keep) continue;
                newArray[copiedIdx++] = existingValue;
            }
            this.array = newArray;
            return true;
        }
    }

    public void clear() {
        this.array = null;
    }

    public boolean contains(short value) {
        if (this.array == null) {
            return false;
        }
        return Arrays.binarySearch(this.array, 0, this.array.length, value) >= 0;
    }

    public int size() {
        if (this.array == null) {
            return 0;
        }
        return this.array.length;
    }

    public short[] toArray() {
        return this.toArray(true);
    }

    public short[] toArray(boolean copy) {
        if (this.array == null) {
            return new short[0];
        }
        if (copy) {
            short[] itemArray = this.array;
            return Arrays.copyOf(itemArray, itemArray.length);
        }
        return this.array;
    }
}

