/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.common.parsers;

import com.google.common.base.CharMatcher;
import com.google.common.base.Strings;
import java.io.InputStream;
import java.util.regex.Pattern;
import org.gbif.api.util.VocabularyUtils;
import org.gbif.api.vocabulary.Country;
import org.gbif.common.parsers.core.EnumParser;

public class CountryParser
extends EnumParser<Country> {
    private static CountryParser singletonObject = null;
    private static final CharMatcher LETTER_MATCHER = CharMatcher.JAVA_LETTER.or(CharMatcher.WHITESPACE).precomputed();
    private static final CharMatcher WHITESPACE_MATCHER = CharMatcher.WHITESPACE.precomputed();
    private static final Pattern REMOVE_OFF_PATTERN = Pattern.compile("off ", 2);

    private CountryParser() {
        super(Country.class, false, new InputStream[0]);
        for (Country c : Country.OFFICIAL_COUNTRIES) {
            this.add(c.name(), c);
            this.add(c.getTitle(), c);
            this.add(c.getIso2LetterCode(), c);
            this.add(c.getIso3LetterCode(), c);
        }
        this.init(CountryParser.class.getResourceAsStream("/dictionaries/parse/countryName.txt"));
    }

    @Override
    protected String normalize(String value) {
        if (value != null) {
            String cleanedCountry = LETTER_MATCHER.retainFrom((CharSequence)value);
            cleanedCountry = REMOVE_OFF_PATTERN.matcher(cleanedCountry).replaceFirst("");
            cleanedCountry = WHITESPACE_MATCHER.trimAndCollapseFrom((CharSequence)cleanedCountry, ' ');
            cleanedCountry = Strings.emptyToNull((String)cleanedCountry);
            return super.normalize(cleanedCountry);
        }
        return null;
    }

    @Override
    protected Country fromDictFile(String value) {
        Country c = Country.fromIsoCode((String)value);
        if (c == null) {
            try {
                c = (Country)VocabularyUtils.lookupEnum((String)value, Country.class);
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }
        return c;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CountryParser getInstance() {
        Class<CountryParser> clazz = CountryParser.class;
        synchronized (CountryParser.class) {
            if (singletonObject == null) {
                singletonObject = new CountryParser();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return singletonObject;
        }
    }
}

