/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public abstract class LZWDecompresser {
    private final boolean maskMeansCompressed;
    private final int codeLengthIncrease;

    protected LZWDecompresser(boolean maskMeansCompressed, int codeLengthIncrease) {
        this.maskMeansCompressed = maskMeansCompressed;
        this.codeLengthIncrease = codeLengthIncrease;
    }

    protected abstract void populateDictionary(byte[] var1);

    protected abstract int adjustDictionaryOffset(int var1);

    public byte[] decompress(InputStream src) throws IOException {
        ByteArrayOutputStream res = new ByteArrayOutputStream();
        this.decompress(src, res);
        return res.toByteArray();
    }

    public void decompress(InputStream src, OutputStream res) throws IOException {
        int flag;
        byte[] buffer = new byte[4096];
        this.populateDictionary(buffer);
        int pos = 0;
        byte[] dataB = new byte[19];
        block0: while ((flag = src.read()) != -1) {
            for (int mask = 1; mask < 256; mask <<= 1) {
                boolean isMaskSet;
                boolean bl = isMaskSet = (flag & mask) > 0;
                if (isMaskSet && !this.maskMeansCompressed) {
                    int dataI = src.read();
                    if (dataI == -1) continue;
                    buffer[pos & 0xFFF] = LZWDecompresser.fromInt(dataI);
                    ++pos;
                    res.write(new byte[]{LZWDecompresser.fromInt(dataI)});
                    continue;
                }
                int dataIPt1 = src.read();
                int dataIPt2 = src.read();
                if (dataIPt1 == -1 || dataIPt2 == -1) continue block0;
                int len = (dataIPt2 & 0xF) + this.codeLengthIncrease;
                int pntr = (dataIPt2 & 0xF0) * 16 + dataIPt1;
                pntr = this.adjustDictionaryOffset(pntr);
                for (int i = 0; i < len; ++i) {
                    dataB[i] = buffer[pntr + i & 0xFFF];
                    buffer[pos + i & 0xFFF] = dataB[i];
                }
                res.write(dataB, 0, len);
                pos += len;
            }
        }
    }

    public static byte fromInt(int b) {
        if (b < 128) {
            return (byte)b;
        }
        return (byte)(b - 256);
    }

    public static int fromByte(byte b) {
        if (b >= 0) {
            return b;
        }
        return b + 256;
    }
}

