/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.diskdv;

import java.io.IOException;
import org.apache.lucene.codecs.DocValuesConsumer;
import org.apache.lucene.codecs.DocValuesFormat;
import org.apache.lucene.codecs.DocValuesProducer;
import org.apache.lucene.codecs.diskdv.DiskDocValuesConsumer;
import org.apache.lucene.codecs.diskdv.DiskDocValuesProducer;
import org.apache.lucene.index.SegmentReadState;
import org.apache.lucene.index.SegmentWriteState;

public final class DiskDocValuesFormat
extends DocValuesFormat {
    public static final String DATA_CODEC = "DiskDocValuesData";
    public static final String DATA_EXTENSION = "dvdd";
    public static final String META_CODEC = "DiskDocValuesMetadata";
    public static final String META_EXTENSION = "dvdm";
    public static final int VERSION_START = 0;
    public static final int VERSION_CURRENT = 0;
    public static final byte NUMERIC = 0;
    public static final byte BINARY = 1;
    public static final byte SORTED = 2;
    public static final byte SORTED_SET = 3;

    public DiskDocValuesFormat() {
        super("Disk");
    }

    public DocValuesConsumer fieldsConsumer(SegmentWriteState state) throws IOException {
        return new DiskDocValuesConsumer(state, DATA_CODEC, DATA_EXTENSION, META_CODEC, META_EXTENSION);
    }

    public DocValuesProducer fieldsProducer(SegmentReadState state) throws IOException {
        return new DiskDocValuesProducer(state, DATA_CODEC, DATA_EXTENSION, META_CODEC, META_EXTENSION);
    }
}

