/*
 * Decompiled with CFR 0.152.
 */
package org.gbif.api.vocabulary;

import com.google.common.base.Strings;

public enum NameType {
    SCINAME,
    WELLFORMED,
    DOUBTFUL,
    BLACKLISTED,
    VIRUS,
    HYBRID,
    INFORMAL,
    CULTIVAR,
    CANDIDATUS;


    public static NameType fromString(String nameType) {
        if (!Strings.isNullOrEmpty((String)nameType)) {
            try {
                return NameType.valueOf(nameType.toUpperCase().trim());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return null;
    }

    public boolean isBetterThan(NameType other) {
        if (other == null) {
            return true;
        }
        if (BLACKLISTED != this) {
            if (INFORMAL == this && BLACKLISTED == other) {
                return true;
            }
            if (DOUBTFUL == this && (BLACKLISTED == other || INFORMAL == other)) {
                return true;
            }
            if (!(SCINAME != this && VIRUS != this && HYBRID != this || BLACKLISTED != other && INFORMAL != other && DOUBTFUL != other)) {
                return true;
            }
            if (WELLFORMED == this && WELLFORMED != other) {
                return true;
            }
        }
        return false;
    }

    public boolean isParsable() {
        return this != HYBRID && VIRUS != this && BLACKLISTED != this;
    }
}

